/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionBuilder$;
import org.apache.spark.sql.SparkSessionCompanion;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import org.sparkproject.connect.guava.cache.CacheLoader;
import org.sparkproject.connect.guava.cache.LoadingCache;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

public final class SparkSession$
extends SparkSessionCompanion
implements Logging,
Serializable {
    public static final SparkSession$ MODULE$ = new SparkSession$();
    private static final int MAX_CACHED_SESSIONS;
    private static final AtomicLong org$apache$spark$sql$connect$SparkSession$$planIdGenerator;
    private static Option<Process> org$apache$spark$sql$connect$SparkSession$$server;
    private static final Option<Path> maybeConnectStartScript;
    private static final Option<Path> org$apache$spark$sql$connect$SparkSession$$maybeConnectStopScript;
    private static final scala.collection.immutable.Map<String, String> sparkOptions;
    private static final LoadingCache<SparkConnectClient.Configuration, org.apache.spark.sql.connect.SparkSession> org$apache$spark$sql$connect$SparkSession$$sessions;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        MAX_CACHED_SESSIONS = 100;
        org$apache$spark$sql$connect$SparkSession$$planIdGenerator = new AtomicLong();
        org$apache$spark$sql$connect$SparkSession$$server = None$.MODULE$;
        maybeConnectStartScript = Option$.MODULE$.apply((Object)System.getenv("SPARK_HOME")).map((Function1 & Serializable)x$10 -> Paths.get(x$10, "sbin", "start-connect-server.sh"));
        org$apache$spark$sql$connect$SparkSession$$maybeConnectStopScript = Option$.MODULE$.apply((Object)System.getenv("SPARK_HOME")).map((Function1 & Serializable)x$11 -> Paths.get(x$11, "sbin", "stop-connect-server.sh"));
        sparkOptions = ((IterableOnceOps)scala.sys.package$.MODULE$.props().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SparkSession$.$anonfun$sparkOptions$1(p)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        org$apache$spark$sql$connect$SparkSession$$sessions = CacheBuilder.newBuilder().weakValues().maximumSize(MODULE$.MAX_CACHED_SESSIONS()).build(new CacheLoader<SparkConnectClient.Configuration, org.apache.spark.sql.connect.SparkSession>(){

            public org.apache.spark.sql.connect.SparkSession load(SparkConnectClient.Configuration c) {
                return SparkSession$.MODULE$.create(c);
            }
        });
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int MAX_CACHED_SESSIONS() {
        return MAX_CACHED_SESSIONS;
    }

    public AtomicLong org$apache$spark$sql$connect$SparkSession$$planIdGenerator() {
        return org$apache$spark$sql$connect$SparkSession$$planIdGenerator;
    }

    public Option<Process> org$apache$spark$sql$connect$SparkSession$$server() {
        return org$apache$spark$sql$connect$SparkSession$$server;
    }

    public void org$apache$spark$sql$connect$SparkSession$$server_$eq(Option<Process> x$1) {
        org$apache$spark$sql$connect$SparkSession$$server = x$1;
    }

    private Option<Path> maybeConnectStartScript() {
        return maybeConnectStartScript;
    }

    public Option<Path> org$apache$spark$sql$connect$SparkSession$$maybeConnectStopScript() {
        return org$apache$spark$sql$connect$SparkSession$$maybeConnectStopScript;
    }

    public scala.collection.immutable.Map<String, String> sparkOptions() {
        return sparkOptions;
    }

    public LoadingCache<SparkConnectClient.Configuration, org.apache.spark.sql.connect.SparkSession> org$apache$spark$sql$connect$SparkSession$$sessions() {
        return org$apache$spark$sql$connect$SparkSession$$sessions;
    }

    private void waitUntilFileExists(File file) {
        Object object = new Object();
        try {
            Deadline deadline = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds().fromNow();
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                file.toPath().getParent().register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
                while (!file.exists() && deadline.hasTimeLeft()) {
                    Option option = Option$.MODULE$.apply((Object)watchService.poll(deadline.timeLeft().toSeconds() + 1L, TimeUnit.SECONDS));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        WatchKey key = (WatchKey)some.value();
                        key.pollEvents().forEach(event -> {
                            WatchEvent.Kind kind = event.kind();
                            Path filename = (Path)event.context();
                            WatchEvent.Kind kind2 = kind;
                            WatchEvent.Kind<Path> kind3 = StandardWatchEventKinds.ENTRY_CREATE;
                            if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
                                String string = ((Object)filename).toString();
                                String string2 = ((Object)file.toPath().getFileName()).toString();
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    key.cancel();
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                            }
                        });
                        BoxesRunTime.boxToBoolean((boolean)key.reset());
                        continue;
                    }
                    if (None$.MODULE$.equals(option)) {
                        continue;
                    }
                    throw new MatchError((Object)option);
                }
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public <T> T withLocalConnectServer(Function0<T> f) {
        LazyBoolean isAPIModeConnect$lzy = new LazyBoolean();
        LazyRef serverId$lzy = new LazyRef();
        Option remoteString = this.sparkOptions().get((Object)"spark.remote").orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getProperty("spark.remote"))).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)SparkConnectClient$.MODULE$.SPARK_REMOTE())).orElse((Function0 & Serializable)() -> {
            if (SparkSession$.isAPIModeConnect$1(isAPIModeConnect$lzy)) {
                return MODULE$.sparkOptions().get((Object)"spark.master").orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"MASTER"));
            }
            return None$.MODULE$;
        });
        Option<Process> option = this.org$apache$spark$sql$connect$SparkSession$$server();
        synchronized (option) {
            if (this.org$apache$spark$sql$connect$SparkSession$$server().isEmpty() && (remoteString.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.startsWith("local"))) || remoteString.isDefined() && SparkSession$.isAPIModeConnect$1(isAPIModeConnect$lzy)) && this.maybeConnectStartScript().exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SparkSession$.$anonfun$withLocalConnectServer$7(x$13)))) {
                String token = UUID.randomUUID().toString();
                Seq args = (Seq)new .colon.colon((Object)this.maybeConnectStartScript().get().toString(), (List)new .colon.colon((Object)"--master", (List)new .colon.colon((Object)((String)remoteString.get()), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)((IterableOps)((IterableOps)this.sparkOptions().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.artifact.isolation.enabled"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.artifact.isolation.alwaysApplyClassloader"), (Object)"true")}))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SparkSession$.$anonfun$withLocalConnectServer$8(p)))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SparkSession$.$anonfun$withLocalConnectServer$9(p)))).flatMap((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return new .colon.colon((Object)"--conf", (List)new .colon.colon((Object)(k + "=" + v), (List)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)tuple2);
                }));
                ProcessBuilder pb = new ProcessBuilder((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
                pb.environment().remove(SparkConnectClient$.MODULE$.SPARK_REMOTE());
                pb.environment().put("SPARK_CONNECT_MODE", "0");
                pb.environment().put("SPARK_IDENT_STRING", SparkSession$.org$apache$spark$sql$connect$SparkSession$$serverId$1(serverId$lzy));
                pb.environment().put("HOSTNAME", "local");
                pb.environment().put("SPARK_CONNECT_AUTHENTICATE_TOKEN", token);
                this.org$apache$spark$sql$connect$SparkSession$$server_$eq((Option<Process>)new Some((Object)pb.start()));
                Option$.MODULE$.apply((Object)System.getenv("SPARK_LOG_DIR")).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getenv("SPARK_HOME")).map((Function1 & Serializable)p -> ((Object)Paths.get(p, "logs")).toString())).foreach((Function1 & Serializable)p -> {
                    SparkSession$.$anonfun$withLocalConnectServer$13(serverId$lzy, p);
                    return BoxedUnit.UNIT;
                });
                Thread.sleep(1000L);
                System.setProperty("spark.remote", "sc://localhost/;token=" + token);
                Runtime.getRuntime().addShutdownHook(new Thread(serverId$lzy){
                    private final LazyRef serverId$lzy$1;

                    public void run() {
                        Option<Process> option = SparkSession$.MODULE$.org$apache$spark$sql$connect$SparkSession$$server();
                        synchronized (option) {
                            if (SparkSession$.MODULE$.org$apache$spark$sql$connect$SparkSession$$server().isDefined()) {
                                ProcessBuilder builder = new ProcessBuilder(SparkSession$.MODULE$.org$apache$spark$sql$connect$SparkSession$$maybeConnectStopScript().get().toString());
                                builder.environment().put("SPARK_IDENT_STRING", SparkSession$.org$apache$spark$sql$connect$SparkSession$$serverId$1(this.serverId$lzy$1));
                                v0 = builder.start();
                            } else {
                                v0 = BoxedUnit.UNIT;
                            }
                        }
                    }
                    {
                        this.serverId$lzy$1 = serverId$lzy$1;
                    }
                });
            }
        }
        return (T)f.apply();
    }

    public org.apache.spark.sql.connect.SparkSession create(SparkConnectClient.Configuration configuration) {
        return new org.apache.spark.sql.connect.SparkSession(configuration.toSparkConnectClient(), this.org$apache$spark$sql$connect$SparkSession$$planIdGenerator());
    }

    public SparkSession.Builder builder() {
        return new SparkSession.Builder();
    }

    public Option<org.apache.spark.sql.connect.SparkSession> getActiveSession() {
        return super.getActiveSession();
    }

    public Option<org.apache.spark.sql.connect.SparkSession> getDefaultSession() {
        return super.getDefaultSession();
    }

    public org.apache.spark.sql.connect.SparkSession active() {
        return (org.apache.spark.sql.connect.SparkSession)super.active();
    }

    public Option<org.apache.spark.sql.connect.SparkSession> tryCastToImplementation(SparkSession session) {
        SparkSession sparkSession = session;
        if (sparkSession instanceof org.apache.spark.sql.connect.SparkSession) {
            org.apache.spark.sql.connect.SparkSession sparkSession2 = (org.apache.spark.sql.connect.SparkSession)sparkSession;
            return new Some((Object)sparkSession2);
        }
        return None$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SparkSession$.class);
    }

    public static final /* synthetic */ boolean $anonfun$sparkOptions$1(Tuple2 p) {
        return ((String)p._1()).startsWith("spark.") && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)p._2()));
    }

    public static final /* synthetic */ String $anonfun$withLocalConnectServer$1() {
        return "classic";
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ boolean isAPIModeConnect$lzycompute$1(LazyBoolean isAPIModeConnect$lzy$1) {
        var1_1 = isAPIModeConnect$lzy$1;
        synchronized (var1_1) {
            block6: {
                block5: {
                    if (!isAPIModeConnect$lzy$1.initialized()) break block5;
                    v0 = isAPIModeConnect$lzy$1.value();
                    break block6;
                }
                v1 = ((String)Option$.MODULE$.apply((Object)System.getProperty(SparkSessionBuilder$.MODULE$.API_MODE_KEY())).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$withLocalConnectServer$1(), ()Ljava/lang/String;)())).toLowerCase(Locale.ROOT);
                var3_2 = "connect";
                if (!(v1 == null ? var3_2 != null : v1.equals(var3_2) == false)) ** GOTO lbl-1000
                v2 = System.getenv("SPARK_CONNECT_MODE");
                var4_3 = "1";
                if (!(v2 != null ? v2.equals(var4_3) == false : var4_3 != null)) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                v0 = isAPIModeConnect$lzy$1.initialize(v3);
            }
            var2_4 = v0;
        }
        return var2_4;
    }

    private static final boolean isAPIModeConnect$1(LazyBoolean isAPIModeConnect$lzy$1) {
        if (isAPIModeConnect$lzy$1.initialized()) {
            return isAPIModeConnect$lzy$1.value();
        }
        return SparkSession$.isAPIModeConnect$lzycompute$1(isAPIModeConnect$lzy$1);
    }

    private static final /* synthetic */ String serverId$lzycompute$1(LazyRef serverId$lzy$1) {
        String string;
        LazyRef lazyRef = serverId$lzy$1;
        synchronized (lazyRef) {
            string = serverId$lzy$1.initialized() ? (String)serverId$lzy$1.value() : (String)serverId$lzy$1.initialize((Object)UUID.randomUUID().toString());
        }
        return string;
    }

    public static final String org$apache$spark$sql$connect$SparkSession$$serverId$1(LazyRef serverId$lzy$1) {
        if (serverId$lzy$1.initialized()) {
            return (String)serverId$lzy$1.value();
        }
        return SparkSession$.serverId$lzycompute$1(serverId$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$withLocalConnectServer$7(Path x$13) {
        return Files.exists(x$13, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean $anonfun$withLocalConnectServer$8(Tuple2 p) {
        return !((String)p._1()).startsWith("spark.remote");
    }

    public static final /* synthetic */ boolean $anonfun$withLocalConnectServer$9(Tuple2 p) {
        return !((String)p._1()).startsWith("spark.api.mode");
    }

    public static final /* synthetic */ void $anonfun$withLocalConnectServer$13(LazyRef serverId$lzy$1, String p) {
        Files.createDirectories(Paths.get(p, new String[0]), new FileAttribute[0]);
        File logFile = Paths.get(p, "spark-" + SparkSession$.org$apache$spark$sql$connect$SparkSession$$serverId$1(serverId$lzy$1) + "-org.apache.spark.sql.connect.service.SparkConnectServer-1-local.out").toFile();
        MODULE$.waitUntilFileExists(logFile);
        if (logFile.exists()) {
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Connect server started with the log file: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, logFile)}))));
            return;
        }
        MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Connect server log not found at ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, logFile)}))));
    }

    private SparkSession$() {
    }
}

