/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationType;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;

public final class HiveThriftServerErrors$ {
    public static final HiveThriftServerErrors$ MODULE$ = new HiveThriftServerErrors$();

    public Throwable taskExecutionRejectedError(RejectedExecutionException rejected) {
        return new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
    }

    public Throwable runningQueryError(Throwable e2, Enumeration.Value format) {
        Throwable throwable = e2;
        if (throwable instanceof SparkThrowable) {
            Throwable throwable2 = throwable;
            Enumeration.Value value = format;
            Enumeration.Value value2 = ErrorMessageFormat$.MODULE$.PRETTY();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                String errorClassPrefix = (String)Option$.MODULE$.apply((Object)((SparkThrowable)throwable2).getCondition()).map((Function1 & Serializable)e -> "[" + e + "] ").getOrElse((Function0 & Serializable)() -> "");
                return new HiveSQLException("Error running query: " + errorClassPrefix + throwable2.toString(), ((SparkThrowable)throwable2).getSqlState(), throwable2);
            }
        }
        if (throwable instanceof SparkThrowable) {
            Throwable throwable3 = throwable;
            return new HiveSQLException(SparkThrowableHelper$.MODULE$.getMessage(throwable3, format), ((SparkThrowable)throwable3).getSqlState(), throwable3);
        }
        return new HiveSQLException("Error running query: " + e2.toString(), e2);
    }

    public Throwable hiveOperatingError(OperationType operationType, Throwable e) {
        return new HiveSQLException("Error operating " + operationType + " " + e.getMessage(), e);
    }

    public Throwable failedToOpenNewSessionError(Throwable e) {
        return new HiveSQLException("Failed to open new session: " + e, e);
    }

    public Throwable cannotLoginToKerberosError(Throwable e) {
        return new ServiceException("Unable to login to kerberos with given principal/keytab", e);
    }

    public Throwable cannotLoginToSpnegoError(String principal, String keyTabFile, IOException e) {
        return new ServiceException("Unable to login to spnego with given principal " + principal + " and keytab " + keyTabFile + ": " + e, e);
    }

    public Throwable failedToStartServiceError(String serviceName, Throwable e) {
        return new ServiceException("Failed to Start " + serviceName, e);
    }

    private HiveThriftServerErrors$() {
    }
}

