/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.InputFileBlockHolder$;
import org.apache.spark.sql.catalyst.FileSourceOptions;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2$;
import org.apache.spark.sql.execution.datasources.v2.PartitionedFileReader;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}4A!\u0004\b\u0001;!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!A\u0006A!A!\u0002\u0013I\u0006\"B0\u0001\t\u0003\u0001\u0007b\u00024\u0001\u0001\u0004%Ia\u001a\u0005\bW\u0002\u0001\r\u0011\"\u0003m\u0011\u0019\u0011\b\u0001)Q\u0005Q\")1\u000f\u0001C\u0005i\")\u0001\u0010\u0001C\u0005i\")\u0011\u0010\u0001C!u\")1\u0010\u0001C!y\")Q\u0010\u0001C!}\n\u0019b)\u001b7f!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe*\u0011q\u0002E\u0001\u0003mJR!!\u0005\n\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003'Q\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005U1\u0012aA:rY*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005y\t4\u0003\u0002\u0001 Ou\u0002\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0004PE*,7\r\u001e\t\u0004Q5zS\"A\u0015\u000b\u0005)Z\u0013\u0001\u0002:fC\u0012T!\u0001\f\u000b\u0002\u0013\r|gN\\3di>\u0014\u0018B\u0001\u0018*\u0005=\u0001\u0016M\u001d;ji&|gNU3bI\u0016\u0014\bC\u0001\u00192\u0019\u0001!QA\r\u0001C\u0002M\u0012\u0011\u0001V\t\u0003ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012qAT8uQ&tw\r\u0005\u00026w%\u0011AH\u000e\u0002\u0004\u0003:L\bC\u0001 B\u001b\u0005y$B\u0001!\u0017\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\"@\u0005\u001daunZ4j]\u001e\fQAZ5mKN\u00042!R'Q\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002J9\u00051AH]8pizJ\u0011aN\u0005\u0003\u0019Z\nq\u0001]1dW\u0006<W-\u0003\u0002O\u001f\nA\u0011\n^3sCR|'O\u0003\u0002MmA\u0011\u0011KU\u0007\u0002!%\u00111\u000b\u0005\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mK\u0006Y!-^5mIJ+\u0017\rZ3s!\u0011)d\u000bU\u0014\n\u0005]3$!\u0003$v]\u000e$\u0018n\u001c82\u0003\u001dy\u0007\u000f^5p]N\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u000b\u0002\u0011\r\fG/\u00197zgRL!AX.\u0003#\u0019KG.Z*pkJ\u001cWm\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0005C\u000e$W\rE\u0002c\u0001=j\u0011A\u0004\u0005\u0006\u0007\u0012\u0001\r\u0001\u0012\u0005\u0006)\u0012\u0001\r!\u0016\u0005\u00061\u0012\u0001\r!W\u0001\u000eGV\u0014(/\u001a8u%\u0016\fG-\u001a:\u0016\u0003!\u00042AY50\u0013\tQgBA\u000bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f%\u0016\fG-\u001a:\u0002#\r,(O]3oiJ+\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0002naB\u0011QG\\\u0005\u0003_Z\u0012A!\u00168ji\"9\u0011OBA\u0001\u0002\u0004A\u0017a\u0001=%c\u0005q1-\u001e:sK:$(+Z1eKJ\u0004\u0013AE5h]>\u0014X-T5tg&twMR5mKN,\u0012!\u001e\t\u0003kYL!a\u001e\u001c\u0003\u000f\t{w\u000e\\3b]\u0006\u0011\u0012n\u001a8pe\u0016\u001cuN\u001d:vaR4\u0015\u000e\\3t\u0003\u0011qW\r\u001f;\u0015\u0003U\f1aZ3u)\u0005y\u0013!B2m_N,G#A7")
public class FilePartitionReader<T>
implements PartitionReader<T>,
Logging {
    private final Iterator<PartitionedFile> files;
    private final Function1<PartitionedFile, PartitionReader<T>> buildReader;
    private final FileSourceOptions options;
    private PartitionedFileReader<T> currentReader;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private PartitionedFileReader<T> currentReader() {
        return this.currentReader;
    }

    private void currentReader_$eq(PartitionedFileReader<T> x$1) {
        this.currentReader = x$1;
    }

    private boolean ignoreMissingFiles() {
        return this.options.ignoreMissingFiles();
    }

    private boolean ignoreCorruptFiles() {
        return this.options.ignoreCorruptFiles();
    }

    public boolean next() {
        boolean bl;
        if (this.currentReader() == null) {
            if (this.files.hasNext()) {
                PartitionedFile file = (PartitionedFile)this.files.next();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reading file ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CURRENT_FILE, file)}))));
                InputFileBlockHolder$.MODULE$.set(file.urlEncodedPath(), file.start(), file.length());
                try {
                    this.currentReader_$eq(new PartitionedFileReader(file, (PartitionReader)this.buildReader.apply((Object)file)));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        FileNotFoundException fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.ignoreMissingFiles()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped missing file.", (Throwable)fileNotFoundException);
                            this.currentReader_$eq(null);
                        }
                    }
                    if (throwable2 instanceof AccessControlException ? true : throwable2 instanceof BlockMissingException) {
                        throw FileDataSourceV2$.MODULE$.attachFilePath((Function0<String>)(Function0 & Serializable)() -> file.urlEncodedPath(), throwable2);
                    }
                    if (this.ignoreCorruptFiles() && DataSourceUtils$.MODULE$.shouldIgnoreCorruptFileException(throwable2)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the rest of the content in the corrupted file.", throwable2);
                        this.currentReader_$eq(null);
                    }
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        throw FileDataSourceV2$.MODULE$.attachFilePath((Function0<String>)(Function0 & Serializable)() -> file.urlEncodedPath(), throwable3);
                    }
                    throw throwable;
                }
            } else {
                return false;
            }
        }
        try {
            bl = this.currentReader() != null && this.currentReader().next();
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (throwable4 instanceof AccessControlException ? true : throwable4 instanceof BlockMissingException) {
                throw FileDataSourceV2$.MODULE$.attachFilePath((Function0<String>)(Function0 & Serializable)() -> this.currentReader().file().urlEncodedPath(), throwable4);
            }
            if (this.ignoreCorruptFiles() && DataSourceUtils$.MODULE$.shouldIgnoreCorruptFileException(throwable4)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped the rest of the content in the corrupted file: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PARTITIONED_FILE_READER, this.currentReader())})))), throwable4);
                bl = false;
            }
            if (throwable4 != null) {
                Throwable throwable5 = throwable4;
                throw FileDataSourceV2$.MODULE$.attachFilePath((Function0<String>)(Function0 & Serializable)() -> this.currentReader().file().urlEncodedPath(), throwable5);
            }
            throw throwable;
        }
        boolean hasNext = bl;
        if (hasNext) {
            return true;
        }
        this.close();
        this.currentReader_$eq(null);
        return this.next();
    }

    public T get() {
        return this.currentReader().get();
    }

    public void close() {
        if (this.currentReader() != null) {
            this.currentReader().close();
        }
        InputFileBlockHolder$.MODULE$.unset();
    }

    public FilePartitionReader(Iterator<PartitionedFile> files, Function1<PartitionedFile, PartitionReader<T>> buildReader, FileSourceOptions options) {
        this.files = files;
        this.buildReader = buildReader;
        this.options = options;
        Logging.$init$((Logging)this);
        this.currentReader = null;
    }
}

