/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.immutable;

import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.Hashing$;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.immutable.BitmapIndexedMapNode;
import coursierapi.shaded.scala.collection.immutable.ChampBaseIterator;
import coursierapi.shaded.scala.collection.immutable.HashCollisionMapNode;
import coursierapi.shaded.scala.collection.immutable.HashMap;
import coursierapi.shaded.scala.collection.immutable.HashMap$;
import coursierapi.shaded.scala.collection.immutable.Map;
import coursierapi.shaded.scala.collection.immutable.MapNode;
import coursierapi.shaded.scala.collection.immutable.Node;
import coursierapi.shaded.scala.collection.immutable.Node$;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.collection.mutable.Growable;
import coursierapi.shaded.scala.collection.mutable.HashMap;
import coursierapi.shaded.scala.collection.mutable.LinkedHashMap;
import coursierapi.shaded.scala.collection.mutable.ReusableBuilder;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;

public final class HashMapBuilder<K, V>
implements ReusableBuilder<Tuple2<K, V>, HashMap<K, V>> {
    private HashMap<K, V> aliased;
    private BitmapIndexedMapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode = this.newEmptyRootNode();

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<HashMap<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable<Tuple2<K, V>> $plus$plus$eq(IterableOnce<Tuple2<K, V>> elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    private BitmapIndexedMapNode<K, V> newEmptyRootNode() {
        return new BitmapIndexedMapNode(0, 0, Array$.MODULE$.emptyObjectArray(), Array$.MODULE$.emptyIntArray(), 0, 0);
    }

    private HashMap<K, V> aliased() {
        return this.aliased;
    }

    private void aliased_$eq(HashMap<K, V> x$1) {
        this.aliased = x$1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public BitmapIndexedMapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode;
    }

    private void rootNode_$eq(BitmapIndexedMapNode<K, V> x$1) {
        this.scala$collection$immutable$HashMapBuilder$$rootNode = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public <V0> V0 getOrElse(K key, V0 value) {
        void getOrElse_shift;
        void getOrElse_keyHash;
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() == 0) {
            return value;
        }
        int originalHash = Statics.anyHash(key);
        BitmapIndexedMapNode<K, V> bitmapIndexedMapNode = this.scala$collection$immutable$HashMapBuilder$$rootNode();
        Function0<Object> & Serializable intersect = (Function0<Object> & Serializable)() -> value;
        boolean bl = false;
        int n = Hashing$.MODULE$.improve(originalHash);
        if (bitmapIndexedMapNode == null) {
            throw null;
        }
        BitmapIndexedMapNode<K, V> getOrElse_this = bitmapIndexedMapNode;
        int getOrElse_mask = getOrElse_keyHash >>> getOrElse_shift & 0x1F;
        int getOrElse_bitpos = 1 << getOrElse_mask;
        if ((getOrElse_this.dataMap() & getOrElse_bitpos) != 0) {
            int getOrElse_index = Node$.MODULE$.indexFrom(getOrElse_this.dataMap(), getOrElse_mask, getOrElse_bitpos);
            Object getOrElse_key0 = getOrElse_this.content()[2 * getOrElse_index];
            if (BoxesRunTime.equals(key, getOrElse_key0)) {
                return (V0)getOrElse_this.content()[2 * getOrElse_index + 1];
            }
            return value;
        }
        if ((getOrElse_this.nodeMap() & getOrElse_bitpos) != 0) {
            void getOrElse_f;
            int getOrElse_index = Node$.MODULE$.indexFrom(getOrElse_this.nodeMap(), getOrElse_mask, getOrElse_bitpos);
            return (V0)((MapNode)getOrElse_this.getNode(getOrElse_index)).getOrElse(key, originalHash, (int)getOrElse_keyHash, (int)(getOrElse_shift + 5), getOrElse_f);
        }
        return value;
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <V1> void insertValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K key, int originalHash, int keyHash, V1 value) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    public void update(MapNode<K, V> mapNode, K key, V value, int originalHash, int keyHash, int shift) {
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            int mask = keyHash >>> shift & 0x1F;
            int bitpos = 1 << mask;
            if ((bitmapIndexedMapNode.dataMap() & bitpos) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.dataMap(), mask, bitpos);
                Object key0 = bitmapIndexedMapNode.content()[2 * index];
                int key0UnimprovedHash = bitmapIndexedMapNode.originalHashes()[index];
                if (key0UnimprovedHash == originalHash && BoxesRunTime.equals(key0, key)) {
                    bitmapIndexedMapNode.content()[2 * index + 1] = value;
                    return;
                }
                Object value0 = bitmapIndexedMapNode.content()[2 * index + 1];
                int key0Hash = Hashing$.MODULE$.improve(key0UnimprovedHash);
                MapNode<Object, Object> subNodeNew = bitmapIndexedMapNode.mergeTwoKeyValPairs(key0, value0, key0UnimprovedHash, key0Hash, key, value, originalHash, keyHash, shift + 5);
                bitmapIndexedMapNode.migrateFromInlineToNodeInPlace(bitpos, key0Hash, subNodeNew);
                return;
            }
            if ((bitmapIndexedMapNode.nodeMap() & bitpos) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.nodeMap(), mask, bitpos);
                Node subNode = bitmapIndexedMapNode.getNode(index);
                int beforeSize = ((MapNode)subNode).size();
                int beforeHash = subNode.cachedJavaKeySetHashCode();
                this.update((MapNode<K, V>)subNode, key, value, originalHash, keyHash, shift + 5);
                bitmapIndexedMapNode.size_$eq(bitmapIndexedMapNode.size() + (((MapNode)subNode).size() - beforeSize));
                bitmapIndexedMapNode.cachedJavaKeySetHashCode_$eq(bitmapIndexedMapNode.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHash));
                return;
            }
            this.insertValue(bitmapIndexedMapNode, bitpos, key, originalHash, keyHash, value);
            return;
        }
        if (mapNode instanceof HashCollisionMapNode) {
            HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)mapNode;
            int index = hashCollisionMapNode.indexOf(key);
            if (index < 0) {
                hashCollisionMapNode.content_$eq(hashCollisionMapNode.content().appended(new Tuple2<K, V>(key, value)));
                return;
            }
            hashCollisionMapNode.content_$eq(hashCollisionMapNode.content().updated(index, new Tuple2<K, V>(key, value)));
            return;
        }
        throw new MatchError(mapNode);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        this.rootNode_$eq((BitmapIndexedMapNode<K, V>)this.scala$collection$immutable$HashMapBuilder$$rootNode().copy());
    }

    @Override
    public HashMap<K, V> result() {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() == 0) {
            return HashMap$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashMap<K, V>(this.scala$collection$immutable$HashMapBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    public HashMapBuilder<K, V> addOne(Tuple2<K, V> elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem._1());
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), elem._1(), elem._2(), h, im, 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value) {
        this.ensureUnaliased();
        int originalHash = Statics.anyHash(key);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), key, value, originalHash, Hashing$.MODULE$.improve(originalHash), 0);
        return this;
    }

    public HashMapBuilder<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashMap) {
            HashMap hashMap = (HashMap)xs;
            new ChampBaseIterator<Tuple2<K, V>, MapNode<K, V>>(this, hashMap){

                public Nothing$ next() {
                    return Iterator$.scala$collection$Iterator$$_empty.next();
                }
                {
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashMapBuilder$$rootNode(), ((MapNode)this.currentValueNode()).getKey(this.currentValueCursor()), ((MapNode)this.currentValueNode()).getValue(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }
            };
        } else if (xs instanceof coursierapi.shaded.scala.collection.mutable.HashMap) {
            coursierapi.shaded.scala.collection.mutable.HashMap hashMap = (coursierapi.shaded.scala.collection.mutable.HashMap)xs;
            Iterator iter = hashMap.nodeIterator();
            while (iter.hasNext()) {
                HashMap.Node next = iter.next();
                int originalHash = hashMap.unimproveHash(next.hash());
                int hash = Hashing$.MODULE$.improve(originalHash);
                this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), next.key(), next.value(), originalHash, hash, 0);
            }
        } else if (xs instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)xs;
            Iterator iter = linkedHashMap.entryIterator();
            while (iter.hasNext()) {
                LinkedHashMap.LinkedEntry next = iter.next();
                int originalHash = linkedHashMap.unimproveHash(next.hash());
                int hash = Hashing$.MODULE$.improve(originalHash);
                this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), next.key(), next.value(), originalHash, hash, 0);
            }
        } else if (xs instanceof Map) {
            ((Map)xs).foreachEntry((Function2<Object, Object, HashMapBuilder> & Serializable)(key, value) -> this.addOne(key, value));
        } else {
            Iterator<Tuple2<K, V>> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne(it.next());
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased_$eq(null);
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() > 0) {
            this.rootNode_$eq(this.newEmptyRootNode());
            return;
        }
    }
}

