/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;

public final class EventTimeWatermark$
implements Serializable {
    public static final EventTimeWatermark$ MODULE$ = new EventTimeWatermark$();
    private static final String delayKey = "spark.watermarkDelayMs";

    public String delayKey() {
        return delayKey;
    }

    public long getDelayMs(CalendarInterval delay) {
        return IntervalUtils$.MODULE$.getDuration(delay, TimeUnit.MILLISECONDS, IntervalUtils$.MODULE$.getDuration$default$3());
    }

    public Seq<Attribute> updateEventTimeColumn(Seq<Attribute> attributes, long delayMs, Attribute newEventTime) {
        return (Seq)attributes.map((Function1 & Serializable)a -> {
            if (a.semanticEquals(newEventTime)) {
                Metadata updatedMetadata = new MetadataBuilder().withMetadata(a.metadata()).putLong(MODULE$.delayKey(), delayMs).build();
                return a.withMetadata(updatedMetadata);
            }
            if (a.metadata().contains(MODULE$.delayKey())) {
                Metadata updatedMetadata = new MetadataBuilder().withMetadata(a.metadata()).remove(MODULE$.delayKey()).build();
                return a.withMetadata(updatedMetadata);
            }
            return a;
        });
    }

    public EventTimeWatermark apply(UUID nodeId, Attribute eventTime, CalendarInterval delay, LogicalPlan child) {
        return new EventTimeWatermark(nodeId, eventTime, delay, child);
    }

    public Option<Tuple4<UUID, Attribute, CalendarInterval, LogicalPlan>> unapply(EventTimeWatermark x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.nodeId(), (Object)x$0.eventTime(), (Object)x$0.delay(), (Object)x$0.child()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EventTimeWatermark$.class);
    }

    private EventTimeWatermark$() {
    }
}

