/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.KeyWrapperFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.LeadLagInfo;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PTFDeserializer;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFInputDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeadLag;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class PTFOperator
extends Operator<PTFDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean isMapOperator;
    transient KeyWrapperFactory keyWrapperFactory;
    protected transient KeyWrapper currentKeys;
    protected transient KeyWrapper newKeys;
    transient boolean firstMapRow;
    transient Configuration hiveConf;
    transient PTFInvocation ptfInvocation;

    protected PTFOperator() {
    }

    public PTFOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration jobConf) throws HiveException {
        super.initializeOp(jobConf);
        this.hiveConf = jobConf;
        this.isMapOperator = ((PTFDesc)this.conf).isMapSide();
        this.currentKeys = null;
        this.reconstructQueryDef(this.hiveConf);
        if (this.isMapOperator) {
            PartitionedTableFunctionDef tDef = ((PTFDesc)this.conf).getStartOfChain();
            this.outputObjInspector = tDef.getRawInputShape().getOI();
        } else {
            this.outputObjInspector = ((PTFDesc)this.conf).getFuncDef().getOutputShape().getOI();
        }
        this.setupKeysWrapper(this.inputObjInspectors[0]);
        this.ptfInvocation = this.setupChain();
        this.ptfInvocation.initializeStreaming(jobConf, this.isMapOperator);
        this.firstMapRow = true;
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
        this.ptfInvocation.finishPartition();
        this.ptfInvocation.close();
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (!this.isMapOperator) {
            boolean keysAreEqual;
            this.newKeys.getNewKey(row, this.inputObjInspectors[0]);
            boolean bl = keysAreEqual = this.currentKeys != null && this.newKeys != null ? this.newKeys.equals(this.currentKeys) : false;
            if (this.currentKeys != null && !keysAreEqual) {
                this.ptfInvocation.finishPartition();
            }
            if (this.currentKeys == null || !keysAreEqual) {
                this.ptfInvocation.startPartition();
                if (this.currentKeys == null) {
                    this.currentKeys = this.newKeys.copyKey();
                } else {
                    this.currentKeys.copyKey(this.newKeys);
                }
            }
        } else if (this.firstMapRow) {
            this.ptfInvocation.startPartition();
            this.firstMapRow = false;
        }
        this.ptfInvocation.processRow(row);
    }

    protected void reconstructQueryDef(Configuration hiveConf) throws HiveException {
        PTFDeserializer dS = new PTFDeserializer((PTFDesc)this.conf, (StructObjectInspector)this.inputObjInspectors[0], hiveConf);
        dS.initializePTFChain(((PTFDesc)this.conf).getFuncDef());
    }

    protected void setupKeysWrapper(ObjectInspector inputOI) throws HiveException {
        PartitionDef pDef = ((PTFDesc)this.conf).getStartOfChain().getPartition();
        List<PTFExpressionDef> exprs = pDef.getExpressions();
        int numExprs = exprs.size();
        ExprNodeEvaluator[] keyFields = new ExprNodeEvaluator[numExprs];
        ObjectInspector[] keyOIs = new ObjectInspector[numExprs];
        ObjectInspector[] currentKeyOIs = new ObjectInspector[numExprs];
        for (int i = 0; i < numExprs; ++i) {
            PTFExpressionDef exprDef = exprs.get(i);
            keyFields[i] = ExprNodeEvaluatorFactory.get(exprDef.getExprNode());
            keyOIs[i] = keyFields[i].initialize(inputOI);
            currentKeyOIs[i] = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)keyOIs[i], (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        this.keyWrapperFactory = new KeyWrapperFactory(keyFields, keyOIs, currentKeyOIs);
        this.newKeys = this.keyWrapperFactory.getKeyWrapper();
    }

    @Override
    public String getName() {
        return PTFOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "PTF";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.PTF;
    }

    private PTFInvocation setupChain() {
        Stack<PartitionedTableFunctionDef> fnDefs = new Stack<PartitionedTableFunctionDef>();
        PTFInputDef iDef = ((PTFDesc)this.conf).getFuncDef();
        while (iDef instanceof PartitionedTableFunctionDef) {
            fnDefs.push((PartitionedTableFunctionDef)iDef);
            iDef = iDef.getInput();
        }
        PTFInvocation curr = null;
        PTFInvocation first = null;
        while (!fnDefs.isEmpty()) {
            PartitionedTableFunctionDef currFn = (PartitionedTableFunctionDef)fnDefs.pop();
            curr = new PTFInvocation(curr, currFn.getTFunction());
            if (first != null) continue;
            first = curr;
        }
        return first;
    }

    public static void connectLeadLagFunctionsToPartition(LeadLagInfo leadLagInfo, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
        if (leadLagInfo == null || leadLagInfo.getLeadLagExprs() == null) {
            return;
        }
        for (ExprNodeGenericFuncDesc llFnDesc : leadLagInfo.getLeadLagExprs()) {
            GenericUDFLeadLag llFn = (GenericUDFLeadLag)llFnDesc.getGenericUDF();
            llFn.setpItr(pItr);
        }
    }

    class PTFInvocation {
        PTFInvocation prev;
        PTFInvocation next;
        TableFunctionEvaluator tabFn;
        PTFPartition inputPart;
        PTFPartition outputPart;
        Iterator<Object> outputPartRowsItr;

        public PTFInvocation(PTFInvocation prev, TableFunctionEvaluator tabFn) {
            this.prev = prev;
            this.tabFn = tabFn;
            if (prev != null) {
                prev.next = this;
            }
        }

        boolean isOutputIterator() {
            return this.tabFn.canAcceptInputAsStream() || this.tabFn.canIterateOutput();
        }

        boolean isStreaming() {
            return this.tabFn.canAcceptInputAsStream();
        }

        void initializeStreaming(Configuration cfg, boolean isMapSide) throws HiveException {
            PartitionedTableFunctionDef tabDef = this.tabFn.getTableDef();
            PTFInputDef inputDef = tabDef.getInput();
            StructObjectInspector inputOI = ((PTFDesc)PTFOperator.this.conf).getStartOfChain() == tabDef ? PTFOperator.this.inputObjInspectors[0] : inputDef.getOutputShape().getOI();
            this.tabFn.initializeStreaming(cfg, inputOI, isMapSide);
            if (this.next != null) {
                this.next.initializeStreaming(cfg, isMapSide);
            }
        }

        void startPartition() throws HiveException {
            if (this.isStreaming()) {
                this.tabFn.startPartition();
            } else if (this.prev == null || this.prev.isOutputIterator()) {
                if (this.inputPart == null) {
                    this.createInputPartition();
                } else {
                    this.inputPart.reset();
                }
            }
            if (this.next != null) {
                this.next.startPartition();
            }
        }

        void processRow(Object row) throws HiveException {
            if (this.isStreaming()) {
                this.handleOutputRows(this.tabFn.processRow(row));
            } else {
                this.inputPart.append(row);
            }
        }

        void handleOutputRows(List<Object> outRows) throws HiveException {
            if (outRows != null) {
                for (Object orow : outRows) {
                    if (this.next != null) {
                        this.next.processRow(orow);
                        continue;
                    }
                    PTFOperator.this.forward(orow, PTFOperator.this.outputObjInspector);
                }
            }
        }

        void finishPartition() throws HiveException {
            if (this.isStreaming()) {
                this.handleOutputRows(this.tabFn.finishPartition());
            } else {
                if (this.tabFn.canIterateOutput()) {
                    this.outputPartRowsItr = this.inputPart == null ? null : this.tabFn.iterator(this.inputPart.iterator());
                } else {
                    this.outputPart = this.inputPart == null ? null : this.tabFn.execute(this.inputPart);
                    Iterator<Object> iterator = this.outputPartRowsItr = this.outputPart == null ? null : this.outputPart.iterator();
                }
                if (this.next != null) {
                    if (!this.next.isStreaming() && !this.isOutputIterator()) {
                        this.next.inputPart = this.outputPart;
                    } else if (this.outputPartRowsItr != null) {
                        while (this.outputPartRowsItr.hasNext()) {
                            this.next.processRow(this.outputPartRowsItr.next());
                        }
                    }
                }
            }
            if (this.next != null) {
                this.next.finishPartition();
            } else if (!this.isStreaming() && this.outputPartRowsItr != null) {
                while (this.outputPartRowsItr.hasNext()) {
                    PTFOperator.this.forward(this.outputPartRowsItr.next(), PTFOperator.this.outputObjInspector);
                }
            }
        }

        private void createInputPartition() throws HiveException {
            PartitionedTableFunctionDef tabDef = this.tabFn.getTableDef();
            PTFInputDef inputDef = tabDef.getInput();
            StructObjectInspector inputOI = ((PTFDesc)PTFOperator.this.conf).getStartOfChain() == tabDef ? PTFOperator.this.inputObjInspectors[0] : inputDef.getOutputShape().getOI();
            AbstractSerDe serde = ((PTFDesc)PTFOperator.this.conf).isMapSide() ? tabDef.getInput().getOutputShape().getSerde() : tabDef.getRawInputShape().getSerde();
            StructObjectInspector outputOI = ((PTFDesc)PTFOperator.this.conf).isMapSide() ? tabDef.getInput().getOutputShape().getOI() : tabDef.getRawInputShape().getOI();
            this.inputPart = PTFPartition.create(((PTFDesc)PTFOperator.this.conf).getCfg(), serde, inputOI, outputOI);
        }

        void close() {
            if (this.inputPart != null) {
                this.inputPart.close();
                this.inputPart = null;
            }
            this.tabFn.close();
            if (this.next != null) {
                this.next.close();
            }
        }
    }
}

