/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;

public abstract class VectorExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected VectorExpression[] childExpressions = null;
    protected Type[] inputTypes;
    protected String outputType;

    public abstract void evaluate(VectorizedRowBatch var1);

    public void init(Configuration conf) {
        if (this.childExpressions != null) {
            for (VectorExpression child : this.childExpressions) {
                child.init(conf);
            }
        }
    }

    public abstract int getOutputColumn();

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String type) {
        this.outputType = type;
    }

    public void setChildExpressions(VectorExpression[] ve) {
        this.childExpressions = ve;
    }

    public VectorExpression[] getChildExpressions() {
        return this.childExpressions;
    }

    public abstract VectorExpressionDescriptor.Descriptor getDescriptor();

    protected final void evaluateChildren(VectorizedRowBatch vrg) {
        if (this.childExpressions != null) {
            for (VectorExpression ve : this.childExpressions) {
                ve.evaluate(vrg);
            }
        }
    }

    public void setInputTypes(Type ... inputTypes) {
        this.inputTypes = inputTypes;
    }

    public Type[] getInputTypes() {
        return this.inputTypes;
    }

    public String vectorExpressionParameters() {
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this instanceof IdentityExpression) {
            b.append(this.vectorExpressionParameters());
        } else {
            b.append(this.getClass().getSimpleName());
            String vectorExpressionParameters = this.vectorExpressionParameters();
            if (vectorExpressionParameters != null) {
                b.append("(");
                b.append(vectorExpressionParameters);
                b.append(")");
            }
            if (this.childExpressions != null) {
                b.append("(children: ");
                for (int i = 0; i < this.childExpressions.length; ++i) {
                    b.append(this.childExpressions[i].toString());
                    if (i >= this.childExpressions.length - 1) continue;
                    b.append(", ");
                }
                b.append(")");
            }
            b.append(" -> ");
            int outputColumn = this.getOutputColumn();
            if (outputColumn != -1) {
                b.append(outputColumn);
                b.append(":");
            }
            b.append(this.getOutputType());
        }
        return b.toString();
    }

    public static String displayUtf8Bytes(byte[] bytes) {
        if (bytes == null) {
            return "NULL";
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String displayArrayOfUtf8ByteArrays(byte[][] arrayOfByteArrays) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte[] bytes : arrayOfByteArrays) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(VectorExpression.displayUtf8Bytes(bytes));
        }
        return sb.toString();
    }

    public static enum Type {
        STRING,
        CHAR,
        VARCHAR,
        TIMESTAMP,
        DATE,
        LONG,
        DOUBLE,
        DECIMAL,
        INTERVAL_YEAR_MONTH,
        INTERVAL_DAY_TIME,
        BINARY,
        OTHER;

        private static Map<String, Type> types;

        public static Type getValue(String name) {
            String nameLower = name.toLowerCase();
            if (types.containsKey(nameLower)) {
                return types.get(nameLower);
            }
            return OTHER;
        }

        static {
            types = ImmutableMap.builder().put((Object)"string", (Object)STRING).put((Object)"char", (Object)CHAR).put((Object)"varchar", (Object)VARCHAR).put((Object)"timestamp", (Object)TIMESTAMP).put((Object)"date", (Object)DATE).put((Object)"long", (Object)LONG).put((Object)"double", (Object)DOUBLE).put((Object)"decimal", (Object)DECIMAL).put((Object)"interval_year_month", (Object)INTERVAL_YEAR_MONTH).put((Object)"interval_day_time", (Object)INTERVAL_DAY_TIME).put((Object)"binary", (Object)BINARY).build();
        }
    }
}

