/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class IntervalDayTimeColGreaterEqualIntervalDayTimeScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveIntervalDayTime value;
    private int outputColumn;

    public IntervalDayTimeColGreaterEqualIntervalDayTimeScalar(int colNum, HiveIntervalDayTime value, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
    }

    public IntervalDayTimeColGreaterEqualIntervalDayTimeScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        IntervalDayTimeColumnVector inputColVector1 = (IntervalDayTimeColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector1.isNull;
        boolean[] outNulls = outputColVector.isNull;
        int n = batch.size;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        outputColVector.noNulls = inputColVector1.noNulls;
        if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating) {
                outputVector[0] = inputColVector1.compareTo(0, this.value) >= 0 ? 1L : 0L;
                outputColVector.isRepeating = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = inputColVector1.compareTo(i, this.value) >= 0 ? 1L : 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = inputColVector1.compareTo(i, this.value) >= 0 ? 1L : 0L;
                }
            }
        } else if (inputColVector1.isRepeating) {
            if (!nullPos[0]) {
                outputVector[0] = inputColVector1.compareTo(0, this.value) >= 0 ? 1L : 0L;
                outNulls[0] = false;
            } else {
                outNulls[0] = true;
            }
            outputColVector.isRepeating = true;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!nullPos[i]) {
                    outputVector[i] = inputColVector1.compareTo(i, this.value) >= 0 ? 1L : 0L;
                    outNulls[i] = false;
                    continue;
                }
                outNulls[i] = true;
            }
        } else {
            System.arraycopy(nullPos, 0, outNulls, 0, n);
            for (int i = 0; i != n; ++i) {
                if (nullPos[i]) continue;
                outputVector[i] = inputColVector1.compareTo(i, this.value) >= 0 ? 1L : 0L;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + this.value.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("interval_day_time"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

