/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hive.common.util.AnnotationUtils;

public class HiveJoinPushTransitivePredicatesRule
extends RelOptRule {
    public static final HiveJoinPushTransitivePredicatesRule INSTANCE_JOIN = new HiveJoinPushTransitivePredicatesRule(HiveJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    public static final HiveJoinPushTransitivePredicatesRule INSTANCE_SEMIJOIN = new HiveJoinPushTransitivePredicatesRule(HiveSemiJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public HiveJoinPushTransitivePredicatesRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(HiveJoinPushTransitivePredicatesRule.operand(clazz, (RelOptRuleOperandChildren)HiveJoinPushTransitivePredicatesRule.any()));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode curr;
        Join join = (Join)call.rel(0);
        RelOptPredicateList preds = RelMetadataQuery.instance().getPulledUpPredicates((RelNode)join);
        HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
        assert (registry != null);
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode lChild = join.getLeft();
        RelNode rChild = join.getRight();
        HashSet leftPushedPredicates = Sets.newHashSet(registry.getPushedPredicates((RelNode)join, 0));
        ImmutableList<RexNode> leftPreds = this.getValidPreds(join.getCluster(), lChild, leftPushedPredicates, (List<RexNode>)preds.leftInferredPredicates, lChild.getRowType());
        HashSet rightPushedPredicates = Sets.newHashSet(registry.getPushedPredicates((RelNode)join, 1));
        ImmutableList<RexNode> rightPreds = this.getValidPreds(join.getCluster(), rChild, rightPushedPredicates, (List<RexNode>)preds.rightInferredPredicates, rChild.getRowType());
        RexNode newLeftPredicate = RexUtil.composeConjunction((RexBuilder)rB, leftPreds, (boolean)false);
        RexNode newRightPredicate = RexUtil.composeConjunction((RexBuilder)rB, rightPreds, (boolean)false);
        if (newLeftPredicate.isAlwaysTrue() && newRightPredicate.isAlwaysTrue()) {
            return;
        }
        if (!newLeftPredicate.isAlwaysTrue()) {
            curr = lChild;
            lChild = this.filterFactory.createFilter(lChild, newLeftPredicate);
            call.getPlanner().onCopy(curr, lChild);
        }
        if (!newRightPredicate.isAlwaysTrue()) {
            curr = rChild;
            rChild = this.filterFactory.createFilter(rChild, newRightPredicate);
            call.getPlanner().onCopy(curr, rChild);
        }
        Join newRel = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newRel);
        registry.getPushedPredicates((RelNode)newRel, 0).addAll(leftPushedPredicates);
        registry.getPushedPredicates((RelNode)newRel, 1).addAll(rightPushedPredicates);
        call.transformTo((RelNode)newRel);
    }

    private ImmutableList<RexNode> getValidPreds(RelOptCluster cluster, RelNode child, Set<String> predicatesToExclude, List<RexNode> rexs, RelDataType rType) {
        InputRefValidator validator = new InputRefValidator(rType.getFieldList());
        ArrayList<RexNode> valids = new ArrayList<RexNode>(rexs.size());
        for (RexNode rex : rexs) {
            try {
                rex.accept((RexVisitor)validator);
                valids.add(rex);
            }
            catch (Util.FoundOne e) {
                Util.swallow((Throwable)e, null);
            }
        }
        ImmutableList<RexNode> toPush = HiveCalciteUtil.getPredsNotPushedAlready(predicatesToExclude, child, valids);
        return toPush;
    }

    private RexNode getTypeSafePred(RelOptCluster cluster, RexNode rex, RelDataType rType) {
        RexNode typeSafeRex = rex;
        if (typeSafeRex instanceof RexCall && HiveCalciteUtil.isComparisonOp((RexCall)typeSafeRex)) {
            RexBuilder rb = cluster.getRexBuilder();
            ArrayList<RexNode> fixedPredElems = new ArrayList<RexNode>();
            RelDataType commonType = cluster.getTypeFactory().leastRestrictive(RexUtil.types((List)((RexCall)rex).getOperands()));
            for (RexNode rn : ((RexCall)rex).getOperands()) {
                fixedPredElems.add(rb.ensureType(commonType, rn, true));
            }
            typeSafeRex = rb.makeCall(((RexCall)typeSafeRex).getOperator(), fixedPredElems);
        }
        return typeSafeRex;
    }

    private static class InputRefValidator
    extends RexVisitorImpl<Void> {
        private final List<RelDataTypeField> types;

        protected InputRefValidator(List<RelDataTypeField> types) {
            super(true);
            this.types = types;
        }

        public Void visitCall(RexCall call) {
            if (((Description)AnnotationUtils.getAnnotation(GenericUDFOPNotNull.class, Description.class)).name().equals(call.getOperator().getName()) && call.getOperands().get(0) instanceof RexInputRef && !this.types.get(((RexInputRef)call.getOperands().get(0)).getIndex()).getType().isNullable()) {
                throw new Util.FoundOne((Object)call);
            }
            return (Void)super.visitCall(call);
        }
    }
}

