/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Utils;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;

public class BucketingSortingOpProcFactory {
    private static void processForward(Operator<? extends OperatorDesc> op, BucketingSortingCtx bctx, Operator<? extends OperatorDesc> parent) throws SemanticException {
        List<BucketingSortingCtx.BucketCol> bucketCols = bctx.getBucketedCols(parent);
        List<BucketingSortingCtx.SortCol> sortCols = bctx.getSortedCols(parent);
        ArrayList<ColumnInfo> colInfos = op.getSchema().getSignature();
        if (bucketCols == null && sortCols == null) {
            return;
        }
        List<BucketingSortingCtx.BucketCol> newBucketCols = bucketCols == null ? null : BucketingSortingOpProcFactory.getNewBucketCols(bucketCols, colInfos);
        List<BucketingSortingCtx.SortCol> newSortCols = sortCols == null ? null : BucketingSortingOpProcFactory.getNewSortCols(sortCols, colInfos);
        bctx.setBucketedCols(op, newBucketCols);
        bctx.setSortedCols(op, newSortCols);
    }

    protected static Operator<? extends OperatorDesc> getParent(Stack<Node> stack) {
        return (Operator)Utils.getNthAncestor(stack, 1);
    }

    private static void setBucketingColsIfComplete(BucketingSortingCtx bctx, Operator<? extends OperatorDesc> op, BucketingSortingCtx.BucketCol[] newBucketCols) {
        List<BucketingSortingCtx.BucketCol> newBucketColList;
        if (newBucketCols != null && !(newBucketColList = Arrays.asList(newBucketCols)).contains(null)) {
            bctx.setBucketedCols(op, newBucketColList);
        }
    }

    private static void setSortingColsIfComplete(BucketingSortingCtx bctx, Operator<? extends OperatorDesc> op, BucketingSortingCtx.SortCol[] newSortCols) {
        List<BucketingSortingCtx.SortCol> newSortColList;
        if (newSortCols != null && !(newSortColList = Arrays.asList(newSortCols)).contains(null)) {
            bctx.setSortedCols(op, newSortColList);
        }
    }

    private static void findBucketingSortingColumns(List<ExprNodeDesc> exprs, List<ColumnInfo> colInfos, List<BucketingSortingCtx.BucketCol> bucketCols, List<BucketingSortingCtx.SortCol> sortCols, BucketingSortingCtx.BucketCol[] newBucketCols, BucketingSortingCtx.SortCol[] newSortCols) {
        BucketingSortingOpProcFactory.findBucketingSortingColumns(exprs, colInfos, bucketCols, sortCols, newBucketCols, newSortCols, 0);
    }

    private static void findBucketingSortingColumns(List<ExprNodeDesc> exprs, List<ColumnInfo> colInfos, List<BucketingSortingCtx.BucketCol> bucketCols, List<BucketingSortingCtx.SortCol> sortCols, BucketingSortingCtx.BucketCol[] newBucketCols, BucketingSortingCtx.SortCol[] newSortCols, int colInfosOffset) {
        for (int cnt = 0; cnt < exprs.size(); ++cnt) {
            int sortIndex;
            int bucketIndex;
            ExprNodeDesc expr = exprs.get(cnt);
            if (!(expr instanceof ExprNodeColumnDesc)) continue;
            ExprNodeColumnDesc columnExpr = (ExprNodeColumnDesc)expr;
            int colInfosIndex = cnt + colInfosOffset;
            if (newBucketCols != null && (bucketIndex = BucketingSortingOpProcFactory.indexOfColName(bucketCols, columnExpr.getColumn())) != -1) {
                if (newBucketCols[bucketIndex] == null) {
                    newBucketCols[bucketIndex] = new BucketingSortingCtx.BucketCol();
                }
                newBucketCols[bucketIndex].addAlias(colInfos.get(colInfosIndex).getInternalName(), colInfosIndex);
            }
            if (newSortCols == null || (sortIndex = BucketingSortingOpProcFactory.indexOfColName(sortCols, columnExpr.getColumn())) == -1) continue;
            if (newSortCols[sortIndex] == null) {
                newSortCols[sortIndex] = new BucketingSortingCtx.SortCol(sortCols.get(sortIndex).getSortOrder());
            }
            newSortCols[sortIndex].addAlias(colInfos.get(colInfosIndex).getInternalName(), colInfosIndex);
        }
    }

    private static int indexOfColName(List<? extends BucketingSortingCtx.BucketSortCol> bucketSortCols, String colName) {
        for (int index = 0; index < bucketSortCols.size(); ++index) {
            BucketingSortingCtx.BucketSortCol bucketSortCol = bucketSortCols.get(index);
            if (bucketSortCol.getNames().indexOf(colName) == -1) continue;
            return index;
        }
        return -1;
    }

    private static List<BucketingSortingCtx.BucketCol> getNewBucketCols(List<BucketingSortingCtx.BucketCol> bucketCols, List<ColumnInfo> colInfos) {
        ArrayList<BucketingSortingCtx.BucketCol> newBucketCols = new ArrayList<BucketingSortingCtx.BucketCol>(bucketCols.size());
        for (int i = 0; i < bucketCols.size(); ++i) {
            BucketingSortingCtx.BucketCol bucketCol = new BucketingSortingCtx.BucketCol();
            for (Integer index : bucketCols.get(i).getIndexes()) {
                if (index < colInfos.size()) {
                    bucketCol.addAlias(colInfos.get(index).getInternalName(), index);
                    continue;
                }
                return null;
            }
            newBucketCols.add(bucketCol);
        }
        return newBucketCols;
    }

    private static List<BucketingSortingCtx.SortCol> getNewSortCols(List<BucketingSortingCtx.SortCol> sortCols, List<ColumnInfo> colInfos) {
        ArrayList<BucketingSortingCtx.SortCol> newSortCols = new ArrayList<BucketingSortingCtx.SortCol>(sortCols.size());
        for (int i = 0; i < sortCols.size(); ++i) {
            BucketingSortingCtx.SortCol sortCol = new BucketingSortingCtx.SortCol(sortCols.get(i).getSortOrder());
            for (Integer index : sortCols.get(i).getIndexes()) {
                if (index < colInfos.size()) {
                    sortCol.addAlias(colInfos.get(index).getInternalName(), index);
                    continue;
                }
                return null;
            }
            newSortCols.add(sortCol);
        }
        return newSortCols;
    }

    static void extractTraits(BucketingSortingCtx bctx, ReduceSinkOperator rop, Operator<?> childop) throws SemanticException {
        List<ExprNodeDesc> outputValues = Collections.emptyList();
        if (childop instanceof SelectOperator) {
            SelectDesc select = (SelectDesc)((SelectOperator)childop).getConf();
            outputValues = ExprNodeDescUtils.backtrack(select.getColList(), childop, rop);
        }
        if (outputValues.isEmpty()) {
            return;
        }
        List<BucketingSortingCtx.BucketCol> bucketCols = BucketingSortingOpProcFactory.extractBucketCols(rop, outputValues);
        List<BucketingSortingCtx.SortCol> sortCols = BucketingSortingOpProcFactory.extractSortCols(rop, outputValues);
        ArrayList<ColumnInfo> colInfos = childop.getSchema().getSignature();
        if (!bucketCols.isEmpty()) {
            List<BucketingSortingCtx.BucketCol> newBucketCols = BucketingSortingOpProcFactory.getNewBucketCols(bucketCols, colInfos);
            bctx.setBucketedCols(childop, newBucketCols);
        }
        if (!sortCols.isEmpty()) {
            List<BucketingSortingCtx.SortCol> newSortCols = BucketingSortingOpProcFactory.getNewSortCols(sortCols, colInfos);
            bctx.setSortedCols(childop, newSortCols);
        }
    }

    static List<BucketingSortingCtx.BucketCol> extractBucketCols(ReduceSinkOperator rop, List<ExprNodeDesc> outputValues) {
        ArrayList<BucketingSortingCtx.BucketCol> bucketCols = new ArrayList<BucketingSortingCtx.BucketCol>();
        for (ExprNodeDesc partitionCol : ((ReduceSinkDesc)rop.getConf()).getPartitionCols()) {
            if (!(partitionCol instanceof ExprNodeColumnDesc)) {
                return Collections.emptyList();
            }
            int index = ExprNodeDescUtils.indexOf(partitionCol, outputValues);
            if (index < 0) {
                return Collections.emptyList();
            }
            bucketCols.add(new BucketingSortingCtx.BucketCol(((ExprNodeColumnDesc)partitionCol).getColumn(), index));
        }
        return bucketCols;
    }

    static List<BucketingSortingCtx.SortCol> extractSortCols(ReduceSinkOperator rop, List<ExprNodeDesc> outputValues) {
        int index;
        ExprNodeDesc keyCol;
        String sortOrder = ((ReduceSinkDesc)rop.getConf()).getOrder();
        ArrayList<BucketingSortingCtx.SortCol> sortCols = new ArrayList<BucketingSortingCtx.SortCol>();
        ArrayList<ExprNodeDesc> keyCols = ((ReduceSinkDesc)rop.getConf()).getKeyCols();
        for (int i = 0; i < keyCols.size() && (keyCol = keyCols.get(i)) instanceof ExprNodeColumnDesc && (index = ExprNodeDescUtils.indexOf(keyCol, outputValues)) >= 0; ++i) {
            sortCols.add(new BucketingSortingCtx.SortCol(((ExprNodeColumnDesc)keyCol).getColumn(), index, sortOrder.charAt(i)));
        }
        return sortCols;
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultInferrer();
    }

    public static NodeProcessor getJoinProc() {
        return new JoinInferrer();
    }

    public static NodeProcessor getSelProc() {
        return new SelectInferrer();
    }

    public static NodeProcessor getGroupByProc() {
        return new GroupByInferrer();
    }

    public static NodeProcessor getFileSinkProc() {
        return new FileSinkInferrer();
    }

    public static NodeProcessor getFilterProc() {
        return new ForwardingInferrer();
    }

    public static NodeProcessor getLimitProc() {
        return new ForwardingInferrer();
    }

    public static NodeProcessor getLateralViewForwardProc() {
        return new ForwardingInferrer();
    }

    public static NodeProcessor getLateralViewJoinProc() {
        return new ForwardingInferrer();
    }

    public static NodeProcessor getForwardProc() {
        return new ForwardingInferrer();
    }

    public static NodeProcessor getMultiGroupByProc() {
        return new MultiGroupByInferrer();
    }

    public static class ForwardingInferrer
    extends DefaultInferrer
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            BucketingSortingOpProcFactory.processForward((Operator)nd, (BucketingSortingCtx)procCtx, BucketingSortingOpProcFactory.getParent(stack));
            return null;
        }
    }

    public static class GroupByInferrer
    extends DefaultInferrer
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            BucketingSortingCtx bctx = (BucketingSortingCtx)procCtx;
            GroupByOperator gop = (GroupByOperator)nd;
            if (gop.getParentOperators().size() != 1) {
                return null;
            }
            Operator<OperatorDesc> rop = gop.getParentOperators().get(0);
            assert (rop instanceof ReduceSinkOperator);
            this.processGroupByReduceSink((ReduceSinkOperator)rop, gop, bctx);
            return this.processGroupBy(rop, gop, bctx);
        }

        protected void processGroupByReduceSink(ReduceSinkOperator rop, GroupByOperator gop, BucketingSortingCtx bctx) {
            GroupByDesc groupByDesc = (GroupByDesc)gop.getConf();
            String sortOrder = ((ReduceSinkDesc)rop.getConf()).getOrder();
            ArrayList<BucketingSortingCtx.BucketCol> bucketCols = new ArrayList<BucketingSortingCtx.BucketCol>();
            ArrayList<BucketingSortingCtx.SortCol> sortCols = new ArrayList<BucketingSortingCtx.SortCol>();
            assert (((ReduceSinkDesc)rop.getConf()).getKeyCols().size() <= rop.getSchema().getSignature().size());
            for (int i = 0; i < ((ReduceSinkDesc)rop.getConf()).getKeyCols().size(); ++i) {
                if (groupByDesc.pruneGroupingSetId() && groupByDesc.getGroupingSetPosition() == i) continue;
                String colName = rop.getSchema().getSignature().get(i).getInternalName();
                bucketCols.add(new BucketingSortingCtx.BucketCol(colName, i));
                sortCols.add(new BucketingSortingCtx.SortCol(colName, i, sortOrder.charAt(i)));
            }
            bctx.setBucketedCols(rop, bucketCols);
            bctx.setSortedCols(rop, sortCols);
        }

        protected Object processGroupBy(Operator<? extends OperatorDesc> parent, GroupByOperator gop, BucketingSortingCtx bctx) {
            List<BucketingSortingCtx.BucketCol> bucketCols = bctx.getBucketedCols(parent);
            List<BucketingSortingCtx.SortCol> sortCols = bctx.getSortedCols(parent);
            ArrayList<ColumnInfo> colInfos = gop.getSchema().getSignature();
            if (bucketCols == null) {
                assert (sortCols == null);
                return null;
            }
            if (bucketCols.isEmpty()) {
                assert (sortCols.isEmpty());
                return null;
            }
            BucketingSortingCtx.BucketCol[] newBucketCols = new BucketingSortingCtx.BucketCol[bucketCols.size()];
            BucketingSortingCtx.SortCol[] newSortCols = new BucketingSortingCtx.SortCol[sortCols.size()];
            BucketingSortingOpProcFactory.findBucketingSortingColumns(((GroupByDesc)gop.getConf()).getKeys(), colInfos, bucketCols, sortCols, newBucketCols, newSortCols);
            BucketingSortingOpProcFactory.setBucketingColsIfComplete(bctx, gop, newBucketCols);
            BucketingSortingOpProcFactory.setSortingColsIfComplete(bctx, gop, newSortCols);
            return null;
        }
    }

    public static class MultiGroupByInferrer
    extends GroupByInferrer
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            BucketingSortingCtx bctx = (BucketingSortingCtx)procCtx;
            GroupByOperator gop = (GroupByOperator)nd;
            if (gop.getParentOperators().size() != 1) {
                return null;
            }
            Operator<OperatorDesc> fop = gop.getParentOperators().get(0);
            assert (fop instanceof ForwardOperator);
            if (fop.getParentOperators().size() != 1) {
                return null;
            }
            Operator<OperatorDesc> rop = fop.getParentOperators().get(0);
            assert (rop instanceof ReduceSinkOperator);
            this.processGroupByReduceSink((ReduceSinkOperator)rop, gop, bctx);
            BucketingSortingOpProcFactory.processForward(fop, bctx, rop);
            return this.processGroupBy(fop, gop, bctx);
        }
    }

    public static class FileSinkInferrer
    extends DefaultInferrer
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            List<BucketingSortingCtx.SortCol> sortCols;
            BucketingSortingCtx bctx = (BucketingSortingCtx)procCtx;
            FileSinkOperator fop = (FileSinkOperator)nd;
            Operator<? extends OperatorDesc> parent = BucketingSortingOpProcFactory.getParent(stack);
            List<BucketingSortingCtx.BucketCol> bucketCols = bctx.getBucketedCols(parent);
            ArrayList<ColumnInfo> colInfos = fop.getSchema().getSignature();
            if (bucketCols != null) {
                List newBucketCols = BucketingSortingOpProcFactory.getNewBucketCols(bucketCols, colInfos);
                bctx.getBucketedColsByDirectory().put(((FileSinkDesc)fop.getConf()).getDirName().toString(), newBucketCols);
                bctx.setBucketedCols(fop, newBucketCols);
            }
            if ((sortCols = bctx.getSortedCols(parent)) != null) {
                List newSortCols = BucketingSortingOpProcFactory.getNewSortCols(sortCols, colInfos);
                bctx.getSortedColsByDirectory().put(((FileSinkDesc)fop.getConf()).getDirName().toString(), newSortCols);
                bctx.setSortedCols(fop, newSortCols);
            }
            return null;
        }
    }

    public static class SelectInferrer
    extends DefaultInferrer
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            BucketingSortingCtx bctx = (BucketingSortingCtx)procCtx;
            SelectOperator sop = (SelectOperator)nd;
            if (sop.getNumParent() == 1 && sop.getParentOperators().get(0) instanceof ReduceSinkOperator) {
                ReduceSinkOperator rs = (ReduceSinkOperator)sop.getParentOperators().get(0);
                BucketingSortingOpProcFactory.extractTraits(bctx, rs, sop);
                return null;
            }
            Operator<? extends OperatorDesc> parent = BucketingSortingOpProcFactory.getParent(stack);
            if (((SelectDesc)sop.getConf()).isSelStarNoCompute()) {
                BucketingSortingOpProcFactory.processForward(sop, bctx, parent);
                return null;
            }
            List<BucketingSortingCtx.BucketCol> bucketCols = bctx.getBucketedCols(parent);
            List<BucketingSortingCtx.SortCol> sortCols = bctx.getSortedCols(parent);
            ArrayList<ColumnInfo> colInfos = sop.getSchema().getSignature();
            if (bucketCols == null && sortCols == null) {
                return null;
            }
            BucketingSortingCtx.BucketCol[] newBucketCols = null;
            BucketingSortingCtx.SortCol[] newSortCols = null;
            if (bucketCols != null) {
                newBucketCols = new BucketingSortingCtx.BucketCol[bucketCols.size()];
            }
            if (sortCols != null) {
                newSortCols = new BucketingSortingCtx.SortCol[sortCols.size()];
            }
            BucketingSortingOpProcFactory.findBucketingSortingColumns(((SelectDesc)sop.getConf()).getColList(), colInfos, bucketCols, sortCols, newBucketCols, newSortCols);
            BucketingSortingOpProcFactory.setBucketingColsIfComplete(bctx, sop, newBucketCols);
            BucketingSortingOpProcFactory.setSortingColsIfComplete(bctx, sop, newSortCols);
            return null;
        }
    }

    public static class JoinInferrer
    extends DefaultInferrer
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            List<BucketingSortingCtx.SortCol> sortCols;
            BucketingSortingCtx bctx = (BucketingSortingCtx)procCtx;
            JoinOperator jop = (JoinOperator)nd;
            JoinDesc joinDesc = (JoinDesc)jop.getConf();
            Byte[] order = joinDesc.getTagOrder();
            Map<Byte, List<ExprNodeDesc>> expressions = joinDesc.getExprs();
            List<String> outputValNames = joinDesc.getOutputColumnNames();
            BucketingSortingCtx.BucketCol[] newBucketCols = null;
            BucketingSortingCtx.SortCol[] newSortCols = null;
            for (int i = 0; i < jop.getParentOperators().size(); ++i) {
                Operator<OperatorDesc> parent = jop.getParentOperators().get(i);
                assert (parent instanceof ReduceSinkOperator);
                ReduceSinkOperator rop = (ReduceSinkOperator)jop.getParentOperators().get(i);
                ReduceSinkDesc rsDesc = (ReduceSinkDesc)rop.getConf();
                byte tag = (byte)rsDesc.getTag();
                List<ExprNodeDesc> joinValues = expressions.get(tag);
                int offset = 0;
                for (byte orderIndex = 0; orderIndex < order.length; orderIndex = (byte)(orderIndex + 1)) {
                    if (order[orderIndex] >= order[tag]) continue;
                    offset += expressions.get(orderIndex).size();
                }
                String sortOrder = rsDesc.getOrder();
                ArrayList<ExprNodeDesc> keyCols = rsDesc.getKeyCols();
                ArrayList<ExprNodeDesc> valCols = ExprNodeDescUtils.backtrack(joinValues, jop, parent);
                if (newBucketCols == null) {
                    newBucketCols = new BucketingSortingCtx.BucketCol[keyCols.size()];
                    newSortCols = new BucketingSortingCtx.SortCol[keyCols.size()];
                }
                for (int keyIndex = 0; keyIndex < keyCols.size(); ++keyIndex) {
                    ExprNodeDesc key = (ExprNodeDesc)keyCols.get(keyIndex);
                    int index = ExprNodeDescUtils.indexOf(key, valCols);
                    if (index < 0) continue;
                    int vindex = offset + index;
                    String vname = outputValNames.get(vindex);
                    if (newBucketCols[keyIndex] != null) {
                        newBucketCols[keyIndex].addAlias(vname, vindex);
                        newSortCols[keyIndex].addAlias(vname, vindex);
                        continue;
                    }
                    newBucketCols[keyIndex] = new BucketingSortingCtx.BucketCol(vname, vindex);
                    newSortCols[keyIndex] = new BucketingSortingCtx.SortCol(vname, vindex, sortOrder.charAt(keyIndex));
                }
            }
            List<BucketingSortingCtx.BucketCol> bucketCols = Arrays.asList(newBucketCols);
            if (!bucketCols.contains(null)) {
                bctx.setBucketedCols(jop, bucketCols);
            }
            if (!(sortCols = Arrays.asList(newSortCols)).contains(null)) {
                bctx.setSortedCols(jop, sortCols);
            }
            return null;
        }
    }

    public static class DefaultInferrer
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }
}

