/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create View", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateViewDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String viewName;
    private String originalText;
    private String expandedText;
    private boolean rewriteEnabled;
    private List<FieldSchema> schema;
    private Map<String, String> tblProps;
    private List<String> partColNames;
    private List<FieldSchema> partCols;
    private String comment;
    private boolean ifNotExists;
    private boolean orReplace;
    private boolean isAlterViewAs;
    private boolean isMaterialized;
    private String inputFormat;
    private String outputFormat;
    private String location;
    private String serde;
    private String storageHandler;
    private Map<String, String> serdeProps;
    private ReplicationSpec replicationSpec = null;

    public CreateViewDesc() {
    }

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, List<String> partColNames, boolean ifNotExists, boolean orReplace, boolean rewriteEnabled, boolean isAlterViewAs, String inputFormat, String outputFormat, String location, String serde, String storageHandler, Map<String, String> serdeProps) {
        this.viewName = viewName;
        this.schema = schema;
        this.tblProps = tblProps;
        this.partColNames = partColNames;
        this.comment = comment;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
        this.isMaterialized = true;
        this.rewriteEnabled = rewriteEnabled;
        this.isAlterViewAs = isAlterViewAs;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.location = location;
        this.serde = serde;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
    }

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, List<String> partColNames, boolean ifNotExists, boolean orReplace, boolean isAlterViewAs, String inputFormat, String outputFormat, String serde) {
        this.viewName = viewName;
        this.schema = schema;
        this.tblProps = tblProps;
        this.partColNames = partColNames;
        this.comment = comment;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
        this.isAlterViewAs = isAlterViewAs;
        this.isMaterialized = false;
        this.rewriteEnabled = false;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.serde = serde;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Explain(displayName="original text", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getViewOriginalText() {
        return this.originalText;
    }

    public void setViewOriginalText(String originalText) {
        this.originalText = originalText;
    }

    @Explain(displayName="expanded text")
    public String getViewExpandedText() {
        return this.expandedText;
    }

    public void setViewExpandedText(String expandedText) {
        this.expandedText = expandedText;
    }

    @Explain(displayName="rewrite enabled")
    public boolean isRewriteEnabled() {
        return this.rewriteEnabled;
    }

    public void setRewriteEnabled(boolean rewriteEnabled) {
        this.rewriteEnabled = rewriteEnabled;
    }

    @Explain(displayName="columns")
    public List<String> getSchemaString() {
        return Utilities.getFieldSchemaString(this.schema);
    }

    public List<FieldSchema> getSchema() {
        return this.schema;
    }

    public void setSchema(List<FieldSchema> schema) {
        this.schema = schema;
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.partCols);
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    public List<String> getPartColNames() {
        return this.partColNames;
    }

    public void setPartColNames(List<String> partColNames) {
        this.partColNames = partColNames;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="or replace")
    public boolean getOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    @Explain(displayName="is alter view as select", displayOnlyOnTrue=true)
    public boolean getIsAlterViewAs() {
        return this.isAlterViewAs;
    }

    public void setIsAlterViewAs(boolean isAlterViewAs) {
        this.isAlterViewAs = isAlterViewAs;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSerde() {
        return this.serde;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }
}

