/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class GenericUDFBridge
extends GenericUDF
implements Serializable {
    private static final long serialVersionUID = 4994861742809511113L;
    private String udfName;
    private boolean isOperator;
    private String udfClassName;
    private transient Method udfMethod;
    private transient GenericUDFUtils.ConversionHelper conversionHelper;
    private transient UDF udf;
    private transient Object[] realArguments;
    private transient UdfWhitelistChecker udfChecker;

    public GenericUDFBridge(String udfName, boolean isOperator, String udfClassName) {
        this.udfName = udfName;
        this.isOperator = isOperator;
        this.udfClassName = udfClassName;
    }

    public GenericUDFBridge() {
    }

    public void setUdfName(String udfName) {
        this.udfName = udfName;
    }

    @Override
    public String getUdfName() {
        return this.udfName;
    }

    public String getUdfClassName() {
        return this.udfClassName;
    }

    public void setUdfClassName(String udfClassName) {
        this.udfClassName = udfClassName;
    }

    public boolean isOperator() {
        return this.isOperator;
    }

    public void setOperator(boolean isOperator) {
        this.isOperator = isOperator;
    }

    public Class<? extends UDF> getUdfClass() {
        try {
            return this.getUdfClassInternal();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends UDF> getUdfClassInternal() throws ClassNotFoundException {
        Class<?> clazz = Class.forName(this.udfClassName, true, Utilities.getSessionSpecifiedClassLoader());
        if (this.udfChecker != null && !this.udfChecker.isUdfAllowed(clazz)) {
            throw new SecurityException("UDF " + clazz.getCanonicalName() + " is not allowed");
        }
        return clazz;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        try {
            this.udf = this.getUdfClassInternal().newInstance();
        }
        catch (Exception e) {
            throw new UDFArgumentException("Unable to instantiate UDF implementation class " + this.udfClassName + ": " + e);
        }
        ArrayList<TypeInfo> argumentTypeInfos = new ArrayList<TypeInfo>(arguments.length);
        for (ObjectInspector argument : arguments) {
            argumentTypeInfos.add(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)argument));
        }
        this.udfMethod = this.udf.getResolver().getEvalMethod(argumentTypeInfos);
        this.udfMethod.setAccessible(true);
        this.conversionHelper = new GenericUDFUtils.ConversionHelper(this.udfMethod, arguments);
        this.realArguments = new Object[arguments.length];
        ObjectInspector returnOI = ObjectInspectorFactory.getReflectionObjectInspector((Type)this.udfMethod.getGenericReturnType(), (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        return returnOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == this.realArguments.length);
        for (int i = 0; i < this.realArguments.length; ++i) {
            this.realArguments[i] = arguments[i].get();
        }
        Object result = FunctionRegistry.invoke(this.udfMethod, this.udf, this.conversionHelper.convertIfNecessary(this.realArguments));
        if (result != null && result instanceof HiveDecimalWritable) {
            result = HiveDecimalWritable.enforcePrecisionScale((HiveDecimalWritable)((HiveDecimalWritable)result), (int)38, (int)18);
        }
        return result;
    }

    @Override
    public String getDisplayString(String[] children) {
        if (this.isOperator) {
            if (children.length == 1) {
                return "(" + this.udfName + " " + children[0] + ")";
            }
            assert (children.length == 2);
            return "(" + children[0] + " " + this.udfName + " " + children[1] + ")";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.udfName);
        sb.append("(");
        for (int i = 0; i < children.length; ++i) {
            sb.append(children[i]);
            if (i + 1 >= children.length) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String[] getRequiredJars() {
        return this.udf.getRequiredJars();
    }

    @Override
    public String[] getRequiredFiles() {
        return this.udf.getRequiredFiles();
    }

    public void setUdfChecker(UdfWhitelistChecker udfChecker) {
        this.udfChecker = udfChecker;
    }

    public static interface UdfWhitelistChecker {
        public boolean isUdfAllowed(Class<?> var1);
    }
}

