/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseTrim;

@Description(name="trim", value="_FUNC_(str) - Removes the leading and trailing space characters from str ", extended="Example:\n  > SELECT _FUNC_('   facebook  ') FROM src LIMIT 1;\n  'facebook'")
@VectorizedExpressions(value={StringTrim.class})
public class GenericUDFTrim
extends GenericUDFBaseTrim {
    public GenericUDFTrim() {
        super("trim");
    }

    @Override
    protected String performOp(String val) {
        return StringUtils.strip((String)val, (String)" ");
    }
}

