/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.grpc;

import java.util.List;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.io.grpc.CallbackMetricInstrument;
import org.sparkproject.io.grpc.DoubleCounterMetricInstrument;
import org.sparkproject.io.grpc.DoubleHistogramMetricInstrument;
import org.sparkproject.io.grpc.Internal;
import org.sparkproject.io.grpc.LongCounterMetricInstrument;
import org.sparkproject.io.grpc.LongGaugeMetricInstrument;
import org.sparkproject.io.grpc.LongHistogramMetricInstrument;
import org.sparkproject.io.grpc.LongUpDownCounterMetricInstrument;

@Internal
public interface MetricRecorder {
    default public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void addLongUpDownCounter(LongUpDownCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
        Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
    }

    default public Registration registerBatchCallback(BatchCallback callback, CallbackMetricInstrument ... metricInstruments) {
        return () -> {};
    }

    public static interface Registration
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static interface BatchRecorder {
        default public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
            Preconditions.checkArgument(requiredLabelValues != null && requiredLabelValues.size() == metricInstrument.getRequiredLabelKeys().size(), "Incorrect number of required labels provided. Expected: %s", metricInstrument.getRequiredLabelKeys().size());
            Preconditions.checkArgument(optionalLabelValues != null && optionalLabelValues.size() == metricInstrument.getOptionalLabelKeys().size(), "Incorrect number of optional labels provided. Expected: %s", metricInstrument.getOptionalLabelKeys().size());
        }
    }

    public static interface BatchCallback {
        public void accept(BatchRecorder var1);
    }
}

