/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.util.Objects;
import org.apache.spark.util.sketch.BitArray;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.IncompatibleMergeException;
import org.apache.spark.util.sketch.Murmur3_x86_32;
import org.apache.spark.util.sketch.Platform;
import org.apache.spark.util.sketch.Utils;

abstract class BloomFilterBase
extends BloomFilter {
    public static final int DEFAULT_SEED = 0;
    protected int seed;
    protected int numHashFunctions;
    protected BitArray bits;

    protected BloomFilterBase(int numHashFunctions, long numBits) {
        this(numHashFunctions, numBits, 0);
    }

    protected BloomFilterBase(int numHashFunctions, long numBits, int seed) {
        this(new BitArray(numBits), numHashFunctions, seed);
    }

    protected BloomFilterBase(BitArray bits, int numHashFunctions, int seed) {
        this.bits = bits;
        this.numHashFunctions = numHashFunctions;
        this.seed = seed;
    }

    protected BloomFilterBase() {
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BloomFilterBase)) {
            return false;
        }
        BloomFilterBase that = (BloomFilterBase)other;
        return this.getClass() == that.getClass() && this.numHashFunctions == that.numHashFunctions && this.seed == that.seed && this.bits.equals(that.bits);
    }

    public int hashCode() {
        return Objects.hash(this.numHashFunctions, this.seed, this.bits);
    }

    @Override
    public double expectedFpp() {
        return Math.pow((double)this.bits.cardinality() / (double)this.bits.bitSize(), this.numHashFunctions);
    }

    @Override
    public long bitSize() {
        return this.bits.bitSize();
    }

    @Override
    public boolean put(Object item) {
        if (item instanceof String) {
            String str = (String)item;
            return this.putString(str);
        }
        if (item instanceof byte[]) {
            byte[] bytes = (byte[])item;
            return this.putBinary(bytes);
        }
        return this.putLong(Utils.integralToLong(item));
    }

    protected HiLoHash hashLongToIntPair(long item, int seed) {
        int h1 = Murmur3_x86_32.hashLong(item, seed);
        int h2 = Murmur3_x86_32.hashLong(item, h1);
        return new HiLoHash(h1, h2);
    }

    protected HiLoHash hashBytesToIntPair(byte[] item, int seed) {
        int h1 = Murmur3_x86_32.hashUnsafeBytes(item, Platform.BYTE_ARRAY_OFFSET, item.length, seed);
        int h2 = Murmur3_x86_32.hashUnsafeBytes(item, Platform.BYTE_ARRAY_OFFSET, item.length, h1);
        return new HiLoHash(h1, h2);
    }

    protected abstract boolean scatterHashAndSetAllBits(HiLoHash var1);

    protected abstract boolean scatterHashAndGetAllBits(HiLoHash var1);

    @Override
    public boolean putString(String item) {
        return this.putBinary(Utils.getBytesFromUTF8String(item));
    }

    @Override
    public boolean putBinary(byte[] item) {
        HiLoHash hiLoHash = this.hashBytesToIntPair(item, this.seed);
        return this.scatterHashAndSetAllBits(hiLoHash);
    }

    @Override
    public boolean mightContainString(String item) {
        return this.mightContainBinary(Utils.getBytesFromUTF8String(item));
    }

    @Override
    public boolean mightContainBinary(byte[] item) {
        HiLoHash hiLoHash = this.hashBytesToIntPair(item, this.seed);
        return this.scatterHashAndGetAllBits(hiLoHash);
    }

    @Override
    public boolean putLong(long item) {
        HiLoHash hiLoHash = this.hashLongToIntPair(item, this.seed);
        return this.scatterHashAndSetAllBits(hiLoHash);
    }

    @Override
    public boolean mightContainLong(long item) {
        HiLoHash hiLoHash = this.hashLongToIntPair(item, this.seed);
        return this.scatterHashAndGetAllBits(hiLoHash);
    }

    @Override
    public boolean mightContain(Object item) {
        if (item instanceof String) {
            String str = (String)item;
            return this.mightContainString(str);
        }
        if (item instanceof byte[]) {
            byte[] bytes = (byte[])item;
            return this.mightContainBinary(bytes);
        }
        return this.mightContainLong(Utils.integralToLong(item));
    }

    @Override
    public boolean isCompatible(BloomFilter other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof BloomFilterBase)) {
            return false;
        }
        BloomFilterBase that = (BloomFilterBase)other;
        return this.getClass() == that.getClass() && this.bitSize() == that.bitSize() && this.numHashFunctions == that.numHashFunctions && this.seed == that.seed;
    }

    @Override
    public BloomFilter mergeInPlace(BloomFilter other) throws IncompatibleMergeException {
        BloomFilterBase otherImplInstance = this.checkCompatibilityForMerge(other);
        this.bits.putAll(otherImplInstance.bits);
        return this;
    }

    @Override
    public BloomFilter intersectInPlace(BloomFilter other) throws IncompatibleMergeException {
        BloomFilterBase otherImplInstance = this.checkCompatibilityForMerge(other);
        this.bits.and(otherImplInstance.bits);
        return this;
    }

    @Override
    public long cardinality() {
        return this.bits.cardinality();
    }

    protected abstract BloomFilterBase checkCompatibilityForMerge(BloomFilter var1) throws IncompatibleMergeException;

    public record HiLoHash(int hi, int lo) {
    }
}

