/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.STRING;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u001d4Q!\u0004\b\u0003\u001diA\u0001\"\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006U\u0001!\ta\u000b\u0005\u0006U\u0001!\tA\f\u0005\bo\u0001\u0001\r\u0011\"\u00059\u0011\u001d\u0001\u0005\u00011A\u0005\u0012\u0005Caa\u0012\u0001!B\u0013I\u0004b\u0002%\u0001\u0001\u0004%\t\u0002\u000f\u0005\b\u0013\u0002\u0001\r\u0011\"\u0005K\u0011\u0019a\u0005\u0001)Q\u0005s!)Q\n\u0001C!\u001d\")\u0011\f\u0001C\u00015\")q\f\u0001C!A\n\t2\u000b\u001e:j]\u001e\u001cu\u000e\\;n]N#\u0018\r^:\u000b\u0005=\u0001\u0012\u0001C2pYVlg.\u0019:\u000b\u0005E\u0011\u0012!C3yK\u000e,H/[8o\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#G5\ta\"\u0003\u0002%\u001d\tY1i\u001c7v[:\u001cF/\u0019;t\u0003-\u0019w\u000e\u001c7bi&|g.\u00133\u0004\u0001A\u0011A\u0004K\u0005\u0003Su\u00111!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0011A&\f\t\u0003E\u0001AQ!\n\u0002A\u0002\u001d\"\"\u0001L\u0018\t\u000bA\u001a\u0001\u0019A\u0019\u0002\u0005\u0011$\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0013\u0003\u0015!\u0018\u0010]3t\u0013\t14G\u0001\u0006TiJLgn\u001a+za\u0016\fQ!\u001e9qKJ,\u0012!\u000f\t\u0003uyj\u0011a\u000f\u0006\u0003iqR!!\u0010\u000b\u0002\rUt7/\u00194f\u0013\ty4H\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\f\u0011\"\u001e9qKJ|F%Z9\u0015\u0005\t+\u0005C\u0001\u000fD\u0013\t!UD\u0001\u0003V]&$\bb\u0002$\u0006\u0003\u0003\u0005\r!O\u0001\u0004q\u0012\n\u0014AB;qa\u0016\u0014\b%A\u0003m_^,'/A\u0005m_^,'o\u0018\u0013fcR\u0011!i\u0013\u0005\b\r\"\t\t\u00111\u0001:\u0003\u0019awn^3sA\u0005Yq-\u0019;iKJ\u001cF/\u0019;t)\r\u0011uj\u0016\u0005\u0006!*\u0001\r!U\u0001\u0004e><\bC\u0001*V\u001b\u0005\u0019&B\u0001+\u0013\u0003!\u0019\u0017\r^1msN$\u0018B\u0001,T\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000baS\u0001\u0019A\u0014\u0002\u000f=\u0014H-\u001b8bY\u0006\u0001r-\u0019;iKJ4\u0016\r\\;f'R\fGo\u001d\u000b\u0004\u0005nk\u0006\"\u0002/\f\u0001\u0004I\u0014!\u0002<bYV,\u0007\"\u00020\f\u0001\u00049\u0013\u0001B:ju\u0016\f1cY8mY\u0016\u001cG/\u001a3Ti\u0006$\u0018n\u001d;jGN,\u0012!\u0019\t\u00049\t$\u0017BA2\u001e\u0005\u0015\t%O]1z!\taR-\u0003\u0002g;\t\u0019\u0011I\\=")
public final class StringColumnStats
implements ColumnStats {
    private final int collationId;
    private UTF8String upper;
    private UTF8String lower;
    private int count;
    private int nullCount;
    private long sizeInBytes;

    @Override
    public void gatherNullStats() {
        ColumnStats.gatherNullStats$(this);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public int nullCount() {
        return this.nullCount;
    }

    @Override
    public void nullCount_$eq(int x$1) {
        this.nullCount = x$1;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void sizeInBytes_$eq(long x$1) {
        this.sizeInBytes = x$1;
    }

    public UTF8String upper() {
        return this.upper;
    }

    public void upper_$eq(UTF8String x$1) {
        this.upper = x$1;
    }

    public UTF8String lower() {
        return this.lower;
    }

    public void lower_$eq(UTF8String x$1) {
        this.lower = x$1;
    }

    @Override
    public void gatherStats(InternalRow row, int ordinal) {
        if (!row.isNullAt(ordinal)) {
            UTF8String value = row.getUTF8String(ordinal);
            int size = new STRING(this.collationId).actualSize(row, ordinal);
            this.gatherValueStats(value, size);
            return;
        }
        this.gatherNullStats();
    }

    public void gatherValueStats(UTF8String value, int size) {
        if (this.upper() == null || value.semanticCompare(this.upper(), this.collationId) > 0) {
            this.upper_$eq(value.clone());
        }
        if (this.lower() == null || value.semanticCompare(this.lower(), this.collationId) < 0) {
            this.lower_$eq(value.clone());
        }
        this.sizeInBytes_$eq(this.sizeInBytes() + (long)size);
        this.count_$eq(this.count() + 1);
    }

    @Override
    public Object[] collectedStatistics() {
        return new Object[]{this.lower(), this.upper(), BoxesRunTime.boxToInteger((int)this.nullCount()), BoxesRunTime.boxToInteger((int)this.count()), BoxesRunTime.boxToLong((long)this.sizeInBytes())};
    }

    public StringColumnStats(int collationId) {
        this.collationId = collationId;
        ColumnStats.$init$(this);
        this.upper = null;
        this.lower = null;
    }

    public StringColumnStats(StringType dt) {
        this(dt.collationId());
    }
}

