/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.LineReader;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.functions$;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CSVUtils$ {
    public static final CSVUtils$ MODULE$ = new CSVUtils$();

    public Dataset<String> filterCommentAndEmpty(Dataset<String> lines, CSVOptions options) {
        Dataset aliased = lines.toDF((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}));
        Dataset nonEmptyLines = aliased.filter(functions$.MODULE$.length(functions$.MODULE$.trim((Column)lines.sparkSession().implicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$))).$greater((Object)BoxesRunTime.boxToInteger((int)0)));
        if (options.isCommentSet()) {
            return nonEmptyLines.filter(lines.sparkSession().implicits().StringToColumn(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((scala.collection.immutable.Seq)Nil$.MODULE$).startsWith(Character.toString(options.comment())).unary_$bang()).as(lines.sparkSession().implicits().newStringEncoder());
        }
        return nonEmptyLines.as(lines.sparkSession().implicits().newStringEncoder());
    }

    public Iterator<String> filterHeaderLine(Iterator<String> iter, String firstLine, CSVOptions options) {
        if (options.headerFlag()) {
            return iter.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$filterHeaderLine$1(firstLine, x$1)));
        }
        return iter;
    }

    public String[] makeSafeHeader(String[] row, boolean caseSensitive, CSVOptions options) {
        if (options.headerFlag()) {
            String[] headerNames = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])row), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$makeSafeHeader$1(x$2)))), (Function1 & Serializable)name -> {
                if (caseSensitive) {
                    return name;
                }
                return name.toLowerCase();
            }, ClassTag$.MODULE$.apply(String.class));
            String[] duplicates = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.diff$extension(Predef$.MODULE$.refArrayOps((Object[])headerNames), (Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])headerNames))))));
            return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])row))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2;
                block5: {
                    int index;
                    String value;
                    block7: {
                        block6: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block5;
                            value = (String)tuple2._1();
                            index = tuple2._2$mcI$sp();
                            if (value == null || value.isEmpty()) break block6;
                            String string = value;
                            String string2 = options.nullValue();
                            if (string != null ? !string.equals(string2) : string2 != null) break block7;
                        }
                        return "_c" + index;
                    }
                    if (!caseSensitive && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])duplicates), (Object)value.toLowerCase())) {
                        return value + index;
                    }
                    if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])duplicates), (Object)value)) {
                        return value + index;
                    }
                    return value;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(String.class));
        }
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])row))), (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int index = tuple2._2$mcI$sp();
                return "_c" + index;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public Dataset<String> sample(Dataset<String> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return csv;
        }
        return csv.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<String[]> sample(RDD<String[]> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable)() -> "samplingRatio (" + options.samplingRatio() + ") should be greater than 0");
        if (options.samplingRatio() > 0.99) {
            return csv;
        }
        return csv.sample(false, options.samplingRatio(), 1L);
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        return CSVExprUtils$.MODULE$.filterCommentAndEmpty(iter, options);
    }

    public Option<String> readHeaderLine(Path filePath, CSVOptions options, Configuration conf) {
        Option option;
        try (InputStream inputStream = CodecStreams$.MODULE$.createInputStream(conf, filePath);){
            Iterator<String> lines = new Iterator<String>(options, inputStream){
                private final LineReader in;
                private final Text text;
                private boolean finished;
                private boolean hasValue;
                private final CSVOptions options$4;

                public final boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public final Iterator<String> iterator() {
                    return Iterator.iterator$((Iterator)this);
                }

                public Option<String> nextOption() {
                    return Iterator.nextOption$((Iterator)this);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public BufferedIterator<String> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator<B> padTo(int len, B elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public int indexWhere(Function1<String, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public int indexWhere$default$2() {
                    return Iterator.indexWhere$default$2$((Iterator)this);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public final int length() {
                    return Iterator.length$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public Iterator<String> filter(Function1<String, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public Iterator<String> filterNot(Function1<String, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public Iterator<String> filterImpl(Function1<String, Object> p, boolean isFlipped) {
                    return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                }

                public Iterator<String> withFilter(Function1<String, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public Iterator<String> distinct() {
                    return Iterator.distinct$((Iterator)this);
                }

                public <B> Iterator<String> distinctBy(Function1<String, B> f) {
                    return Iterator.distinctBy$((Iterator)this, f);
                }

                public <B> Iterator<B> map(Function1<String, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> flatMap(Function1<String, IterableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public <B> Iterator<B> flatten(Function1<String, IterableOnce<B>> ev) {
                    return Iterator.flatten$((Iterator)this, ev);
                }

                public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                    return Iterator.concat$((Iterator)this, xs);
                }

                public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                    return Iterator.$plus$plus$((Iterator)this, xs);
                }

                public Iterator<String> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<String> takeWhile(Function1<String, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Iterator<String> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<String> dropWhile(Function1<String, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<String> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<String> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<Tuple2<String, B>> zip(IterableOnce<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public Iterator<Tuple2<String, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B> boolean sameElements(IterableOnce<B> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <U$> Iterator<String> tapEach(Function1<String, U$> f) {
                    return Iterator.tapEach$((Iterator)this, f);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public Iterator<String> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public Tuple2<Iterator<String>, Iterator<String>> splitAt(int n) {
                    return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                }

                public boolean isTraversableAgain() {
                    return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                }

                public <U$> void foreach(Function1<String, U$> f) {
                    IterableOnceOps.foreach$((IterableOnceOps)this, f);
                }

                public boolean forall(Function1<String, Object> p) {
                    return IterableOnceOps.forall$((IterableOnceOps)this, p);
                }

                public boolean exists(Function1<String, Object> p) {
                    return IterableOnceOps.exists$((IterableOnceOps)this, p);
                }

                public int count(Function1<String, Object> p) {
                    return IterableOnceOps.count$((IterableOnceOps)this, p);
                }

                public Option<String> find(Function1<String, Object> p) {
                    return IterableOnceOps.find$((IterableOnceOps)this, p);
                }

                public <B> B foldLeft(B z, Function2<B, String, B> op) {
                    return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                }

                public <B> B foldRight(B z, Function2<String, B, B> op) {
                    return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                }

                public final <B> B $div$colon(B z, Function2<B, String, B> op) {
                    return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                }

                public final <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                    return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                }

                public <B> B reduce(Function2<B, B, B> op) {
                    return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                    return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                }

                public <B> B reduceLeft(Function2<B, String, B> op) {
                    return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                }

                public <B> B reduceRight(Function2<String, B, B> op) {
                    return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                    return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                    return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                }

                public boolean nonEmpty() {
                    return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                }

                public int size() {
                    return IterableOnceOps.size$((IterableOnceOps)this);
                }

                public final <B> void copyToBuffer(Buffer<B> dest) {
                    IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                }

                public <B> int copyToArray(Object dest) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
                }

                public <B> int copyToArray(Object dest, int start) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
                }

                public <B> int copyToArray(Object dest, int start, int n) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                }

                public Object min(Ordering ord) {
                    return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<String> minOption(Ordering<B> ord) {
                    return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                }

                public Object max(Ordering ord) {
                    return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<String> maxOption(Ordering<B> ord) {
                    return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                }

                public Object maxBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B> Option<String> maxByOption(Function1<String, B> f, Ordering<B> ord) {
                    return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
                }

                public Object minBy(Function1 f, Ordering ord) {
                    return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
                }

                public <B> Option<String> minByOption(Function1<String, B> f, Ordering<B> ord) {
                    return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
                }

                public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                    return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                    return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                }

                public <B> boolean corresponds(IterableOnce<B> that, Function2<String, B, Object> p) {
                    return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                }

                public final String mkString(String start, String sep, String end) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                }

                public final String mkString(String sep) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                }

                public final String mkString() {
                    return IterableOnceOps.mkString$((IterableOnceOps)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public final StringBuilder addString(StringBuilder b, String sep) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                }

                public final StringBuilder addString(StringBuilder b) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                }

                public <C1> C1 to(Factory<String, C1> factory) {
                    return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                }

                public final Iterator<String> toIterator() {
                    return IterableOnceOps.toIterator$((IterableOnceOps)this);
                }

                public List<String> toList() {
                    return IterableOnceOps.toList$((IterableOnceOps)this);
                }

                public Vector<String> toVector() {
                    return IterableOnceOps.toVector$((IterableOnceOps)this);
                }

                public <K, V> Map<K, V> toMap(.less.colon.less<String, Tuple2<K, V>> ev) {
                    return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                }

                public <B> Set<B> toSet() {
                    return IterableOnceOps.toSet$((IterableOnceOps)this);
                }

                public scala.collection.immutable.Seq<String> toSeq() {
                    return IterableOnceOps.toSeq$((IterableOnceOps)this);
                }

                public IndexedSeq<String> toIndexedSeq() {
                    return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                }

                public final Stream<String> toStream() {
                    return IterableOnceOps.toStream$((IterableOnceOps)this);
                }

                public final <B> Buffer<B> toBuffer() {
                    return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                }

                public <B> Object toArray(ClassTag<B> evidence$2) {
                    return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                }

                public Iterable<String> reversed() {
                    return IterableOnceOps.reversed$((IterableOnceOps)this);
                }

                public <S$ extends Stepper<?>> S$ stepper(StepperShape<String, S$> shape) {
                    return (S$)IterableOnce.stepper$((IterableOnce)this, shape);
                }

                public int knownSize() {
                    return IterableOnce.knownSize$((IterableOnce)this);
                }

                private LineReader in() {
                    return this.in;
                }

                private Text text() {
                    return this.text;
                }

                private boolean finished() {
                    return this.finished;
                }

                private void finished_$eq(boolean x$1) {
                    this.finished = x$1;
                }

                private boolean hasValue() {
                    return this.hasValue;
                }

                private void hasValue_$eq(boolean x$1) {
                    this.hasValue = x$1;
                }

                public boolean hasNext() {
                    if (!this.finished() && !this.hasValue()) {
                        int bytesRead = this.in().readLine(this.text());
                        this.finished_$eq(bytesRead == 0);
                        this.hasValue_$eq(!this.finished());
                    }
                    return !this.finished();
                }

                public String next() {
                    if (!this.hasValue()) {
                        throw QueryExecutionErrors$.MODULE$.endOfStreamError();
                    }
                    this.hasValue_$eq(false);
                    return new String(this.text().getBytes(), 0, this.text().getLength(), this.options$4.charset());
                }
                {
                    LineReader lineReader;
                    this.options$4 = options$4;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                    Option option = options$4.lineSeparatorInRead();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] sep = (byte[])some.value();
                        lineReader = new LineReader(inputStream$1, sep);
                    } else {
                        lineReader = new LineReader(inputStream$1);
                    }
                    this.in = lineReader;
                    this.text = new Text();
                    this.finished = false;
                    this.hasValue = false;
                }
            };
            Iterator<String> filteredLines = this.filterCommentAndEmpty(lines, options);
            option = filteredLines.buffered().headOption();
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$filterHeaderLine$1(String firstLine$1, String x$1) {
        String string = x$1;
        String string2 = firstLine$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeSafeHeader$1(String x$2) {
        return x$2 != null;
    }

    private CSVUtils$() {
    }
}

