/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.streaming.SupportsRealTimeRead;
import org.apache.spark.sql.execution.streaming.runtime.ContinuousRecordPartitionOffset;
import org.apache.spark.sql.execution.streaming.runtime.GetRecord;
import org.apache.spark.util.Clock;
import org.apache.spark.util.RpcUtils$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\f\u0018\u0001\u0011B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003S\u0011!9\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000b}\u0003A\u0011\u00011\t\u000f%\u0004!\u0019!C\u0005U\"1a\u000e\u0001Q\u0001\n-Dqa\u001c\u0001A\u0002\u0013%\u0001\u000fC\u0004r\u0001\u0001\u0007I\u0011\u0002:\t\ra\u0004\u0001\u0015)\u0003S\u0011\u001dI\b\u00011A\u0005\niDqA \u0001A\u0002\u0013%q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015B>\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\ty\u0005\u0001C!\u0003#Ba!a\u0018\u0001\t\u0013Q(!\n'po2\u000bG/\u001a8ds6+Wn\u001c:z'R\u0014X-Y7QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\u0015\tA\u0012$A\u0005tiJ,\u0017-\\5oO*\u0011!dG\u0001\nKb,7-\u001e;j_:T!\u0001H\u000f\u0002\u0007M\fHN\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0013.!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003mC:<'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aa\u00142kK\u000e$\bc\u0001\u00185m5\tqF\u0003\u0002\u0019a)\u0011\u0011GM\u0001\u0005e\u0016\fGM\u0003\u000247\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003k=\u0012AcU;qa>\u0014Ho\u001d*fC2$\u0016.\\3SK\u0006$\u0007CA\u001c;\u001b\u0005A$BA\u001d\u001c\u0003!\u0019\u0017\r^1msN$\u0018BA\u001e9\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002%\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oi:\u000bW.\u001a\t\u0003}\u001ds!aP#\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t\u001b\u0013A\u0002\u001fs_>$hHC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$D\u0003U!'/\u001b<fe\u0016sG\r]8j]R\fE\r\u001a:fgN\u0004\"\u0001T(\u000e\u00035S!AT\u000f\u0002\u0007I\u00048-\u0003\u0002Q\u001b\nQ!\u000b]2BI\u0012\u0014Xm]:\u0002\u0013A\f'\u000f^5uS>t\u0007CA*U\u001b\u0005\u0019\u0015BA+D\u0005\rIe\u000e^\u0001\fgR\f'\u000f^(gMN,G/A\u0005f]\u0012|eMZ:fi\u0006)1\r\\8dWB\u0011!,X\u0007\u00027*\u0011A,H\u0001\u0005kRLG.\u0003\u0002_7\n)1\t\\8dW\u00061A(\u001b8jiz\"r!Y2eK\u001a<\u0007\u000e\u0005\u0002c\u00015\tq\u0003C\u0003=\u000f\u0001\u0007Q\bC\u0003K\u000f\u0001\u00071\nC\u0003R\u000f\u0001\u0007!\u000bC\u0003W\u000f\u0001\u0007!\u000bC\u0003X\u000f\u0001\u0007!\u000bC\u0003Y\u000f\u0001\u0007\u0011,\u0001\u0005f]\u0012\u0004x.\u001b8u+\u0005Y\u0007C\u0001'm\u0013\tiWJ\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002\u0013\u0015tG\r]8j]R\u0004\u0013!D2veJ,g\u000e^(gMN,G/F\u0001S\u0003E\u0019WO\u001d:f]R|eMZ:fi~#S-\u001d\u000b\u0003gZ\u0004\"a\u0015;\n\u0005U\u001c%\u0001B+oSRDqa^\u0006\u0002\u0002\u0003\u0007!+A\u0002yIE\nabY;se\u0016tGo\u00144gg\u0016$\b%A\u0004dkJ\u0014XM\u001c;\u0016\u0003m\u00042a\u0015?7\u0013\ti8I\u0001\u0004PaRLwN\\\u0001\fGV\u0014(/\u001a8u?\u0012*\u0017\u000fF\u0002t\u0003\u0003Aqa\u001e\b\u0002\u0002\u0003\u000710\u0001\u0005dkJ\u0014XM\u001c;!\u0003=qW\r\u001f;XSRDG+[7f_V$H\u0003BA\u0005\u0003g\u0001B!a\u0003\u0002.9!\u0011QBA\u0015\u001d\u0011\ty!a\n\u000f\t\u0005E\u0011Q\u0005\b\u0005\u0003'\t\u0019C\u0004\u0003\u0002\u0016\u0005\u0005b\u0002BA\f\u0003?qA!!\u0007\u0002\u001e9\u0019\u0001)a\u0007\n\u0003\tJ!\u0001I\u0011\n\u0005yy\u0012B\u0001\u000f\u001e\u0013\t\u00194$\u0003\u00022e%\u0011\u0001\u0004M\u0005\u0004\u0003Wy\u0013\u0001F*vaB|'\u000f^:SK\u0006dG+[7f%\u0016\fG-\u0003\u0003\u00020\u0005E\"\u0001\u0004*fG>\u0014Hm\u0015;biV\u001c(bAA\u0016_!9\u0011Q\u0007\tA\u0002\u0005]\u0012a\u0002;j[\u0016|W\u000f\u001e\t\u0004M\u0005e\u0012bAA\u001eO\t!Aj\u001c8h\u0003\u0011qW\r\u001f;\u0015\u0005\u0005\u0005\u0003cA*\u0002D%\u0019\u0011QI\"\u0003\u000f\t{w\u000e\\3b]\u0006\u0019q-\u001a;\u0015\u0003Y\nQa\u00197pg\u0016$\u0012a]\u0001\nO\u0016$xJ\u001a4tKR$\"!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\u0018\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0018\u0002X\ty2i\u001c8uS:,x.^:SK\u000e|'\u000f\u001a)beRLG/[8o\u001f\u001a47/\u001a;\u0002\u0013\u001d,GOU3d_J$\u0007")
public class LowLatencyMemoryStreamPartitionReader
implements SupportsRealTimeRead<InternalRow> {
    private final int partition;
    private final int endOffset;
    private final Clock clock;
    private final RpcEndpointRef endpoint;
    private int currentOffset;
    private Option<InternalRow> current;

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private int currentOffset() {
        return this.currentOffset;
    }

    private void currentOffset_$eq(int x$1) {
        this.currentOffset = x$1;
    }

    private Option<InternalRow> current() {
        return this.current;
    }

    private void current_$eq(Option<InternalRow> x$1) {
        this.current = x$1;
    }

    public SupportsRealTimeRead.RecordStatus nextWithTimeout(Long timeout) {
        long startReadTime = this.clock.nanoTime();
        long elapsedTimeMs = 0L;
        this.current_$eq(this.getRecord());
        while (this.current().isEmpty()) {
            long POLL_TIME = 10L;
            if (elapsedTimeMs >= Predef$.MODULE$.Long2long(timeout)) {
                return SupportsRealTimeRead.RecordStatus.newStatusWithoutArrivalTime((boolean)false);
            }
            Thread.sleep(POLL_TIME);
            this.current_$eq(this.getRecord());
            elapsedTimeMs = (this.clock.nanoTime() - startReadTime) / 1000L / 1000L;
        }
        this.currentOffset_$eq(this.currentOffset() + 1);
        return SupportsRealTimeRead.RecordStatus.newStatusWithoutArrivalTime((boolean)true);
    }

    public boolean next() {
        this.current_$eq(this.getRecord());
        if (this.current().isDefined()) {
            this.currentOffset_$eq(this.currentOffset() + 1);
            return true;
        }
        return false;
    }

    public InternalRow get() {
        return (InternalRow)this.current().get();
    }

    public void close() {
    }

    public ContinuousRecordPartitionOffset getOffset() {
        return new ContinuousRecordPartitionOffset(this.partition, this.currentOffset());
    }

    private Option<InternalRow> getRecord() {
        if (this.currentOffset() >= this.endOffset) {
            return None$.MODULE$;
        }
        return (Option)this.endpoint().askSync((Object)new GetRecord(new ContinuousRecordPartitionOffset(this.partition, this.currentOffset())), ClassTag$.MODULE$.apply(Option.class));
    }

    public LowLatencyMemoryStreamPartitionReader(String driverEndpointName, RpcAddress driverEndpointAddress, int partition, int startOffset, int endOffset, Clock clock) {
        this.partition = partition;
        this.endOffset = endOffset;
        this.clock = clock;
        this.endpoint = RpcUtils$.MODULE$.makeDriverRef(driverEndpointName, driverEndpointAddress.host(), driverEndpointAddress.port(), SparkEnv$.MODULE$.get().rpcEnv());
        this.currentOffset = startOffset;
        this.current = None$.MODULE$;
        if (TaskContext$.MODULE$.get() == null) {
            throw new IllegalStateException("Task context was not set!");
        }
    }
}

