/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.streaming.ui.StreamingQueryDataSource;
import org.apache.spark.sql.streaming.ui.StreamingQueryTab;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.StructuredStreamingRow;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.PagedDataSource;
import org.apache.spark.ui.PagedTable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!B\u000f\u001f\u0001yQ\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t5\u0002\u0011\t\u0011)A\u00057\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003\\\u0011!A\u0007A!A!\u0002\u0013Y\u0006\"B5\u0001\t\u0003Q\u0007BC:\u0001!\u0003\u0005\u0019\u0011)A\u0005i\"9!\u0010\u0001b\u0001\n\u0013Y\bB\u0002?\u0001A\u0003%1\fC\u0004~\u0001\t\u0007I\u0011\u0002@\t\r}\u0004\u0001\u0015!\u0003e\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B<\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0003\t\u0013\u0005m\u0001A1A\u0005\n\u0005%\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0003\t\r\u0005}\u0001\u0001\"\u0011|\u0011\u0019\t\t\u0003\u0001C!w\"1\u00111\u0005\u0001\u0005BmDa!!\n\u0001\t\u0003Z\bbBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\u0007\u0003_\u0001A\u0011I>\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u00111\b\u0001\u0005B\u0005u\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0002\u0019'R\u0014X-Y7j]\u001e\fV/\u001a:z!\u0006<W\r\u001a+bE2,'BA\u0010!\u0003\t)\u0018N\u0003\u0002\"E\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u00042A\r\u001b7\u001b\u0005\u0019$BA\u0010%\u0013\t)4G\u0001\u0006QC\u001e,G\rV1cY\u0016\u0004\"a\u000e\u001d\u000e\u0003yI!!\u000f\u0010\u0003-M#(/^2ukJ,Gm\u0015;sK\u0006l\u0017N\\4S_^\fqA]3rk\u0016\u001cHo\u0001\u0001\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015\u0001\u00025uiBT!!\u0011\"\u0002\u000fM,'O\u001e7fi*\t1)A\u0004kC.\f'\u000f^1\n\u0005\u0015s$A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\fa\u0001]1sK:$\bCA\u001cI\u0013\tIeDA\tTiJ,\u0017-\\5oOF+XM]=UC\n\fA\u0001Z1uCB\u0019A\nV,\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)<\u0003\u0019a$o\\8u}%\ta&\u0003\u0002T[\u00059\u0001/Y2lC\u001e,\u0017BA+W\u0005\r\u0019V-\u001d\u0006\u0003'6\u0002\"a\u000e-\n\u0005es\"\u0001F*ue\u0016\fW.\u001b8h#V,'/_+J\t\u0006$\u0018-\u0001\u0005uC\ndW\rV1h!\ta\u0006M\u0004\u0002^=B\u0011a*L\u0005\u0003?6\na\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q,L\u0001\tSN\f5\r^5wKB\u0011A&Z\u0005\u0003M6\u0012qAQ8pY\u0016\fg.\u0001\u0005cCN,\u0007+\u0019;i\u0003\u001d\u0019XO\u0019)bi\"\fa\u0001P5oSRtD\u0003C6m[:|\u0007/\u001d:\u0011\u0005]\u0002\u0001\"\u0002\u001e\t\u0001\u0004a\u0004\"\u0002$\t\u0001\u00049\u0005\"\u0002&\t\u0001\u0004Y\u0005\"\u0002.\t\u0001\u0004Y\u0006\"B2\t\u0001\u0004!\u0007\"B4\t\u0001\u0004Y\u0006\"\u00025\t\u0001\u0004Y\u0016a\u0001=%iA)A&^.eo&\u0011a/\f\u0002\u0007)V\u0004H.Z\u001a\u0011\u00051B\u0018BA=.\u0005\rIe\u000e^\u0001\u000bg>\u0014HoQ8mk6tW#A.\u0002\u0017M|'\u000f^\"pYVlg\u000eI\u0001\tg>\u0014H\u000fR3tGV\tA-A\u0005t_J$H)Z:dA\u0005A\u0001/Y4f'&TX-F\u0001x\u0003%\u0001\u0018mZ3TSj,\u0007%A\u0007qCJ\fW.\u001a;feB\u000bG\u000f[\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0003mC:<'BAA\u000b\u0003\u0011Q\u0017M^1\n\u0007\u0005\fy!\u0001\bqCJ\fW.\u001a;feB\u000bG\u000f\u001b\u0011\u0002#\u0015t7m\u001c3fIN{'\u000f^\"pYVlg.\u0001\nf]\u000e|G-\u001a3T_J$8i\u001c7v[:\u0004\u0013a\u0002;bE2,\u0017\nZ\u0001\u000ei\u0006\u0014G.Z\"tg\u000ec\u0017m]:\u0002#A\fw-Z*ju\u00164uN]7GS\u0016dG-A\nqC\u001e,g*^7cKJ4uN]7GS\u0016dG-\u0001\u0005qC\u001e,G*\u001b8l)\rY\u00161\u0006\u0005\u0007\u0003[A\u0002\u0019A<\u0002\tA\fw-Z\u0001\u0011O>\u0014U\u000f\u001e;p]\u001a{'/\u001c)bi\"\f!\u0002Z1uCN{WO]2f+\t\t)\u0004\u0005\u00033\u0003o1\u0014bAA\u001dg\ty\u0001+Y4fI\u0012\u000bG/Y*pkJ\u001cW-A\u0004iK\u0006$WM]:\u0016\u0005\u0005}\u0002\u0003\u0002'U\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fj\u0013a\u0001=nY&!\u00111JA#\u0005\u0011qu\u000eZ3\u0002\u0007I|w\u000f\u0006\u0003\u0002@\u0005E\u0003BBA*9\u0001\u0007a'A\u0003rk\u0016\u0014\u0018\u0010")
public class StreamingQueryPagedTable
implements PagedTable<StructuredStreamingRow> {
    private final HttpServletRequest request;
    private final StreamingQueryTab parent;
    private final Seq<StreamingQueryUIData> data;
    private final String tableTag;
    private final boolean isActive;
    private final /* synthetic */ Tuple3 x$4;
    private final String sortColumn;
    private final boolean sortDesc;
    private final int pageSize;
    private final String parameterPath;
    private final String encodedSortColumn;

    public Seq<Node> table(int page) {
        return PagedTable.table$((PagedTable)this, (int)page);
    }

    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$((PagedTable)this, (int)page, (int)pageSize, (int)totalPages, (String)navigationId);
    }

    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$((PagedTable)this);
    }

    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$((PagedTable)this, (HttpServletRequest)request, (String)tableTag);
    }

    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$((PagedTable)this, (HttpServletRequest)request, (String)tableTag, (String)defaultSortColumn);
    }

    public void isSortColumnValid(Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$((PagedTable)this, headerInfo, (String)sortColumn);
    }

    public Seq<Node> headerRow(Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$((PagedTable)this, headerInfo, (boolean)desc, (int)pageSize, (String)sortColumn, (String)parameterPath, (String)tableTag, (String)headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean sortDesc() {
        return this.sortDesc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    private String parameterPath() {
        return this.parameterPath;
    }

    private String encodedSortColumn() {
        return this.encodedSortColumn;
    }

    public String tableId() {
        return this.tableTag + "-table";
    }

    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable table-cell-width-limited";
    }

    public String pageSizeFormField() {
        return this.tableTag + ".pageSize";
    }

    public String pageNumberFormField() {
        return this.tableTag + ".page";
    }

    public String pageLink(int page) {
        return this.parameterPath() + "&" + this.pageNumberFormField() + "=" + page + "&" + this.tableTag + ".sort=" + this.encodedSortColumn() + "&" + this.tableTag + ".desc=" + this.sortDesc() + "&" + this.pageSizeFormField() + "=" + this.pageSize() + "#" + this.tableTag;
    }

    public String goButtonFormPath() {
        return this.parameterPath() + "&" + this.tableTag + ".sort=" + this.encodedSortColumn() + "&" + this.tableTag + ".desc=" + this.sortDesc() + "#" + this.tableTag;
    }

    public PagedDataSource<StructuredStreamingRow> dataSource() {
        return new StreamingQueryDataSource(this.data, this.sortColumn(), this.sortDesc(), this.pageSize(), this.isActive);
    }

    public Seq<Node> headers() {
        Seq headerAndCss = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"Name", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Status", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Run ID", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Start Time", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Duration", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Input /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Avg Process /sec", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Latest Batch", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$)})).$plus$plus((IterableOnce)(!this.isActive ? new .colon.colon((Object)new Tuple3((Object)"Error", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$), (List)Nil$.MODULE$) : Nil$.MODULE$));
        this.isSortColumnValid((Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortColumn());
        return this.headerRow((Seq<Tuple3<String, Object, Option<String>>>)headerAndCss, this.sortDesc(), this.pageSize(), this.sortColumn(), this.parameterPath(), this.tableTag, this.tableTag);
    }

    public Seq<Node> row(StructuredStreamingRow query) {
        StreamingQueryUIData streamingQuery = query.streamingUIData();
        String statisticsLink = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s/%s/statistics/?id=%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri(this.request, this.parent.basePath(), org.apache.spark.ui.UIUtils$.MODULE$.prependBaseUri$default$3()), this.parent.prefix(), streamingQuery.summary().runId()}));
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.getQueryName(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)UIUtils$.MODULE$.getQueryStatus(streamingQuery));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)streamingQuery.summary().id());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", statisticsLink, (MetaData)$md);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)streamingQuery.summary().runId());
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6.toVector()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDate(streamingQuery.summary().startTimestamp()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.formatDurationVerbose(query.duration()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)query.avgInput())})), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)query.avgProcess())})), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)UIUtils$.MODULE$.withNoProgress(streamingQuery, (JFunction0.mcJ.sp & Serializable)() -> streamingQuery.lastProgress().batchId(), "NaN"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.details$1(streamingQuery));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf.toVector());
    }

    private final Seq details$1(StreamingQueryUIData streamingQuery$1) {
        if (this.isActive) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        return org.apache.spark.ui.UIUtils$.MODULE$.errorMessageCell((String)streamingQuery$1.summary().exception().getOrElse((Function0 & Serializable)() -> "-"));
    }

    public StreamingQueryPagedTable(HttpServletRequest request, StreamingQueryTab parent, Seq<StreamingQueryUIData> data, String tableTag, boolean isActive, String basePath, String subPath) {
        this.request = request;
        this.parent = parent;
        this.data = data;
        this.tableTag = tableTag;
        this.isActive = isActive;
        PagedTable.$init$((PagedTable)this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, tableTag, "Start Time");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean sortDesc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        this.x$4 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)sortDesc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.sortColumn = (String)this.x$4._1();
        this.sortDesc = BoxesRunTime.unboxToBoolean((Object)this.x$4._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$4._3());
        this.parameterPath = basePath + "/" + subPath + "/?" + this.getParameterOtherTable(request, tableTag);
        this.encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
    }
}

