/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.optim.aggregator.HuberBlockAggregator;
import org.apache.spark.ml.optim.aggregator.LeastSquaresBlockAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLoss;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.LinearRegression$;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.Instrumentation$loggerTags$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u0015b\u0001\u0002\u00180\u0001iB\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t%\u0017\u0005\ta\u0002\u0011\t\u0011)A\u00055\")!\u000f\u0001C\u0001g\")!\u000f\u0001C\u0001o\")1\u0010\u0001C\u0001y\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!a!\u0001\t#\n)\tC\u0004\u00020\u0002!I!!-\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9\u0011q \u0001\u0005\n\t\u0005\u0001b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005k\u0002A\u0011\u0002B<\u0011\u001d\u0011)\t\u0001C!\u0005\u000fCqAa'\u0001\t\u0003\u0012ijB\u0004\u00034>B\tA!.\u0007\r9z\u0003\u0012\u0001B\\\u0011\u0019\u0011(\u0004\"\u0001\u0003V\"9!q\u001b\u000e\u0005B\te\u0007\"\u0003Bq5\t\u0007I\u0011\u0001Br\u0011!\u00119O\u0007Q\u0001\n\u0005M\u0002B\u0003Bv5\t\u0007I\u0011A\u0018\u0003n\"A!\u0011 \u000e!\u0002\u0013\u0011y\u000f\u0003\u0006\u0003|j\u0011\r\u0011\"\u00010\u0005[D\u0001B!@\u001bA\u0003%!q\u001e\u0005\u000b\u0005\u007fT\"\u0019!C\u0001_\t5\b\u0002CB\u00015\u0001\u0006IAa<\t\u0015\r\r!D1A\u0005\u0002=\u001a)\u0001\u0003\u0005\u0004\ni\u0001\u000b\u0011BB\u0004\u0011)\u0019YA\u0007b\u0001\n\u0003y#Q\u001e\u0005\t\u0007\u001bQ\u0002\u0015!\u0003\u0003p\"Q1q\u0002\u000eC\u0002\u0013\u0005qF!<\t\u0011\rE!\u0004)A\u0005\u0005_D!ba\u0005\u001b\u0005\u0004%\taLB\u0003\u0011!\u0019)B\u0007Q\u0001\n\r\u001d\u0001\"CB\f5\u0005\u0005I\u0011BB\r\u0005Aa\u0015N\\3beJ+wM]3tg&|gN\u0003\u00021c\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005I\u001a\u0014AA7m\u0015\t!T'A\u0003ta\u0006\u00148N\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<7\u0001A\n\u0006\u0001mJEJ\u0015\t\u0006yuzTIR\u0007\u0002_%\u0011ah\f\u0002\n%\u0016<'/Z:t_J\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0019\u0002\r1Lg.\u00197h\u0013\t!\u0015I\u0001\u0004WK\u000e$xN\u001d\t\u0003y\u0001\u0001\"\u0001P$\n\u0005!{#!\u0006'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003y)K!aS\u0018\u0003-1Kg.Z1s%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"!\u0014)\u000e\u00039S!aT\u0019\u0002\tU$\u0018\u000e\\\u0005\u0003#:\u0013Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW\r\u0005\u0002T-6\tAK\u0003\u0002Vg\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002X)\n9Aj\\4hS:<\u0017aA;jIV\t!\f\u0005\u0002\\I:\u0011AL\u0019\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?f\na\u0001\u0010:p_Rt$\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0004\u0017A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u00191)\u0007\u0005Ag\u000e\u0005\u0002jY6\t!N\u0003\u0002lg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00055T'!B*j]\u000e,\u0017%A8\u0002\u000bEr3G\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005!t\u0017A\u0002\u001fj]&$h\b\u0006\u0002Fi\")\u0001l\u0001a\u00015\"\u001aA\u000f\u001b8)\u0007\rAg\u000eF\u0001FQ\r!\u0001._\u0011\u0002u\u0006)\u0011G\f\u001b/a\u0005Y1/\u001a;SK\u001e\u0004\u0016M]1n)\tih0D\u0001\u0001\u0011\u0019yX\u00011\u0001\u0002\u0002\u0005)a/\u00197vKB!\u00111AA\u0003\u001b\u0005\u0001\u0017bAA\u0004A\n1Ai\\;cY\u0016D3!\u00025o\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HcA?\u0002\u0010!1qP\u0002a\u0001\u0003#\u0001B!a\u0001\u0002\u0014%\u0019\u0011Q\u00031\u0003\u000f\t{w\u000e\\3b]\"\"a\u0001[A\rC\t\tY\"A\u00032]Ur\u0003'\u0001\ntKR\u001cF/\u00198eCJ$\u0017N_1uS>tGcA?\u0002\"!1qp\u0002a\u0001\u0003#ACa\u00025\u0002\u001a\u0005\u00112/\u001a;FY\u0006\u001cH/[2OKR\u0004\u0016M]1n)\ri\u0018\u0011\u0006\u0005\u0007\u007f\"\u0001\r!!\u0001)\u0007!A\u00170\u0001\u0006tKRl\u0015\r_%uKJ$2!`A\u0019\u0011\u0019y\u0018\u00021\u0001\u00024A!\u00111AA\u001b\u0013\r\t9\u0004\u0019\u0002\u0004\u0013:$\bfA\u0005i]\u000611/\u001a;U_2$2!`A \u0011\u0019y(\u00021\u0001\u0002\u0002!\u001a!\u0002[=\u0002\u0019M,GoV3jO\"$8i\u001c7\u0015\u0007u\f9\u0005C\u0003\u0000\u0017\u0001\u0007!\f\u000b\u0003\fQ\u0006-\u0013EAA'\u0003\u0015\tdF\u000e\u00181\u0003%\u0019X\r^*pYZ,'\u000fF\u0002~\u0003'BQa \u0007A\u0002iCC\u0001\u00045\u0002L\u0005\u00192/\u001a;BO\u001e\u0014XmZ1uS>tG)\u001a9uQR\u0019Q0a\u0017\t\r}l\u0001\u0019AA\u001aQ\u0011i\u0001.a\u0018\"\u0005\u0005\u0005\u0014!\u0002\u001a/c9\u0002\u0014aB:fi2{7o\u001d\u000b\u0004{\u0006\u001d\u0004\"B@\u000f\u0001\u0004Q\u0006\u0006\u0002\bi\u0003W\n#!!\u001c\u0002\u000bIr3G\f\u0019\u0002\u0015M,G/\u00129tS2|g\u000eF\u0002~\u0003gBaa`\bA\u0002\u0005\u0005\u0001\u0006B\bi\u0003W\n1c]3u\u001b\u0006D(\t\\8dWNK'0Z%o\u001b\n#2!`A>\u0011\u0019y\b\u00031\u0001\u0002\u0002!\"\u0001\u0003[A@C\t\t\t)A\u00034]Er\u0003'A\u0003ue\u0006Lg\u000eF\u0002G\u0003\u000fCq!!#\u0012\u0001\u0004\tY)A\u0004eCR\f7/\u001a;1\t\u00055\u0015Q\u0014\t\u0007\u0003\u001f\u000b)*!'\u000e\u0005\u0005E%bAAJg\u0005\u00191/\u001d7\n\t\u0005]\u0015\u0011\u0013\u0002\b\t\u0006$\u0018m]3u!\u0011\tY*!(\r\u0001\u0011a\u0011qTAD\u0003\u0003\u0005\tQ!\u0001\u0002\"\n\u0019q\fJ\u0019\u0012\t\u0005\r\u0016\u0011\u0016\t\u0005\u0003\u0007\t)+C\u0002\u0002(\u0002\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0004\u0005-\u0016bAAWA\n\u0019\u0011I\\=\u0002\u001fQ\u0014\u0018-\u001b8XSRDgj\u001c:nC2$rARAZ\u0003\u007f\u000bY\u000eC\u0004\u0002\nJ\u0001\r!!.1\t\u0005]\u00161\u0018\t\u0007\u0003\u001f\u000b)*!/\u0011\t\u0005m\u00151\u0018\u0003\r\u0003{\u000b\u0019,!A\u0001\u0002\u000b\u0005\u0011\u0011\u0015\u0002\u0004?\u0012\u0012\u0004bBAa%\u0001\u0007\u00111Y\u0001\nS:\u001cH/\u00198dKN\u0004b!!2\u0002L\u0006=WBAAd\u0015\r\tImM\u0001\u0004e\u0012$\u0017\u0002BAg\u0003\u000f\u00141A\u0015#E!\u0011\t\t.a6\u000e\u0005\u0005M'bAAkc\u00059a-Z1ukJ,\u0017\u0002BAm\u0003'\u0014\u0001\"\u00138ti\u0006t7-\u001a\u0005\b\u0003;\u0014\u0002\u0019AAp\u0003\u0015Ign\u001d;s!\ri\u0015\u0011]\u0005\u0004\u0003Gt%aD%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u0002-Q\u0014\u0018-\u001b8XSRD7i\u001c8ti\u0006tG\u000fT1cK2$\u0012BRAu\u0003k\f90a?\t\u000f\u0005%5\u00031\u0001\u0002lB\"\u0011Q^Ay!\u0019\ty)!&\u0002pB!\u00111TAy\t1\t\u00190!;\u0002\u0002\u0003\u0005)\u0011AAQ\u0005\ryFe\r\u0005\b\u0003;\u001c\u0002\u0019AAp\u0011\u001d\tIp\u0005a\u0001\u0003g\t1B\\;n\r\u0016\fG/\u001e:fg\"9\u0011Q`\nA\u0002\u0005\u0005\u0011!B=NK\u0006t\u0017aD2sK\u0006$Xm\u00149uS6L'0\u001a:\u0015\u0015\t\r!1\u0005B\u0014\u0005W\u0011i\u0003\u0005\u0005\u0003\u0006\t=!1\u0003B\u000f\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011\u0001C8qi&l\u0017N_3\u000b\u0005\t5\u0011A\u00022sK\u0016TX-\u0003\u0003\u0003\u0012\t\u001d!a\u0005$jeN$xJ\u001d3fe6Kg.[7ju\u0016\u0014\bC\u0002B\u000b\u00053\t\t!\u0004\u0002\u0003\u0018)\u0019!Ia\u0003\n\t\tm!q\u0003\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0005\u0004\u0003\u0006\t}!1C\u0005\u0005\u0005C\u00119A\u0001\u0007ES\u001a4g)\u001e8di&|g\u000eC\u0004\u0003&Q\u0001\r!!\u0001\u0002#\u00154g-Z2uSZ,'+Z4QCJ\fW\u000eC\u0004\u0003*Q\u0001\r!!\u0001\u0002'\u00154g-Z2uSZ,G*\r*fOB\u000b'/Y7\t\u000f\u0005eH\u00031\u0001\u00024!9!q\u0006\u000bA\u0002\tE\u0012a\u00034fCR,(/Z:Ti\u0012\u0004b!a\u0001\u00034\u0005\u0005\u0011b\u0001B\u001bA\n)\u0011I\u001d:bs\u0006IAO]1j]&k\u0007\u000f\u001c\u000b\u0015\u0005w\u0011\tEa\u0011\u0003H\t%#Q\nB)\u0005'\u00129F!\u001d\u0011\u0011\u0005\r!Q\bB\u0019\u0005cI1Aa\u0010a\u0005\u0019!V\u000f\u001d7fe!9\u0011\u0011Y\u000bA\u0002\u0005\r\u0007b\u0002B#+\u0001\u0007\u0011\u0011A\u0001\u0014C\u000e$X/\u00197CY>\u001c7nU5{K&sWJ\u0011\u0005\b\u0003{,\u0002\u0019AA\u0001\u0011\u001d\u0011Y%\u0006a\u0001\u0003\u0003\tA!_*uI\"9!qJ\u000bA\u0002\tE\u0012\u0001\u00044fCR,(/Z:NK\u0006t\u0007b\u0002B\u0018+\u0001\u0007!\u0011\u0007\u0005\b\u0005+*\u0002\u0019\u0001B\u0019\u0003=Ig.\u001b;jC2\u001cv\u000e\\;uS>t\u0007b\u0002B-+\u0001\u0007!1L\u0001\u000fe\u0016<W\u000f\\1sSj\fG/[8o!\u0019\t\u0019A!\u0018\u0003b%\u0019!q\f1\u0003\r=\u0003H/[8o!\u0011\u0011\u0019G!\u001c\u000e\u0005\t\u0015$\u0002\u0002B4\u0005S\nA\u0001\\8tg*\u0019!1N\u0019\u0002\u000b=\u0004H/[7\n\t\t=$Q\r\u0002\u0011\u0019J\u0012VmZ;mCJL'0\u0019;j_:DqAa\u001d\u0016\u0001\u0004\u0011\u0019!A\u0005paRLW.\u001b>fe\u0006Y1M]3bi\u0016lu\u000eZ3m)-1%\u0011\u0010B?\u0005\u007f\u0012\tIa!\t\u000f\tmd\u00031\u0001\u00032\u0005A1o\u001c7vi&|g\u000eC\u0004\u0002~Z\u0001\r!!\u0001\t\u000f\t-c\u00031\u0001\u0002\u0002!9!q\n\fA\u0002\tE\u0002b\u0002B\u0018-\u0001\u0007!\u0011G\u0001\u0005G>\u0004\u0018\u0010F\u0002F\u0005\u0013CqAa#\u0018\u0001\u0004\u0011i)A\u0003fqR\u0014\u0018\r\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\r\u0011\u0019*M\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0005/\u0013\tJ\u0001\u0005QCJ\fW.T1qQ\r9\u0002._\u0001\u0012KN$\u0018.\\1uK6{G-\u001a7TSj,G\u0003\u0002BP\u0005K\u0003B!a\u0001\u0003\"&\u0019!1\u00151\u0003\t1{gn\u001a\u0005\b\u0003\u0013C\u0002\u0019\u0001BTa\u0011\u0011IK!,\u0011\r\u0005=\u0015Q\u0013BV!\u0011\tYJ!,\u0005\u0019\t=&QUA\u0001\u0002\u0003\u0015\t!!)\u0003\u0007}#C\u0007K\u0002\u0001Q:\f\u0001\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8\u0011\u0005qR2c\u0002\u000e\u0003:\n}&Q\u0019\t\u0005\u0003\u0007\u0011Y,C\u0002\u0003>\u0002\u0014a!\u00118z%\u00164\u0007\u0003B'\u0003B\u0016K1Aa1O\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u0004BAa2\u0003R6\u0011!\u0011\u001a\u0006\u0005\u0005\u0017\u0014i-\u0001\u0002j_*\u0011!qZ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003T\n%'\u0001D*fe&\fG.\u001b>bE2,GC\u0001B[\u0003\u0011aw.\u00193\u0015\u0007\u0015\u0013Y\u000e\u0003\u0004\u0003^r\u0001\rAW\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u001dQ\u0006-\u0013AH'B1~3U)\u0011+V%\u0016\u001bvLR(S?:{%+T!M?N{EJV#S+\t\t\u0019\u0004\u000b\u0003\u001eQ\u0006}\u0013aH'B1~3U)\u0011+V%\u0016\u001bvLR(S?:{%+T!M?N{EJV#SA!\"a\u0004[A0\u0003\u0011\tU\u000f^8\u0016\u0005\t=\b\u0003\u0002By\u0005ol!Aa=\u000b\t\tU(QZ\u0001\u0005Y\u0006tw-C\u0002f\u0005g\fQ!Q;u_\u0002\naAT8s[\u0006d\u0017a\u0002(pe6\fG\u000eI\u0001\u0006\u0019\n3uiU\u0001\u0007\u0019\n3ui\u0015\u0011\u0002!M,\b\u000f]8si\u0016$7k\u001c7wKJ\u001cXCAB\u0004!\u0019\t\u0019Aa\r\u0003p\u0006\t2/\u001e9q_J$X\rZ*pYZ,'o\u001d\u0011\u0002\u0019M\u000bX/\u0019:fI\u0016\u0013(o\u001c:\u0002\u001bM\u000bX/\u0019:fI\u0016\u0013(o\u001c:!\u0003\u0015AUOY3s\u0003\u0019AUOY3sA\u0005y1/\u001e9q_J$X\r\u001a'pgN,7/\u0001\ttkB\u0004xN\u001d;fI2{7o]3tA\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u001111\u0004\t\u0005\u0005c\u001ci\"\u0003\u0003\u0004 \tM(AB(cU\u0016\u001cG\u000f\u000b\u0003\u001bQ\u0006-\u0003\u0006B\ri\u0003\u0017\u0002")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Param<String> solver;
    private Param<String> loss;
    private DoubleParam epsilon;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private BooleanParam fitIntercept;
    private DoubleParam tol;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;

    public static int MAX_FEATURES_FOR_NORMAL_SOLVER() {
        return LinearRegression$.MODULE$.MAX_FEATURES_FOR_NORMAL_SOLVER();
    }

    public static LinearRegression load(String path) {
        return LinearRegression$.MODULE$.load(path);
    }

    public static MLReader<LinearRegression> read() {
        return LinearRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams.getEpsilon$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final String getLoss() {
        return HasLoss.getLoss$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param<String> x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param<String> x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setFitIntercept(boolean value) {
        return (LinearRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setStandardization(boolean value) {
        return (LinearRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setElasticNetParam(double value) {
        return (LinearRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setTol(double value) {
        return (LinearRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setWeightCol(String value) {
        return (LinearRegression)this.set(this.weightCol(), value);
    }

    public LinearRegression setSolver(String value) {
        return (LinearRegression)this.set(this.solver(), value);
    }

    public LinearRegression setAggregationDepth(int value) {
        return (LinearRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setLoss(String value) {
        return (LinearRegression)this.set(this.loss(), value);
    }

    public LinearRegression setEpsilon(double value) {
        return (LinearRegression)this.set(this.epsilon(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxBlockSizeInMB(double value) {
        return (LinearRegression)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LinearRegressionModel train(Dataset<?> dataset) {
        LinearRegressionModel linearRegressionModel;
        Object object = new Object();
        try {
            linearRegressionModel = (LinearRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
                double[] dArray;
                None$ none$;
                double d;
                Tuple2<SummarizerBuffer, SummarizerBuffer> tuple2;
                RDD instances;
                int numFeatures;
                block21: {
                    block22: {
                        instr.logPipelineStage(this);
                        instr.logDataset(dataset);
                        instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.weightCol(), this.predictionCol(), this.solver(), this.tol(), this.elasticNetParam(), this.fitIntercept(), this.maxIter(), this.regParam(), this.standardization(), this.aggregationDepth(), this.loss(), this.epsilon(), this.maxBlockSizeInMB()}));
                        StorageLevel storageLevel = dataset.storageLevel();
                        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                        if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                            instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Input instances will be standardized, blockified to blocks, and then cached during training. Be careful of double caching!");
                        }
                        numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
                        instr.logNumFeatures(numFeatures);
                        instances = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkRegressionLabels(this.$(this.labelCol())), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol())), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                            Some some;
                            Row row = x0$1;
                            if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(3) == 0) {
                                Object l = ((SeqOps)some.get()).apply(0);
                                Object w = ((SeqOps)some.get()).apply(1);
                                Object v = ((SeqOps)some.get()).apply(2);
                                if (l instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)l);
                                    if (w instanceof Double) {
                                        double d2 = BoxesRunTime.unboxToDouble((Object)w);
                                        if (v instanceof Vector) {
                                            Vector vector = (Vector)v;
                                            return new Instance(d, d2, vector);
                                        }
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }, ClassTag$.MODULE$.apply(Instance.class)).setName("training instances");
                        String string = this.$(this.loss());
                        String string2 = LinearRegression$.MODULE$.SquaredError();
                        if (string != null ? !string.equals(string2) : string2 != null) break block21;
                        String string3 = this.$(this.solver());
                        String string4 = LinearRegression$.MODULE$.Auto();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null) && numFeatures <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()) break block22;
                        String string5 = this.$(this.solver());
                        String string6 = LinearRegression$.MODULE$.Normal();
                        if (string5 != null ? !string5.equals(string6) : string6 != null) break block21;
                    }
                    throw new NonLocalReturnControl(object, (Object)this.trainWithNormal(dataset, (RDD<Instance>)instances, (Instrumentation)instr));
                }
                if ((tuple2 = Summarizer$.MODULE$.getRegressionSummarizers((RDD<Instance>)instances, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)new .colon.colon((Object)"mean", (List)new .colon.colon((Object)"std", (List)new .colon.colon((Object)"count", (List)Nil$.MODULE$))))) == null) {
                    throw new MatchError(tuple2);
                }
                SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
                SummarizerBuffer labelSummarizer = (SummarizerBuffer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
                SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple22._1();
                SummarizerBuffer labelSummarizer2 = (SummarizerBuffer)tuple22._2();
                double yMean = labelSummarizer2.mean().apply(0);
                double rawYStd = labelSummarizer2.std().apply(0);
                instr.logNumExamples(labelSummarizer2.count());
                instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.meanOfLabels(), yMean);
                instr.logNamedValue(Instrumentation$loggerTags$.MODULE$.varianceOfLabels(), rawYStd);
                instr.logSumOfWeights(summarizer2.weightSum());
                double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
                if (actualBlockSizeInMB == 0.0) {
                    actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                    Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                    instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
                }
                if (rawYStd == 0.0) {
                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || yMean == 0.0) {
                        throw new NonLocalReturnControl(object, (Object)this.trainWithConstantLabel(dataset, (Instrumentation)instr, numFeatures, yMean));
                    }
                    Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0, (Function0 & Serializable)() -> "The standard deviation of the label is zero. Model cannot be regularized.");
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "The standard deviation of the label is zero. Consider setting fitIntercept=true.");
                }
                double yStd = rawYStd > 0.0 ? rawYStd : package$.MODULE$.abs(yMean);
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = summarizer2.std().toArray();
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Fitting LinearRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                String string = this.$(this.loss());
                String string7 = LinearRegression$.MODULE$.SquaredError();
                String string8 = string;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    d = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) / yStd;
                } else {
                    String string9 = LinearRegression$.MODULE$.Huber();
                    String string10 = string;
                    if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                        d = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
                double effectiveRegParam = d;
                double effectiveL1RegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * effectiveRegParam;
                double effectiveL2RegParam = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * effectiveRegParam;
                JFunction1.mcDI.sp & Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable)j -> {
                    if (j >= 0 && j < numFeatures) {
                        return featuresStd[j];
                    }
                    return 0.0;
                };
                if (effectiveL2RegParam != 0.0) {
                    JFunction1.mcZI.sp & Serializable shouldApply = (JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < numFeatures;
                    none$ = new Some((Object)new L2Regularization(effectiveL2RegParam, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer = this.createOptimizer(effectiveRegParam, effectiveL1RegParam, numFeatures, featuresStd);
                String string11 = this.$(this.loss());
                String string12 = LinearRegression$.MODULE$.SquaredError();
                String string13 = string11;
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    dArray = (double[])Array$.MODULE$.ofDim(numFeatures, (ClassTag)ClassTag$.MODULE$.Double());
                } else {
                    String string14 = LinearRegression$.MODULE$.Huber();
                    String string15 = string11;
                    if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                        int dim = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
                        dArray = (double[])Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double());
                    } else {
                        throw new MatchError((Object)string11);
                    }
                }
                double[] initialSolution = dArray;
                Tuple2<double[], double[]> tuple23 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, yMean, yStd, featuresMean, featuresStd, initialSolution, (Option<L2Regularization>)regularization, optimizer);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                double[] parameters = (double[])tuple23._1();
                double[] objectiveHistory = (double[])tuple23._2();
                Tuple2 tuple24 = new Tuple2((Object)parameters, (Object)objectiveHistory);
                double[] parameters2 = (double[])tuple24._1();
                double[] objectiveHistory2 = (double[])tuple24._2();
                if (parameters2 == null) {
                    MLUtils$.MODULE$.optimizerFailed((Instrumentation)instr, optimizer.getClass());
                }
                LinearRegressionModel model = this.createModel(parameters2, yMean, yStd, featuresMean, featuresStd);
                model.createSummary(dataset, new double[]{0.0}, objectiveHistory2, Array$.MODULE$.emptyDoubleArray());
                return model;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                linearRegressionModel = (LinearRegressionModel)ex.value();
            }
            throw ex;
        }
        return linearRegressionModel;
    }

    private LinearRegressionModel trainWithNormal(Dataset<?> dataset, RDD<Instance> instances, Instrumentation instr) {
        WeightedLeastSquares optimizer = new WeightedLeastSquares(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), true, WeightedLeastSquares$Auto$.MODULE$, BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())));
        WeightedLeastSquaresModel model = optimizer.fit(instances, OptionalInstrumentation$.MODULE$.create(instr), optimizer.fit$default$3());
        LinearRegressionModel lrModel = this.copyValues(new LinearRegressionModel(this.uid(), model.coefficients().compressed(), model.intercept()), this.copyValues$default$2());
        double[] coefficientArray = lrModel.getFitIntercept() ? (double[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.doubleArrayOps(lrModel.coefficients().toArray()), (Object)new double[]{lrModel.intercept()}, (ClassTag)ClassTag$.MODULE$.Double()) : lrModel.coefficients().toArray();
        lrModel.createSummary(dataset, model.diagInvAtWA().toArray(), model.objectiveHistory(), coefficientArray);
        return lrModel;
    }

    private LinearRegressionModel trainWithConstantLabel(Dataset<?> dataset, Instrumentation instr, int numFeatures, double yMean) {
        if (yMean == 0.0) {
            instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Mean and standard deviation of the label are zero, so the coefficients and the intercept will all be zero; as a result, training is not needed.");
        } else {
            instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "The standard deviation of the label is zero, so the coefficients will be zeros and the intercept will be the mean of the label; as a result, training is not needed.");
        }
        Vector coefficients = Vectors$.MODULE$.sparse(numFeatures, (Seq)scala.package$.MODULE$.Seq().empty());
        double intercept = yMean;
        LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), coefficients, intercept), this.copyValues$default$2());
        model.createSummary(dataset, new double[]{0.0}, new double[]{0.0}, Array$.MODULE$.emptyDoubleArray());
        return model;
    }

    private FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> createOptimizer(double effectiveRegParam, double effectiveL1RegParam, int numFeatures, double[] featuresStd) {
        String string = this.$(this.loss());
        String string2 = LinearRegression$.MODULE$.SquaredError();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || effectiveRegParam == 0.0) {
                return new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
            }
            boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
            return new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearRegression.effectiveL1RegFun$1(standardizationParam, effectiveL1RegParam, featuresStd), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
        }
        String string4 = LinearRegression$.MODULE$.Huber();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            int dim = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 2 : numFeatures + 1;
            DenseVector lowerBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable)() -> -1.7976931348623157E308, (ClassTag)ClassTag$.MODULE$.Double()));
            lowerBounds.update$mcD$sp(dim - 1, Double.MIN_VALUE);
            DenseVector upperBounds = DenseVector$.MODULE$.apply(Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.MAX_VALUE, (ClassTag)ClassTag$.MODULE$.Double()));
            return new LBFGSB(lowerBounds, upperBounds, BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7());
        }
        throw new MatchError((Object)string);
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double yMean, double yStd, double[] featuresMean, double[] featuresStd, double[] initialSolution, Option<L2Regularization> regularization, FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer) {
        double[] solution;
        RDDLossFunction rDDLossFunction;
        int numFeatures = featuresStd.length;
        double[] inverseStd = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(featuresStd), (Function1)(JFunction1.mcDD.sp & Serializable)std -> {
            if (std != 0.0) {
                return 1.0 / std;
            }
            return 0.0;
        }, (ClassTag)ClassTag$.MODULE$.Double());
        double[] scaledMean = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> inverseStd[i] * featuresMean[i], (ClassTag)ClassTag$.MODULE$.Double());
        Broadcast bcInverseStd = instances.context().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = instances.context().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD standardized = instances.mapPartitions((Function1 & Serializable)iter -> {
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()), (double[])bcInverseStd.value(), false, true);
            return iter.map((Function1 & Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance != null) {
                    double label = instance.label();
                    double weight = instance.weight();
                    Vector vec = instance.features();
                    return new Instance(label, weight, (Vector)func.apply((Object)vec));
                }
                throw new MatchError((Object)instance);
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)standardized, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(this.uid() + ": training blocks (blockSizeInMB=" + actualBlockSizeInMB + ")");
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            String string = this.$(this.loss());
            String string2 = LinearRegression$.MODULE$.Huber();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, initialSolution, 1, scaledMean, 1);
                initialSolution[numFeatures] = initialSolution[numFeatures] + adapt;
            }
        }
        String string = this.$(this.loss());
        String string3 = LinearRegression$.MODULE$.SquaredError();
        String string4 = string;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$3 -> new LeastSquaresBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), yStd, yMean, (Broadcast<Vector>)x$3);
            rDDLossFunction = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(LeastSquaresBlockAggregator.class));
        } else {
            String string5 = LinearRegression$.MODULE$.Huber();
            String string6 = string;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$4 -> new HuberBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.epsilon())), (Broadcast<Vector>)x$4);
                rDDLossFunction = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(HuberBlockAggregator.class));
            } else {
                throw new MatchError((Object)string);
            }
        }
        RDDLossFunction costFun = rDDLossFunction;
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector((ClassTag)ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialSolution));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcInverseStd.destroy();
        bcScaledMean.destroy();
        double[] dArray = solution = state == null ? null : ((DenseVector)state.x()).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            String string7 = this.$(this.loss());
            String string8 = LinearRegression$.MODULE$.Huber();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null) && solution != null) {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, solution, 1, scaledMean, 1);
                solution[numFeatures] = solution[numFeatures] - adapt;
            }
        }
        return new Tuple2((Object)solution, arrayBuilder.result());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LinearRegressionModel createModel(double[] solution, double yMean, double yStd, double[] featuresMean, double[] featuresStd) {
        double d;
        int numFeatures = featuresStd.length;
        String string = this.$(this.loss());
        String string2 = LinearRegression$.MODULE$.Huber();
        double multiplier = !(string != null ? !string.equals(string2) : string2 != null) ? 1.0 : yStd;
        double[] rawCoefficients = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> {
            if (featuresStd[i] != 0.0) {
                return solution[i] * multiplier / featuresStd[i];
            }
            return 0.0;
        }, (ClassTag)ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            String string3 = this.$(this.loss());
            String string4 = LinearRegression$.MODULE$.SquaredError();
            String string5 = string3;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                d = yMean - BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(rawCoefficients), Vectors$.MODULE$.dense(featuresMean));
            } else {
                String string6 = LinearRegression$.MODULE$.Huber();
                String string7 = string3;
                if (string6 != null ? !string6.equals(string7) : string7 != null) throw new MatchError((Object)string3);
                d = solution[numFeatures];
            }
        } else {
            d = 0.0;
        }
        double intercept = d;
        Vector coefficients = Vectors$.MODULE$.dense(rawCoefficients).compressed();
        String string8 = this.$(this.loss());
        String string9 = LinearRegression$.MODULE$.Huber();
        double scale = !(string8 != null ? !string8.equals(string9) : string9 != null) ? BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.doubleArrayOps(solution))) : 1.0;
        return this.copyValues(new LinearRegressionModel(this.uid(), coefficients, intercept, scale), this.copyValues$default$2());
    }

    @Override
    public LinearRegression copy(ParamMap extra) {
        return (LinearRegression)this.defaultCopy(extra);
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
        long size = this.estimateMatadataSize();
        return size += Vectors$.MODULE$.getDenseSize((long)numFeatures);
    }

    private static final Function1 effectiveL1RegFun$1(boolean standardizationParam$1, double effectiveL1RegParam$1, double[] featuresStd$2) {
        return (JFunction1.mcDI.sp & Serializable)index -> {
            if (standardizationParam$1) {
                return effectiveL1RegParam$1;
            }
            if (featuresStd$2[index] != 0.0) {
                return effectiveL1RegParam$1 / featuresStd$2[index];
            }
            return 0.0;
        };
    }

    public LinearRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        HasLoss.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public LinearRegression() {
        this(Identifiable$.MODULE$.randomUID("linReg"));
    }
}

