/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.visitors;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.sparkproject.jpmml.model.visitors.AttributeInterner;

public abstract class NumberInterner<V extends Number>
extends AttributeInterner<V> {
    private ConcurrentMap<V, V> cache = null;

    protected NumberInterner(Class<? extends V> type, ConcurrentMap<V, V> cache) {
        super(type);
        this.setCache(cache);
    }

    public abstract V canonicalize(V var1);

    @Override
    public V intern(V value) {
        ConcurrentMap<Number, Number> cache = this.getCache();
        if (value == null) {
            return null;
        }
        Number canonicalValue = (Number)cache.get(value);
        if (canonicalValue == null) {
            canonicalValue = this.canonicalize(value);
            cache.putIfAbsent((Number)value, canonicalValue);
        }
        return (V)canonicalValue;
    }

    public ConcurrentMap<V, V> getCache() {
        return this.cache;
    }

    private void setCache(ConcurrentMap<V, V> cache) {
        this.cache = Objects.requireNonNull(cache);
    }
}

