/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.jdbc.util;

public final class JdbcErrorUtils$ {
    public static final JdbcErrorUtils$ MODULE$ = new JdbcErrorUtils$();

    public String stringifyTransactionIsolationLevel(int level) {
        int n = level;
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new IllegalArgumentException("Invalid transaction isolation level: " + level);
    }

    public String stringifyHoldability(int holdability) {
        int n = holdability;
        switch (n) {
            case 1: {
                return "HOLD_CURSORS_OVER_COMMIT";
            }
            case 2: {
                return "CLOSE_CURSORS_AT_COMMIT";
            }
        }
        throw new IllegalArgumentException("Invalid holdability: " + holdability);
    }

    public String stringifyResultSetType(int typ) {
        int n = typ;
        switch (n) {
            case 1003: {
                return "FORWARD_ONLY";
            }
            case 1004: {
                return "SCROLL_INSENSITIVE";
            }
            case 1005: {
                return "SCROLL_SENSITIVE";
            }
        }
        throw new IllegalArgumentException("Invalid ResultSet type: " + typ);
    }

    public String stringifyFetchDirection(int direction) {
        int n = direction;
        switch (n) {
            case 1000: {
                return "FETCH_FORWARD";
            }
            case 1001: {
                return "FETCH_REVERSE";
            }
            case 1002: {
                return "FETCH_UNKNOWN";
            }
        }
        throw new IllegalArgumentException("Invalid fetch direction: " + direction);
    }

    private JdbcErrorUtils$() {
    }
}

