/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.ScalaVersion;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Module
implements Serializable {
    private final String organization;
    private final String name;
    private final Map<String, String> attributes;

    private Module(String string, String string2, Map<String, String> map) {
        this.organization = string;
        this.name = string2;
        this.attributes = new HashMap<String, String>(map);
    }

    public static Module of(String string, String string2) {
        return new Module(string, string2, Collections.emptyMap());
    }

    public static Module of(String string, String string2, Map<String, String> map) {
        return new Module(string, string2, map);
    }

    public static Module parse(String string, ScalaVersion scalaVersion) {
        return ApiHelper.parseModule(string, scalaVersion.getVersion());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Module) {
            Module module = (Module)object;
            return this.organization.equals(module.organization) && this.name.equals(module.name) && this.attributes.equals(module.attributes);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (17 + this.organization.hashCode()) + this.name.hashCode()) + this.attributes.hashCode();
    }

    private String attributesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        String string = this.attributesString();
        String string2 = string.isEmpty() ? "" : ", ";
        return "Module(" + this.organization + ", " + this.name + string2 + string + ")";
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

