/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.shared.common.error.StandardException;

public class DiskHashtable {
    private final long rowConglomerateId;
    private ConglomerateController rowConglomerate;
    private final long btreeConglomerateId;
    private ConglomerateController btreeConglomerate;
    private final DataValueDescriptor[] btreeRow;
    private final int[] key_column_numbers;
    private final boolean remove_duplicates;
    private final TransactionController tc;
    private final DataValueDescriptor[] row;
    private final DataValueDescriptor[] scanKey = new DataValueDescriptor[]{new SQLInteger()};
    private int size;
    private boolean keepStatistics;
    private final boolean keepAfterCommit;

    public DiskHashtable(TransactionController transactionController, DataValueDescriptor[] dataValueDescriptorArray, int[] nArray, int[] nArray2, boolean bl, boolean bl2) throws StandardException {
        int n;
        this.tc = transactionController;
        this.key_column_numbers = nArray2;
        this.remove_duplicates = bl;
        this.keepAfterCommit = bl2;
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)DiskHashtable.getContextOrNull("LanguageConnectionContext");
        this.keepStatistics = languageConnectionContext != null && languageConnectionContext.getRunTimeStatisticsMode();
        this.row = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (n = 0; n < this.row.length; ++n) {
            this.row[n] = dataValueDescriptorArray[n].getNewNull();
        }
        n = bl2 ? 3 : 1;
        this.rowConglomerateId = transactionController.createConglomerate("heap", dataValueDescriptorArray, null, nArray, null, n);
        this.rowConglomerate = transactionController.openConglomerate(this.rowConglomerateId, bl2, 4, 7, 0);
        this.btreeRow = new DataValueDescriptor[]{new SQLInteger(), this.rowConglomerate.newRowLocationTemplate()};
        Properties properties = new Properties();
        properties.put("baseConglomerateId", String.valueOf(this.rowConglomerateId));
        properties.put("rowLocationColumn", "1");
        properties.put("allowDuplicates", "false");
        properties.put("nKeyFields", "2");
        properties.put("nUniqueColumns", "2");
        properties.put("maintainParentLinks", "false");
        int[] nArray3 = new int[]{0, 0};
        this.btreeConglomerateId = transactionController.createConglomerate("BTREE", this.btreeRow, null, nArray3, properties, n);
        this.btreeConglomerate = transactionController.openConglomerate(this.btreeConglomerateId, bl2, 4, 7, 0);
    }

    public void close() throws StandardException {
        this.btreeConglomerate.close();
        this.rowConglomerate.close();
        this.tc.dropConglomerate(this.btreeConglomerateId);
        this.tc.dropConglomerate(this.rowConglomerateId);
    }

    public boolean put(Object object, Object[] objectArray) throws StandardException {
        boolean bl = false;
        if (this.remove_duplicates || this.keepStatistics) {
            boolean bl2 = bl = this.getRemove(object, false, true) != null;
            if (this.remove_duplicates && bl) {
                return false;
            }
        }
        this.rowConglomerate.insertAndFetchLocation((DataValueDescriptor[])objectArray, (RowLocation)this.btreeRow[1]);
        this.btreeRow[0].setValue(object.hashCode());
        this.btreeConglomerate.insert(this.btreeRow);
        if (this.keepStatistics && !bl) {
            ++this.size;
        }
        return true;
    }

    public Object get(Object object) throws StandardException {
        return this.getRemove(object, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRemove(Object object, boolean bl, boolean bl2) throws StandardException {
        int n = object.hashCode();
        int n2 = 0;
        DataValueDescriptor[] dataValueDescriptorArray = null;
        ArrayList<DataValueDescriptor[]> arrayList = null;
        this.scanKey[0].setValue(n);
        try (ScanController scanController = this.tc.openScan(this.btreeConglomerateId, false, bl ? 4 : 0, 7, 1, null, this.scanKey, 1, null, this.scanKey, -1);){
            while (scanController.fetchNext(this.btreeRow)) {
                DataValueDescriptor[] dataValueDescriptorArray2;
                if (!this.rowConglomerate.fetch((RowLocation)this.btreeRow[1], this.row, null) || !this.rowMatches(this.row, object)) continue;
                if (bl2) {
                    dataValueDescriptorArray2 = this;
                    return dataValueDescriptorArray2;
                }
                dataValueDescriptorArray2 = BackingStoreHashtable.shallowCloneRow(this.row);
                if (++n2 == 1) {
                    dataValueDescriptorArray = dataValueDescriptorArray2;
                } else {
                    if (arrayList == null) {
                        arrayList = new ArrayList<DataValueDescriptor[]>(2);
                        arrayList.add(dataValueDescriptorArray);
                    }
                    arrayList.add(dataValueDescriptorArray2);
                }
                if (bl) {
                    this.rowConglomerate.delete((RowLocation)this.btreeRow[1]);
                    scanController.delete();
                    --this.size;
                }
                if (!this.remove_duplicates) continue;
                DataValueDescriptor[] dataValueDescriptorArray3 = dataValueDescriptorArray2;
                return dataValueDescriptorArray3;
            }
        }
        if (arrayList == null) {
            return dataValueDescriptorArray;
        }
        return arrayList;
    }

    private boolean rowMatches(DataValueDescriptor[] dataValueDescriptorArray, Object object) {
        if (this.key_column_numbers.length == 1) {
            return dataValueDescriptorArray[this.key_column_numbers[0]].equals(object);
        }
        KeyHasher keyHasher = (KeyHasher)object;
        for (int i = 0; i < this.key_column_numbers.length; ++i) {
            if (dataValueDescriptorArray[this.key_column_numbers[i]].equals(keyHasher.getObject(i))) continue;
            return false;
        }
        return true;
    }

    public Object remove(Object object) throws StandardException {
        return this.getRemove(object, true, false);
    }

    public int size() {
        return this.size;
    }

    public Enumeration<Object> elements() throws StandardException {
        return new ElementEnum();
    }

    private static Context getContextOrNull(String string) {
        return ContextService.getContextOrNull(string);
    }

    private class ElementEnum
    implements Enumeration<Object> {
        private ScanController scan;
        private boolean hasMore;
        private RowLocation rowloc;

        ElementEnum() {
            block7: {
                try {
                    this.scan = DiskHashtable.this.tc.openScan(DiskHashtable.this.rowConglomerateId, DiskHashtable.this.keepAfterCommit, 0, 7, 0, null, null, 0, null, null, 0);
                    this.hasMore = this.scan.next();
                    if (!this.hasMore) {
                        this.scan.close();
                        this.scan = null;
                    } else if (DiskHashtable.this.keepAfterCommit) {
                        this.rowloc = DiskHashtable.this.rowConglomerate.newRowLocationTemplate();
                        this.scan.fetchLocation(this.rowloc);
                    }
                }
                catch (StandardException standardException) {
                    this.hasMore = false;
                    if (this.scan == null) break block7;
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException2) {
                        // empty catch block
                    }
                    this.scan = null;
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore;
        }

        @Override
        public Object nextElement() {
            if (!this.hasMore) {
                throw new NoSuchElementException();
            }
            try {
                if (this.scan.isHeldAfterCommit() && !this.scan.positionAtRowLocation(this.rowloc)) {
                    throw StandardException.newException((String)"24000", (Object[])new Object[0]);
                }
                this.scan.fetch(DiskHashtable.this.row);
                DataValueDescriptor[] dataValueDescriptorArray = BackingStoreHashtable.shallowCloneRow(DiskHashtable.this.row);
                this.hasMore = this.scan.next();
                if (!this.hasMore) {
                    this.scan.close();
                    this.scan = null;
                } else if (DiskHashtable.this.keepAfterCommit) {
                    this.scan.fetchLocation(this.rowloc);
                }
                return dataValueDescriptorArray;
            }
            catch (StandardException standardException) {
                if (this.scan != null) {
                    try {
                        this.scan.close();
                    }
                    catch (StandardException standardException2) {
                        // empty catch block
                    }
                    this.scan = null;
                }
                throw new NoSuchElementException();
            }
        }
    }
}

