/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    char lockGranularity;
    private boolean updateStatistics = false;
    private boolean updateStatisticsAll = false;
    private boolean dropStatistics;
    private boolean dropStatisticsAll;
    private String indexNameForStatistics;
    public boolean compressTable = false;
    public boolean sequential = false;
    public boolean purge = false;
    public boolean defragment = false;
    public boolean truncateEndOfTable = false;
    public int behavior;
    public TableDescriptor baseTable;
    protected int numConstraints;
    private int changeType = 0;
    private boolean truncateTable = false;
    protected SchemaDescriptor schemaDescriptor = null;
    protected ColumnInfo[] colInfos = null;
    protected ConstraintConstantAction[] conActions = null;

    AlterTableNode(TableName tableName, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.truncateTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, boolean bl, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.sequential = bl;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, boolean bl, boolean bl2, boolean bl3, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.purge = bl;
        this.defragment = bl2;
        this.truncateEndOfTable = bl3;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor(true, false);
    }

    AlterTableNode(TableName tableName, int n, boolean bl, String string, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.changeType = n;
        this.indexNameForStatistics = string;
        switch (n) {
            case 5: {
                this.updateStatisticsAll = bl;
                this.updateStatistics = true;
                break;
            }
            case 6: {
                this.dropStatisticsAll = bl;
                this.dropStatistics = true;
                break;
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, int n, TableElementList tableElementList, char c, int n2, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.changeType = n;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.tableElementList = tableElementList;
                this.lockGranularity = c;
                this.behavior = n2;
                break;
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public int getChangeType() {
        return this.changeType;
    }

    @Override
    public void bindStatement() throws StandardException {
        Object object;
        DataDictionary dataDictionary = this.getDataDictionary();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.baseTable = this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable) ? this.getTableDescriptor(false) : this.getTableDescriptor();
        if (this.baseTable.getTableType() == 3) {
            throw StandardException.newException((String)"42995", (Object[])new Object[0]);
        }
        this.getCompilerContext().createDependency(this.baseTable);
        if (this.changeType == 1 && this.tableElementList != null) {
            for (int i = 0; i < this.tableElementList.size(); ++i) {
                if (!(this.tableElementList.elementAt(i) instanceof ColumnDefinitionNode) || ((ColumnDefinitionNode)(object = (ColumnDefinitionNode)this.tableElementList.elementAt(i))).hasGenerationClause() && ((ColumnDefinitionNode)object).getType() == null) continue;
                if (((ColumnDefinitionNode)object).getType() == null) {
                    throw StandardException.newException((String)"42XA9", (Object[])new Object[]{((ColumnDefinitionNode)object).getColumnName()});
                }
                if (!((ColumnDefinitionNode)object).getType().getTypeId().isStringTypeId()) continue;
                ((ColumnDefinitionNode)object).setCollationType(this.schemaDescriptor.getCollationType());
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validate(this, dataDictionary, this.baseTable);
            if (this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns() > 1012) {
                throw StandardException.newException((String)"54011", (Object[])new Object[]{String.valueOf(this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns()), this.getRelativeName(), String.valueOf(1012)});
            }
            n4 = this.tableElementList.countConstraints(2) + this.tableElementList.countConstraints(6) + this.tableElementList.countConstraints(3);
            n = this.tableElementList.countConstraints(4);
            n2 = this.tableElementList.countConstraints(6);
            n3 = this.tableElementList.countGenerationClauses();
        }
        if (n4 + this.baseTable.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException((String)"42Z9F", (Object[])new Object[]{String.valueOf(n4 + this.baseTable.getTotalNumberOfIndexes()), this.getRelativeName(), String.valueOf(Short.MAX_VALUE)});
        }
        if (n > 0 || n3 > 0 || n2 > 0) {
            FromList fromList = this.makeFromList(dataDictionary, this.tableElementList, false);
            object = this.baseTable.makeColumnMap(this.baseTable.getGeneratedColumns());
            if (n3 > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(this.schemaDescriptor, fromList, (FormatableBitSet)object, this.baseTable);
            }
            if (n > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (n2 > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, (FormatableBitSet)object);
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
        if (this.updateStatistics && !this.updateStatisticsAll || this.dropStatistics && !this.dropStatisticsAll) {
            ConglomerateDescriptor conglomerateDescriptor = null;
            if (this.schemaDescriptor.getUUID() != null) {
                conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.indexNameForStatistics, this.schemaDescriptor, false);
            }
            if (conglomerateDescriptor == null) {
                throw StandardException.newException((String)"42X65", (Object[])new Object[]{this.schemaDescriptor.getSchemaName() + "." + this.indexNameForStatistics});
            }
        }
        this.getCompilerContext().createDependency(this.baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return AlterTableNode.isSessionSchema(this.baseTable.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        this.prepConstantAction();
        return this.getGenericConstantActionFactory().getAlterTableConstantAction(this.schemaDescriptor, this.getRelativeName(), this.baseTable.getUUID(), this.baseTable.getHeapConglomerateId(), 0, this.colInfos, this.conActions, this.lockGranularity, this.compressTable, this.behavior, this.sequential, this.truncateTable, this.purge, this.defragment, this.truncateEndOfTable, this.updateStatistics, this.updateStatisticsAll, this.dropStatistics, this.dropStatisticsAll, this.indexNameForStatistics);
    }

    private void prepConstantAction() throws StandardException {
        if (this.tableElementList != null) {
            this.genColumnInfo();
        }
        if (this.numConstraints > 0) {
            this.conActions = new ConstraintConstantAction[this.numConstraints];
            this.tableElementList.genConstraintActions(false, this.conActions, this.getRelativeName(), this.schemaDescriptor, this.getDataDictionary());
            for (int i = 0; i < this.conActions.length; ++i) {
                DataDictionary dataDictionary;
                ConstraintDescriptorList constraintDescriptorList;
                int n;
                ConstraintConstantAction constraintConstantAction = this.conActions[i];
                if (!(constraintConstantAction instanceof CreateConstraintConstantAction) || (n = constraintConstantAction.getConstraintType()) != 2 || (constraintDescriptorList = (dataDictionary = this.getDataDictionary()).getConstraintDescriptors(this.baseTable)).getPrimaryKey() == null) continue;
                throw StandardException.newException((String)"X0Y58.S", (Object[])new Object[]{this.baseTable.getQualifiedName()});
            }
        }
    }

    public void genColumnInfo() throws StandardException {
        this.colInfos = new ColumnInfo[this.tableElementList.countNumberOfColumns()];
        this.numConstraints = this.tableElementList.genColumnInfos(this.colInfos);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableElementList != null) {
            this.tableElementList.accept(visitor);
        }
    }
}

