/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.resolver.AggregateWithLcaResolutionResult;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.LateralColumnAliasResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvedProjectList;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.AggregateHint;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0006\r\u0001mA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)\u0011\b\u0001C\u0001u!9a\b\u0001b\u0001\n\u0013y\u0004BB\"\u0001A\u0003%\u0001\tC\u0004E\u0001\t\u0007I\u0011B#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015q\u0005\u0001\"\u0003P\u0011\u0015Q\u0007\u0001\"\u0003l\u0005=\u0001&o\u001c6fGR\u0014Vm]8mm\u0016\u0014(BA\u0007\u000f\u0003!\u0011Xm]8mm\u0016\u0014(BA\b\u0011\u0003!\tg.\u00197zg&\u001c(BA\t\u0013\u0003!\u0019\u0017\r^1msN$(BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004Ba\t\u0013']5\tA\"\u0003\u0002&\u0019\t\u0001BK]3f\u001d>$WMU3t_24XM\u001d\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nq\u0001\\8hS\u000e\fGN\u0003\u0002,!\u0005)\u0001\u000f\\1og&\u0011Q\u0006\u000b\u0002\b!J|'.Z2u!\t9s&\u0003\u00021Q\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0003Ay\u0007/\u001a:bi>\u0014(+Z:pYZ,'\u000f\u0005\u0002$g%\u0011A\u0007\u0004\u0002\t%\u0016\u001cx\u000e\u001c<fe\u0006\u0011R\r\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s!\t\u0019s'\u0003\u00029\u0019\t\u0011R\t\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s\u0003\u0019a\u0014N\\5u}Q\u00191\bP\u001f\u0011\u0005\r\u0002\u0001\"B\u0019\u0004\u0001\u0004\u0011\u0004\"B\u001b\u0004\u0001\u00041\u0014AB:d_B,7/F\u0001A!\t\u0019\u0013)\u0003\u0002C\u0019\tqa*Y7f'\u000e|\u0007/Z*uC\u000e\\\u0017aB:d_B,7\u000fI\u0001\fY\u000e\f'+Z:pYZ,'/F\u0001G!\t\u0019s)\u0003\u0002I\u0019\tQB*\u0019;fe\u0006d7i\u001c7v[:\fE.[1t%\u0016\u001cx\u000e\u001c<fe\u0006aAnY1SKN|GN^3sA\u00059!/Z:pYZ,GC\u0001\u0018M\u0011\u0015i\u0005\u00021\u0001'\u0003E)hN]3t_24X\r\u001a)s_*,7\r^\u0001\u0019e\u0016$\u0018-\u001b8Pe&<\u0017N\\1m\u0015>LgnT;uaV$H\u0003\u0002\u0018Q%^CQ!U\u0005A\u00029\nA\u0001\u001d7b]\")1+\u0003a\u0001)\u0006\u0019\"/Z:pYZ,G\r\u0015:pU\u0016\u001cG\u000fT5tiB\u00111%V\u0005\u0003-2\u00111CU3t_24X\r\u001a)s_*,7\r\u001e'jgRDQ\u0001W\u0005A\u0002e\u000b\u0011d\u00195jY\u0012\u0014VMZ3sK:\u001cW\rZ!uiJL'-\u001e;fgB!!lX1h\u001b\u0005Y&B\u0001/^\u0003\u0011)H/\u001b7\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0011W-D\u0001d\u0015\t!\u0007#A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u00014d\u0005\u0019)\u0005\u0010\u001d:JIB\u0011!\r[\u0005\u0003S\u000e\u0014\u0011\"\u0011;ue&\u0014W\u000f^3\u0002S\rD\u0017\u000e\u001c3ICNl\u0015n]:j]\u001e\fE\u000f\u001e:jEV$Xm\u001d(pi&s\u0007K]8kK\u000e$H*[:u)\u0011aw.!\u0001\u0011\u0005ui\u0017B\u00018\u001f\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001d\u0006A\u0002E\f1\u0002\u001d:pU\u0016\u001cG\u000fT5tiB\u0019!O_?\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<\u001b\u0003\u0019a$o\\8u}%\tq$\u0003\u0002z=\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003sz\u0001\"A\u0019@\n\u0005}\u001c'a\u0004(b[\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\t\r\u0005\r!\u00021\u0001Z\u0003Q\u0011XMZ3sK:\u001cW\rZ!uiJL'-\u001e;fg\u0002")
public class ProjectResolver
implements TreeNodeResolver<Project, LogicalPlan> {
    private final Resolver operatorResolver;
    private final ExpressionResolver expressionResolver;
    private final NameScopeStack scopes;
    private final LateralColumnAliasResolver lcaResolver;

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(scala.collection.immutable.Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(scala.collection.immutable.Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    private LateralColumnAliasResolver lcaResolver() {
        return this.lcaResolver;
    }

    @Override
    public LogicalPlan resolve(Project unresolvedProject) {
        Tuple2 tuple2;
        this.scopes().pushScope(this.scopes().pushScope$default$1());
        try {
            LogicalPlan resolvedChild = this.operatorResolver.resolve(unresolvedProject.child());
            this.scopes().current().availableAliases().clear();
            HashMap<ExprId, Attribute> childReferencedAttributes = this.expressionResolver.getLastReferencedAttributes();
            ResolvedProjectList resolvedProjectList = this.expressionResolver.resolveProjectList(unresolvedProject.projectList(), unresolvedProject);
            LogicalPlan resolvedChildWithMetadataColumns = this.retainOriginalJoinOutput(resolvedChild, resolvedProjectList, childReferencedAttributes);
            if (resolvedProjectList.hasAggregateExpressions()) {
                Aggregate aggregate = new Aggregate((scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()), resolvedProjectList.expressions(), resolvedChildWithMetadataColumns, (Option<AggregateHint>)None$.MODULE$);
                if (resolvedProjectList.hasLateralColumnAlias()) {
                    AggregateWithLcaResolutionResult aggregateWithLcaResolutionResult = this.lcaResolver().handleLcaInAggregate(aggregate);
                    ResolvedProjectList projectList = new ResolvedProjectList(aggregateWithLcaResolutionResult.outputList(), false, false, aggregateWithLcaResolutionResult.aggregateListAliases(), (Option<Aggregate>)new Some((Object)aggregateWithLcaResolutionResult.baseAggregate()));
                    tuple2 = new Tuple2((Object)aggregateWithLcaResolutionResult.resolvedOperator(), (Object)projectList);
                } else {
                    ExprUtils$.MODULE$.assertValidAggregation(aggregate);
                    scala.collection.immutable.Seq<Alias> x$1 = this.scopes().current().aggregateListAliases();
                    Some x$2 = new Some((Object)aggregate);
                    scala.collection.immutable.Seq<NamedExpression> x$3 = resolvedProjectList.copy$default$1();
                    boolean x$4 = resolvedProjectList.copy$default$2();
                    boolean x$5 = resolvedProjectList.copy$default$3();
                    ResolvedProjectList resolvedAggregateList = resolvedProjectList.copy(x$3, x$4, x$5, x$1, (Option<Aggregate>)x$2);
                    tuple2 = new Tuple2((Object)aggregate, (Object)resolvedAggregateList);
                }
            } else {
                Project projectWithLca = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.LATERAL_COLUMN_ALIAS_IMPLICIT_ENABLED())) ? this.lcaResolver().buildProjectWithResolvedLca(resolvedChildWithMetadataColumns, this.scopes().current(), resolvedProjectList.expressions(), this.scopes().current().output(), this.lcaResolver().buildProjectWithResolvedLca$default$5(), this.lcaResolver().buildProjectWithResolvedLca$default$6()) : new Project(resolvedProjectList.expressions(), resolvedChildWithMetadataColumns);
                tuple2 = new Tuple2((Object)projectWithLca, (Object)resolvedProjectList);
            }
        }
        finally {
            this.scopes().popScope();
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        LogicalPlan resolvedOperator = (LogicalPlan)tuple22._1();
        ResolvedProjectList resolvedProjectList = (ResolvedProjectList)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)resolvedOperator, (Object)resolvedProjectList);
        LogicalPlan resolvedOperator2 = (LogicalPlan)tuple23._1();
        ResolvedProjectList resolvedProjectList2 = (ResolvedProjectList)tuple23._2();
        scala.collection.immutable.Seq x$6 = (scala.collection.immutable.Seq)resolvedProjectList2.expressions().map((Function1 & Serializable)namedExpression -> namedExpression.toAttribute());
        scala.collection.immutable.Seq<Alias> x$7 = resolvedProjectList2.aggregateListAliases();
        Option<Aggregate> x$8 = resolvedProjectList2.baseAggregate();
        Option<HashSet<ExprId>> x$9 = this.scopes().overwriteOutputAndExtendHiddenOutput$default$2();
        this.scopes().overwriteOutputAndExtendHiddenOutput((scala.collection.immutable.Seq<Attribute>)x$6, x$9, x$7, x$8);
        return resolvedOperator2;
    }

    private LogicalPlan retainOriginalJoinOutput(LogicalPlan plan2, ResolvedProjectList resolvedProjectList, HashMap<ExprId, Attribute> childReferencedAttributes) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            if (this.childHasMissingAttributesNotInProjectList(resolvedProjectList.expressions(), childReferencedAttributes)) {
                return new Project(this.scopes().current().output(), join);
            }
        }
        return logicalPlan;
    }

    private boolean childHasMissingAttributesNotInProjectList(scala.collection.immutable.Seq<NamedExpression> projectList, HashMap<ExprId, Attribute> referencedAttributes) {
        HashSet expressionIdsFromProjectList = new HashSet(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)projectList.map((Function1 & Serializable)x$2 -> x$2.exprId())).asJava());
        HashMap<ExprId, Attribute> missingAttributes = new HashMap<ExprId, Attribute>();
        CollectionConverters$.MODULE$.MapHasAsScala(referencedAttributes).asScala().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ExprId exprId = (ExprId)tuple2._1();
                Attribute attribute = (Attribute)tuple2._2();
                if (!expressionIdsFromProjectList.contains(exprId) && org.apache.spark.sql.catalyst.util.package$.MODULE$.MetadataColumnHelper(attribute).isMetadataCol()) {
                    return missingAttributes.put(exprId, attribute);
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        scala.collection.immutable.Seq<Attribute> missingAttributeResolvedByHiddenOutput = this.scopes().current().resolveMissingAttributesByHiddenOutput(missingAttributes);
        return missingAttributeResolvedByHiddenOutput.nonEmpty();
    }

    public ProjectResolver(Resolver operatorResolver, ExpressionResolver expressionResolver) {
        this.operatorResolver = operatorResolver;
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.scopes = operatorResolver.getNameScopes();
        this.lcaResolver = expressionResolver.getLcaResolver();
    }
}

