/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeExpression;
import org.apache.spark.sql.catalyst.expressions.TimeTrunc$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimeType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(unit, time) - Returns `time` truncated to the `unit`.\n  ", arguments="\n    Arguments:\n      * unit - the unit to truncate to\n          - \"HOUR\" - zero out the minutes and seconds with fraction part\n          - \"MINUTE\" - zero out the seconds with fraction part\n          - \"SECOND\" - zero out the fraction part of seconds\n          - \"MILLISECOND\" - zero out the microseconds\n          - \"MICROSECOND\" - zero out the nanoseconds\n      * time - a TIME expression\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('HOUR', TIME'09:32:05.359');\n       09:00:00\n      > SELECT _FUNC_('MILLISECOND', TIME'09:32:05.123456');\n       09:32:05.123\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u0010 \u00012B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011N\u0011\u0015Q\u0006\u0001\"\u0011N\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015)\b\u0001\"\u0015w\u0011\u0015Y\b\u0001\"\u0011N\u0011\u001da\b!!A\u0005\u0002uD\u0011\"!\u0001\u0001#\u0003%\t!a\u0001\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005\r\u0001\"CA\u000e\u0001\u0005\u0005I\u0011IA\u000f\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013q\t\u0005\n\u0003+\u0002\u0011\u0011!C\u0001\u0003/B\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\t\u0013\u0005\u001d\u0004!!A\u0005B\u0005%t!CAJ?\u0005\u0005\t\u0012AAK\r!qr$!A\t\u0002\u0005]\u0005B\u0002+\u0019\t\u0003\ty\u000bC\u0005\u00022b\t\t\u0011\"\u0012\u00024\"I\u0011Q\u0017\r\u0002\u0002\u0013\u0005\u0015q\u0017\u0005\n\u0003{C\u0012\u0011!CA\u0003\u007fC\u0011\"!5\u0019\u0003\u0003%I!a5\u0003\u0013QKW.\u001a+sk:\u001c'B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001i\u0013\u0007N\u001c;\u0001B\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\f\u001a\n\u0005Mz\"A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"AL\u001b\n\u0005Yz\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u00059B\u0014BA\u001d \u00059!\u0016.\\3FqB\u0014Xm]:j_:\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u0013:\u0011!i\u0012\b\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b.\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005!c\u0014a\u00029bG.\fw-Z\u0005\u0003\u0015.\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0013\u001f\u0002\tUt\u0017\u000e^\u000b\u0002\u001dB\u0011afT\u0005\u0003!~\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015)h.\u001b;!\u0003\u0011!\u0018.\\3\u0002\u000bQLW.\u001a\u0011\u0002\rqJg.\u001b;?)\r1v\u000b\u0017\t\u0003]\u0001AQ\u0001T\u0003A\u00029CQAU\u0003A\u00029\u000bA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003u\u00032!\u00110a\u0013\ty6JA\u0002TKF\u0004\"!\u00193\u000e\u0003\tT!aY\u0012\u0002\u000bQL\b/Z:\n\u0005\u0015\u0014'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u00015\u0011\u0005\u0005L\u0017B\u00016c\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\tQ\u000e\u0005\u0002oe:\u0011q\u000e\u001d\t\u0003\u0007rJ!!\u001d\u001f\u0002\rA\u0013X\rZ3g\u0013\t\u0019HO\u0001\u0004TiJLgn\u001a\u0006\u0003cr\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007Y;\u0018\u0010C\u0003y\u0017\u0001\u0007a*A\u0004oK^,f.\u001b;\t\u000bi\\\u0001\u0019\u0001(\u0002\u000f9,w\u000fV5nK\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\u0007Ysx\u0010C\u0004M\u001bA\u0005\t\u0019\u0001(\t\u000fIk\u0001\u0013!a\u0001\u001d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0003U\rq\u0015qA\u0016\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0003\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0018\u00055!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001\u00027b]\u001eT!!!\u000b\u0002\t)\fg/Y\u0005\u0004g\u0006\r\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0019!\rY\u00141G\u0005\u0004\u0003ka$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001e\u0003\u0003\u00022aOA\u001f\u0013\r\ty\u0004\u0010\u0002\u0004\u0003:L\b\"CA\"%\u0005\u0005\t\u0019AA\u0019\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\n\t\u0007\u0003\u0017\n\t&a\u000f\u000e\u0005\u00055#bAA(y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0013Q\n\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002Z\u0005}\u0003cA\u001e\u0002\\%\u0019\u0011Q\f\u001f\u0003\u000f\t{w\u000e\\3b]\"I\u00111\t\u000b\u0002\u0002\u0003\u0007\u00111H\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002 \u0005\u0015\u0004\"CA\"+\u0005\u0005\t\u0019AA\u0019\u0003\u0019)\u0017/^1mgR!\u0011\u0011LA6\u0011%\t\u0019EFA\u0001\u0002\u0004\tY\u0004K\f\u0001\u0003_\n)(a\u001e\u0002|\u0005u\u0014\u0011QAB\u0003\u000f\u000bI)!$\u0002\u0010B\u0019a&!\u001d\n\u0007\u0005MtDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0014\u0001\u0012\u0006!A\u0001\u0002sLR+O\u0007~CSO\\5uY\u0001\"\u0018.\\3*A5\u0002#+\u001a;ve:\u001c\b\u0005\u0019;j[\u0016\u0004\u0007\u0005\u001e:v]\u000e\fG/\u001a3!i>\u0004C\u000f[3!AVt\u0017\u000e\u001e1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ty(AB\u000b\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002SO\\5uA5\u0002C\u000f[3!k:LG\u000f\t;pAQ\u0014XO\\2bi\u0016\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t%P+J\u0013\u0003%\f\u0011{KJ|\u0007e\\;uAQDW\rI7j]V$Xm\u001d\u0011b]\u0012\u00043/Z2p]\u0012\u001c\be^5uQ\u00022'/Y2uS>t\u0007\u0005]1si*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5Ke*\u0016+FE\u0001j\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u00043/Z2p]\u0012\u001c\be^5uQ\u00022'/Y2uS>t\u0007\u0005]1si*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!EM+5i\u0014(EE\u0001j\u0003E_3s_\u0002zW\u000f\u001e\u0011uQ\u0016\u0004cM]1di&|g\u000e\t9beR\u0004sN\u001a\u0011tK\u000e|g\u000eZ:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u00132c\u0015jU#D\u001f:#%\u0005I\u0017!u\u0016\u0014x\u000eI8vi\u0002\"\b.\u001a\u0011nS\u000e\u0014xn]3d_:$7O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%D%>\u001bViQ(O\t\n\u0002S\u0006\t>fe>\u0004s.\u001e;!i\",\u0007E\\1o_N,7m\u001c8eg*\u0001\u0003\u0005\t\u0011!A)\u0002C/[7fA5\u0002\u0013\r\t+J\u001b\u0016\u0003S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u000b\u000b\u00111\n\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!{UKU\u0014-AQKU*R\u00141si\u001a$G\u000f\u00196]M*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAJ$\b\r\u0019;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ'J\u00192K5+R\"P\u001d\u0012;C\u0006\t+J\u001b\u0016;\u0003'\u000f\u001e4ei\u0002TGL\u00193gQ*dgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAJ$h\r\u001a;aUr\u0013GM\u001a\u000bA\u0001\nQa\u001a:pkB\f#!a#\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011S\u0001\u0006i9\nd\u0006M\u0001\n)&lW\r\u0016:v]\u000e\u0004\"A\f\r\u0014\u000ba\tI*!*\u0011\u000f\u0005m\u0015\u0011\u0015(O-6\u0011\u0011Q\u0014\u0006\u0004\u0003?c\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003G\u000biJA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000b9#\u0001\u0002j_&\u0019!*!+\u0015\u0005\u0005U\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0011!B1qa2LH#\u0002,\u0002:\u0006m\u0006\"\u0002'\u001c\u0001\u0004q\u0005\"\u0002*\u001c\u0001\u0004q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0003\fi\rE\u0003<\u0003\u0007\f9-C\u0002\u0002Fr\u0012aa\u00149uS>t\u0007#B\u001e\u0002J:s\u0015bAAfy\t1A+\u001e9mKJB\u0001\"a4\u001d\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAk!\u0011\t\t#a6\n\t\u0005e\u00171\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class TimeTrunc
extends BinaryExpression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeExpression,
Serializable {
    private final Expression unit;
    private final Expression time;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TimeTrunc x$0) {
        return TimeTrunc$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, TimeTrunc> tupled() {
        return TimeTrunc$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TimeTrunc>> curried() {
        return TimeTrunc$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$TimeExpression$$super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TimeExpression.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        TimeTrunc timeTrunc = this;
        synchronized (timeTrunc) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression unit() {
        return this.unit;
    }

    public Expression time() {
        return this.time;
    }

    @Override
    public Expression left() {
        return this.unit();
    }

    @Override
    public Expression right() {
        return this.time();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)AnyTimeType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return this.time().dataType();
    }

    @Override
    public String prettyName() {
        return "time_trunc";
    }

    @Override
    public TimeTrunc withNewChildrenInternal(Expression newUnit, Expression newTime) {
        return this.copy(newUnit, newTime);
    }

    @Override
    public Expression replacement() {
        return new StaticInvoke(DateTimeUtils$.class, this.dataType(), "timeTrunc", (Seq<Expression>)new .colon.colon((Object)this.unit(), (List)new .colon.colon((Object)this.time(), (List)Nil$.MODULE$)), (Seq<AbstractDataType>)new .colon.colon((Object)this.unit().dataType(), (List)new .colon.colon((Object)this.time().dataType(), (List)Nil$.MODULE$)), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
    }

    public TimeTrunc copy(Expression unit, Expression time) {
        return new TimeTrunc(unit, time);
    }

    public Expression copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.time();
    }

    @Override
    public String productPrefix() {
        return "TimeTrunc";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.time();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeTrunc;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "time";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeTrunc)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeTrunc timeTrunc = (TimeTrunc)x$1;
        Expression expression = this.unit();
        Expression expression2 = timeTrunc.unit();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.time();
        Expression expression4 = timeTrunc.time();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!timeTrunc.canEqual(this)) return false;
        return true;
    }

    public TimeTrunc(Expression unit, Expression time) {
        this.unit = unit;
        this.time = time;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeExpression.$init$(this);
        Statics.releaseFence();
    }
}

