/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.Uniform$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.UpCastRule$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(min, max[, seed]) - Returns a random value with independent and identically\n      distributed (i.i.d.) values with the specified range of numbers. The random seed is optional.\n      The provided numbers specifying the minimum and maximum values of the range must be constant.\n      If both of these numbers are integers, then the result will also be an integer. Otherwise if\n      one or both of these are floating-point numbers, then the result will also be a floating-point\n      number.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(10, 20, 0) > 0 AS result;\n      true\n  ", since="4.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015e\u0001\u0002\u00180\u0001rB\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tI\u0002\u0011\t\u0012)A\u0005{!AQ\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005g\u0001\tE\t\u0015!\u0003>\u0011!9\u0007A!f\u0001\n\u0003\u0019\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B\u001f\t\u0011%\u0004!Q3A\u0005\u0002)D\u0001B\u001c\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006_\u0002!\tA\u001e\u0005\u0006_\u0002!\t!\u001f\u0005\t{\u0002A)\u0019!C#U\"9a\u0010\u0001b\u0001\n\u0003z\b\u0002CA\u0017\u0001\u0001\u0006I!!\u0001\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003B\u0002\u001b\u0001\t\u0003\nY\u0005C\u0004\u0002^\u0001!\t%a\u0018\t\r\u00055\u0004\u0001\"\u0011d\u0011\u0019\ty\u0007\u0001C!G\"1\u0011\u0011\u000f\u0001\u0005B\rDq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"1\u0011\u0011\u0014\u0001\u0005B\rD\u0011\"a'\u0001\u0003\u0003%\t!!(\t\u0013\u0005\u001d\u0006!%A\u0005\u0002\u0005%\u0006\"CA`\u0001E\u0005I\u0011AAU\u0011%\t\t\rAI\u0001\n\u0003\tI\u000bC\u0005\u0002D\u0002\t\n\u0011\"\u0001\u0002F\"I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00131\u001a\u0005\n\u00037\u0004\u0011\u0011!C\u0001\u0003;D\u0011\"!:\u0001\u0003\u0003%\t!a:\t\u0013\u0005M\b!!A\u0005B\u0005U\b\"\u0003B\u0002\u0001\u0005\u0005I\u0011\u0001B\u0003\u0011%\u0011I\u0001AA\u0001\n\u0003\u0012Y\u0001C\u0005\u0003\u0010\u0001\t\t\u0011\"\u0011\u0003\u0012\u001d9!QG\u0018\t\u0002\t]bA\u0002\u00180\u0011\u0003\u0011I\u0004\u0003\u0004pO\u0011\u0005!1\n\u0005\b\u0005\u001b:C\u0011\u0001B(\u0011\u001d\u0011ie\nC\u0001\u0005+B\u0011B!\u0014(\u0003\u0003%\tI!\u0018\t\u0013\t\u001dt%!A\u0005\u0002\n%\u0004\"\u0003B>O\u0005\u0005I\u0011\u0002B?\u0005\u001d)f.\u001b4pe6T!\u0001M\u0019\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003eM\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003iU\n1a]9m\u0015\t1t'A\u0003ta\u0006\u00148N\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<7\u0001A\n\t\u0001u\nEIS'Q-B\u0011ahP\u0007\u0002_%\u0011\u0001i\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001 C\u0013\t\u0019uF\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007cA#I{5\taI\u0003\u0002Hc\u0005)AO]3fg&\u0011\u0011J\u0012\u0002\f)\u0016\u0014h.\u0019:z\u0019&\\W\r\u0005\u0002?\u0017&\u0011Aj\f\u0002\u0004%\u0012;\u0005C\u0001 O\u0013\tyuFA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002X?:\u0011\u0001,\u0018\b\u00033rk\u0011A\u0017\u0006\u00037n\na\u0001\u0010:p_Rt\u0014\"A*\n\u0005y\u0013\u0016a\u00029bG.\fw-Z\u0005\u0003A\u0006\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0018*\u0002\u00075Lg.F\u0001>\u0003\u0011i\u0017N\u001c\u0011\u0002\u00075\f\u00070\u0001\u0003nCb\u0004\u0013AD:fK\u0012,\u0005\u0010\u001d:fgNLwN\\\u0001\u0010g\u0016,G-\u0012=qe\u0016\u001c8/[8oA\u0005A\u0001.\u001b3f'\u0016,G-F\u0001l!\t\tF.\u0003\u0002n%\n9!i\\8mK\u0006t\u0017!\u00035jI\u0016\u001cV-\u001a3!\u0003\u0019a\u0014N\\5u}Q)\u0011O]:ukB\u0011a\b\u0001\u0005\u0006E&\u0001\r!\u0010\u0005\u0006K&\u0001\r!\u0010\u0005\u0006O&\u0001\r!\u0010\u0005\u0006S&\u0001\ra\u001b\u000b\u0004c^D\b\"\u00022\u000b\u0001\u0004i\u0004\"B3\u000b\u0001\u0004iD\u0003B9{wrDQAY\u0006A\u0002uBQ!Z\u0006A\u0002uBQaZ\u0006A\u0002u\nQ\u0002Z3uKJl\u0017N\\5ti&\u001c\u0017\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cXCAA\u0001!\u00159\u00161AA\u0004\u0013\r\t)!\u0019\u0002\u0004'\u0016\f\b\u0003BA\u0005\u0003OqA!a\u0003\u0002$9!\u0011QBA\u0011\u001d\u0011\ty!a\b\u000f\t\u0005E\u0011Q\u0004\b\u0005\u0003'\tYB\u0004\u0003\u0002\u0016\u0005eabA-\u0002\u0018%\t!(\u0003\u00029s%\u0011agN\u0005\u0003iUJ!AM\u001a\n\u0005\u001d\u000b\u0014bAA\u0013\r\u0006YAK]3f!\u0006$H/\u001a:o\u0013\u0011\tI#a\u000b\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0004\u0003K1\u0015!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0006j]B,H\u000fV=qKN,\"!a\r\u0011\u000b]\u000b\u0019!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f4\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ty$!\u000f\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0015\u0003\u0003BA\u001c\u0003\u000fJA!!\u0013\u0002:\tAA)\u0019;b)f\u0004X-\u0006\u0002\u0002NA!\u0011qJA,\u001d\u0011\t\t&a\u0015\u0011\u0005e\u0013\u0016bAA+%\u00061\u0001K]3eK\u001aLA!!\u0017\u0002\\\t11\u000b\u001e:j]\u001eT1!!\u0016S\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9'M\u0001\tC:\fG._:jg&!\u00111NA3\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-A\u0006xSRDg*Z<TK\u0016$GcA\u001f\u0002x!9\u0011\u0011\u0010\fA\u0002\u0005m\u0014a\u00028foN+W\r\u001a\t\u0004#\u0006u\u0014bAA@%\n!Aj\u001c8h\u0003=9\u0018\u000e\u001e5TQ&4G/\u001a3TK\u0016$GcA\u001f\u0002\u0006\"9\u0011qQ\fA\u0002\u0005m\u0014!B:iS\u001a$\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001di\u0014QRAI\u0003+Ca!a$\u0019\u0001\u0004i\u0014\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005M\u0005\u00041\u0001>\u0003%qWm^*fG>tG\r\u0003\u0004\u0002\u0018b\u0001\r!P\u0001\t]\u0016<H\u000b[5sI\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\u0013E\fy*!)\u0002$\u0006\u0015\u0006b\u00022\u001b!\u0003\u0005\r!\u0010\u0005\bKj\u0001\n\u00111\u0001>\u0011\u001d9'\u0004%AA\u0002uBq!\u001b\u000e\u0011\u0002\u0003\u00071.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-&fA\u001f\u0002..\u0012\u0011q\u0016\t\u0005\u0003c\u000bY,\u0004\u0002\u00024*!\u0011QWA\\\u0003%)hn\u00195fG.,GMC\u0002\u0002:J\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti,a-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAAdU\rY\u0017QV\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\u0005Y\u0006twM\u0003\u0002\u0002X\u0006!!.\u0019<b\u0013\u0011\tI&!5\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005}\u0007cA)\u0002b&\u0019\u00111\u001d*\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0018q\u001e\t\u0004#\u0006-\u0018bAAw%\n\u0019\u0011I\\=\t\u0013\u0005E\u0018%!AA\u0002\u0005}\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002xB1\u0011\u0011`A\u0000\u0003Sl!!a?\u000b\u0007\u0005u(+\u0001\u0006d_2dWm\u0019;j_:LAA!\u0001\u0002|\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rY'q\u0001\u0005\n\u0003c\u001c\u0013\u0011!a\u0001\u0003S\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011Q\u001aB\u0007\u0011%\t\t\u0010JA\u0001\u0002\u0004\ty.\u0001\u0004fcV\fGn\u001d\u000b\u0004W\nM\u0001\"CAyK\u0005\u0005\t\u0019AAuQM\u0001!q\u0003B\u000f\u0005?\u0011\u0019C!\n\u0003*\t-\"q\u0006B\u0019!\rq$\u0011D\u0005\u0004\u00057y#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005C\t1\u0011\u001f\u0006!A\u0001\u0002sLR+O\u0007~CS.\u001b8-A5\f\u0007p\u0017\u0017!g\u0016,G-X\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:b]\u0012|W\u000e\t<bYV,\u0007e^5uQ\u0002Jg\u000eZ3qK:$WM\u001c;!C:$\u0007%\u001b3f]RL7-\u00197ms*\u0001\u0003\u0005\t\u0011!A\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011)S:Jg\u0006\u001a\u0018*AY\fG.^3tA]LG\u000f\u001b\u0011uQ\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011sC:<W\rI8gA9,XNY3sg:\u0002C\u000b[3!e\u0006tGm\\7!g\u0016,G\rI5tA=\u0004H/[8oC2t#\u0002\t\u0011!A\u0001\u0002C\u000b[3!aJ|g/\u001b3fI\u0002rW/\u001c2feN\u00043\u000f]3dS\u001aL\u0018N\\4!i\",\u0007%\\5oS6,X\u000eI1oI\u0002j\u0017\r_5nk6\u0004c/\u00197vKN\u0004sN\u001a\u0011uQ\u0016\u0004#/\u00198hK\u0002jWo\u001d;!E\u0016\u00043m\u001c8ti\u0006tGO\f\u0006!A\u0001\u0002\u0003\u0005I%gA\t|G\u000f\u001b\u0011pM\u0002\"\b.Z:fA9,XNY3sg\u0002\n'/\u001a\u0011j]R,w-\u001a:tY\u0001\"\b.\u001a8!i\",\u0007E]3tk2$\be^5mY\u0002\nGn]8!E\u0016\u0004\u0013M\u001c\u0011j]R,w-\u001a:/A=#\b.\u001a:xSN,\u0007%\u001b4\u000bA\u0001\u0002\u0003\u0005\t\u0011p]\u0016\u0004sN\u001d\u0011c_RD\u0007e\u001c4!i\",7/\u001a\u0011be\u0016\u0004c\r\\8bi&tw-\f9pS:$\bE\\;nE\u0016\u00148\u000f\f\u0011uQ\u0016t\u0007\u0005\u001e5fAI,7/\u001e7uA]LG\u000e\u001c\u0011bYN|\u0007EY3!C\u00022Gn\\1uS:<W\u0006]8j]RT\u0001\u0005\t\u0011!A\u0001rW/\u001c2fe:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qE\u0001M\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0004\u0007\f\u00113a1\u0002\u0003'\u000b\u0011?AA\u0002\u0013i\u0015\u0011sKN,H\u000e^\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t5\u0012!\u0002\u001b/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\u001a\u0003)i\u0017\r\u001e5`MVt7m]\u0001\b+:Lgm\u001c:n!\tqteE\u0003(\u0005w\u0011\t\u0005E\u0002R\u0005{I1Aa\u0010S\u0005\u0019\te.\u001f*fMB!!1\tB%\u001b\t\u0011)E\u0003\u0003\u0003H\u0005U\u0017AA5p\u0013\r\u0001'Q\t\u000b\u0003\u0005o\tQ!\u00199qYf$R!\u001dB)\u0005'BQAY\u0015A\u0002uBQ!Z\u0015A\u0002u\"r!\u001dB,\u00053\u0012Y\u0006C\u0003cU\u0001\u0007Q\bC\u0003fU\u0001\u0007Q\bC\u0003hU\u0001\u0007Q\bF\u0005r\u0005?\u0012\tGa\u0019\u0003f!)!m\u000ba\u0001{!)Qm\u000ba\u0001{!)qm\u000ba\u0001{!)\u0011n\u000ba\u0001W\u00069QO\\1qa2LH\u0003\u0002B6\u0005o\u0002R!\u0015B7\u0005cJ1Aa\u001cS\u0005\u0019y\u0005\u000f^5p]B9\u0011Ka\u001d>{uZ\u0017b\u0001B;%\n1A+\u001e9mKRB\u0001B!\u001f-\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B@!\u0011\tyM!!\n\t\t\r\u0015\u0011\u001b\u0002\u0007\u001f\nTWm\u0019;")
public class Uniform
extends Expression
implements RuntimeReplaceable,
TernaryLike<Expression>,
RDG,
ExpectsInputTypes,
Serializable {
    private boolean deterministic;
    private final Expression min;
    private final Expression max;
    private final Expression seedExpression;
    private final boolean hideSeed;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient XORShiftRandom rng;
    private transient long seed;
    private transient Seq<Expression> children;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(Uniform x$0) {
        return Uniform$.MODULE$.unapply(x$0);
    }

    @Override
    public boolean stateful() {
        return RDG.stateful$(this);
    }

    @Override
    public boolean nullable() {
        return RDG.nullable$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public XORShiftRandom rng() {
        return this.rng;
    }

    @Override
    public void rng_$eq(XORShiftRandom x$1) {
        this.rng = x$1;
    }

    private long seed$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.seed = RDG.seed$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.seed;
    }

    @Override
    public long seed() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.seed$lzycompute();
        }
        return this.seed;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    private Seq<Expression> children$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    private Expression canonicalized$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression min() {
        return this.min;
    }

    public Expression max() {
        return this.max;
    }

    @Override
    public Expression seedExpression() {
        return this.seedExpression;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    private boolean deterministic$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.deterministic = false;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection randomSeedTypes = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, LongType$.MODULE$}));
        return new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)randomSeedTypes, (List)Nil$.MODULE$)));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public DataType dataType() {
        block20: {
            block19: {
                var4_1 = new Tuple2((Object)this.min().dataType(), (Object)this.max().dataType());
                if (!this.seedExpression().resolved()) break block19;
                v0 = this.seedExpression().dataType();
                var5_2 = NullType$.MODULE$;
                if (v0 != null ? v0.equals(var5_2) == false : var5_2 != null) break block20;
            }
            return NullType$.MODULE$;
        }
        if (var4_1 != null) {
            left = (DataType)var4_1._1();
            right = (DataType)var4_1._2();
            if (left instanceof IntegralType) {
                var8_5 = (IntegralType)left;
                if (right instanceof IntegralType) {
                    var9_6 = (IntegralType)right;
                    if (UpCastRule$.MODULE$.legalNumericPrecedence((DataType)var8_5, (DataType)var9_6)) {
                        return var9_6;
                    }
                    return var8_5;
                }
            }
        }
        if (var4_1 == null) ** GOTO lbl-1000
        var10_7 = (DataType)var4_1._2();
        if (var4_1._1() instanceof NumericType && DoubleType$.MODULE$.equals(var10_7)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var4_1 != null && DoubleType$.MODULE$.equals(var11_8 = (DataType)var4_1._1()) != false && var4_1._2() instanceof NumericType != false;
        }
        if (v1) {
            return DoubleType$.MODULE$;
        }
        if (var4_1 == null) ** GOTO lbl-1000
        var12_9 = (DataType)var4_1._2();
        if (var4_1._1() instanceof NumericType && FloatType$.MODULE$.equals(var12_9)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var4_1 != null && FloatType$.MODULE$.equals(var13_10 = (DataType)var4_1._1()) != false && var4_1._2() instanceof NumericType != false;
        }
        if (v2) {
            return FloatType$.MODULE$;
        }
        if (var4_1 != null) {
            lhs = (DataType)var4_1._1();
            rhs = (DataType)var4_1._2();
            if (lhs instanceof DecimalType) {
                var16_13 = (DecimalType)lhs;
                if (rhs instanceof DecimalType) {
                    var17_14 = (DecimalType)rhs;
                    if (var16_13.isWiderThan((DataType)var17_14)) {
                        return var16_13;
                    }
                    return var17_14;
                }
            }
        }
        if (var4_1 != null && (d = (DataType)var4_1._2()) instanceof DecimalType) {
            var19_16 = (DecimalType)d;
            return var19_16;
        }
        if (var4_1 != null && (d = (DataType)var4_1._1()) instanceof DecimalType) {
            var21_18 = (DecimalType)d;
            return var21_18;
        }
        throw SparkException$.MODULE$.internalError("Unexpected argument data types: " + this.min().dataType() + ", " + this.max().dataType());
    }

    @Override
    public String sql() {
        return "uniform(" + this.min().sql() + ", " + this.max().sql() + (this.hideSeed() ? "" : ", " + this.seedExpression().sql()) + ")";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ObjectRef result = ObjectRef.create((Object)ExpectsInputTypes.checkInputDataTypes$(this));
        new .colon.colon((Object)new Tuple2((Object)this.min(), (Object)"min"), (List)new .colon.colon((Object)new Tuple2((Object)this.max(), (Object)"max"), (List)new .colon.colon((Object)new Tuple2((Object)this.seedExpression(), (Object)"seed"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$1 -> {
            Uniform.$anonfun$checkInputDataTypes$1(result, x0$1);
            return BoxedUnit.UNIT;
        });
        return (TypeCheckResult)result.elem;
    }

    @Override
    public Expression first() {
        return this.min();
    }

    @Override
    public Expression second() {
        return this.max();
    }

    @Override
    public Expression third() {
        return this.seedExpression();
    }

    @Override
    public Expression withNewSeed(long newSeed) {
        return new Uniform(this.min(), this.max(), new Literal(BoxesRunTime.boxToLong((long)newSeed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Expression withShiftedSeed(long shift) {
        return new Uniform(this.min(), this.max(), new Literal(BoxesRunTime.boxToLong((long)(this.seed() + shift)), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return new Uniform(newFirst, newSecond, newThird, this.hideSeed());
    }

    @Override
    public Expression replacement() {
        if (new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.max(), (List)new .colon.colon((Object)this.seedExpression(), (List)Nil$.MODULE$))).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Uniform.$anonfun$replacement$1(x$2)))) {
            return Literal$.MODULE$.apply(null);
        }
        return Uniform.cast$1(new Add(Uniform.cast$1(this.min(), (DataType)DoubleType$.MODULE$), new Multiply(new Subtract(Uniform.cast$1(this.max(), (DataType)DoubleType$.MODULE$), Uniform.cast$1(this.min(), (DataType)DoubleType$.MODULE$), Subtract$.MODULE$.apply$default$3()), Rand$.MODULE$.apply(this.seed()), Multiply$.MODULE$.apply$default$3()), Add$.MODULE$.apply$default$3()), this.dataType());
    }

    public Uniform copy(Expression min, Expression max, Expression seedExpression, boolean hideSeed) {
        return new Uniform(min, max, seedExpression, hideSeed);
    }

    public Expression copy$default$1() {
        return this.min();
    }

    public Expression copy$default$2() {
        return this.max();
    }

    public Expression copy$default$3() {
        return this.seedExpression();
    }

    public boolean copy$default$4() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Uniform";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.min();
            }
            case 1: {
                return this.max();
            }
            case 2: {
                return this.seedExpression();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uniform;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "min";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "seedExpression";
            }
            case 3: {
                return "hideSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uniform)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uniform uniform = (Uniform)x$1;
        if (this.hideSeed() != uniform.hideSeed()) return false;
        Expression expression = this.min();
        Expression expression2 = uniform.min();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.max();
        Expression expression4 = uniform.max();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.seedExpression();
        Expression expression6 = uniform.seedExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!uniform.canEqual(this)) return false;
        return true;
    }

    private static final String requiredType$1() {
        return "integer or floating-point";
    }

    public static final /* synthetic */ void $anonfun$checkInputDataTypes$1(ObjectRef result$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression expr = (Expression)tuple2._1();
            String name = (String)tuple2._2();
            if (expr != null) {
                Expression expression = expr;
                if (name != null) {
                    String string = name;
                    TypeCheckResult typeCheckResult = (TypeCheckResult)result$1.elem;
                    TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    if (!(typeCheckResult != null ? !typeCheckResult.equals(typeCheckResult$TypeCheckSuccess$) : typeCheckResult$TypeCheckSuccess$ != null) && !expression.foldable()) {
                        result$1.elem = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)ExpectsInputTypes$.MODULE$.toSQLId(string)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Uniform.requiredType$1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)ExpectsInputTypes$.MODULE$.toSQLExpr(expression))}))));
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$replacement$1(Expression x$2) {
        DataType dataType = x$2.dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        return !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null);
    }

    private static final Expression cast$1(Expression e, DataType to) {
        DataType dataType = e.dataType();
        DataType dataType2 = to;
        if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
            return e;
        }
        return new Cast(e, to, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
    }

    public Uniform(Expression min, Expression max, Expression seedExpression, boolean hideSeed) {
        this.min = min;
        this.max = max;
        this.seedExpression = seedExpression;
        this.hideSeed = hideSeed;
        RuntimeReplaceable.$init$(this);
        TernaryLike.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        RDG.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)new .colon.colon((Object)TreePattern$.MODULE$.EXPRESSION_WITH_RANDOM_SEED(), (List)Nil$.MODULE$));
    }

    public Uniform(Expression min, Expression max) {
        this(min, max, UnresolvedSeed$.MODULE$, true);
    }

    public Uniform(Expression min, Expression max, Expression seedExpression) {
        this(min, max, seedExpression, false);
    }
}

