/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.ParentClassLoader;

public class ChildFirstURLClassLoader
extends MutableURLClassLoader {
    private ParentClassLoader parent;

    public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, null);
        this.parent = new ParentClassLoader(parent);
    }

    public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent, ClassLoader grandparent) {
        super(urls, grandparent);
        this.parent = new ParentClassLoader(parent);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException cnf) {
            return this.parent.loadClass(name, resolve);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = Collections.list(super.getResources(name));
        urls.addAll(Collections.list(this.parent.getResources(name)));
        return Collections.enumeration(urls);
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        return this.parent.getResource(name);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

