/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.io.Serializable;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.collection.BitSet;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$;
import org.apache.spark.util.collection.OpenHashSet$Hasher$mcD$sp;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Private
public class OpenHashSet$mcD$sp
extends OpenHashSet<Object> {
    public final OpenHashSet.Hasher<Object> hasher$mcD$sp;
    public double[] _data$mcD$sp;

    @Override
    public OpenHashSet.Hasher<Object> hasher$mcD$sp() {
        return this.hasher$mcD$sp;
    }

    @Override
    public OpenHashSet.Hasher<Object> hasher() {
        return this.hasher$mcD$sp();
    }

    @Override
    public double[] _data$mcD$sp() {
        return this._data$mcD$sp;
    }

    public double[] _data() {
        return this._data$mcD$sp();
    }

    @Override
    public void _data$mcD$sp_$eq(double[] x$1) {
        this._data$mcD$sp = x$1;
    }

    public void _data_$eq(double[] x$1) {
        this._data$mcD$sp_$eq(x$1);
    }

    @Override
    public boolean contains(double k) {
        return this.contains$mcD$sp(k);
    }

    @Override
    public boolean contains$mcD$sp(double k) {
        return this.getPos$mcD$sp(k) != OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public void add(double k) {
        this.add$mcD$sp(k);
    }

    @Override
    public void add$mcD$sp(double k) {
        this.addWithoutResize$mcD$sp(k);
        this.rehashIfNeeded$mcD$sp(k, OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$grow(), OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$move());
    }

    @Override
    public OpenHashSet<Object> union(OpenHashSet<Object> other) {
        return this.union$mcD$sp(other);
    }

    @Override
    public OpenHashSet<Object> union$mcD$sp(OpenHashSet<Object> other) {
        Iterator<Object> iterator = other.iterator();
        while (iterator.hasNext()) {
            this.add$mcD$sp(BoxesRunTime.unboxToDouble((Object)iterator.next()));
        }
        return this;
    }

    @Override
    public boolean keyExistsAtPos(double k, int pos) {
        return this.keyExistsAtPos$mcD$sp(k, pos);
    }

    @Override
    public boolean keyExistsAtPos$mcD$sp(double k, int pos) {
        return ((Object)BoxesRunTime.boxToDouble((double)this._data()[pos])).equals(BoxesRunTime.boxToDouble((double)k));
    }

    @Override
    public int addWithoutResize(double k) {
        return this.addWithoutResize$mcD$sp(k);
    }

    @Override
    public int addWithoutResize$mcD$sp(double k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcD$sp(k)) & this._mask();
        int delta = 1;
        while (true) {
            if (!this._bitset().get(pos)) {
                this._data()[pos] = k;
                this._bitset().set(pos);
                this._size_$eq(this._size() + 1);
                return pos | OpenHashSet$.MODULE$.NONEXISTENCE_MASK();
            }
            if (this.keyExistsAtPos$mcD$sp(k, pos)) {
                return pos;
            }
            pos = pos + delta & this._mask();
            ++delta;
        }
    }

    @Override
    public void rehashIfNeeded(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehashIfNeeded$mcD$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehashIfNeeded$mcD$sp(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        if (this._size() > this._growThreshold()) {
            this.rehash$mcD$sp(k, allocateFunc, moveFunc);
            return;
        }
    }

    @Override
    public int getPos(double k) {
        return this.getPos$mcD$sp(k);
    }

    @Override
    public int getPos$mcD$sp(double k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcD$sp(k)) & this._mask();
        int delta = 1;
        while (this._bitset().get(pos)) {
            if (this.keyExistsAtPos$mcD$sp(k, pos)) {
                return pos;
            }
            pos = pos + delta & this._mask();
            ++delta;
        }
        return OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public double getValue(int pos) {
        return this.getValue$mcD$sp(pos);
    }

    @Override
    public double getValue$mcD$sp(int pos) {
        return this._data()[pos];
    }

    @Override
    public double getValueSafe(int pos) {
        return this.getValueSafe$mcD$sp(pos);
    }

    @Override
    public double getValueSafe$mcD$sp(int pos) {
        Predef$.MODULE$.assert(this._bitset().get(pos));
        return this._data()[pos];
    }

    @Override
    public void rehash(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehash$mcD$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehash$mcD$sp(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        int newCapacity = this._capacity() * 2;
        Predef$.MODULE$.require(newCapacity > 0 && newCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), (Function0 & Serializable)() -> "Can't contain more than " + (int)($this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)OpenHashSet$.MODULE$.MAX_CAPACITY()) + " elements");
        allocateFunc.apply$mcVI$sp(newCapacity);
        BitSet newBitset = new BitSet(newCapacity);
        double[] newData = (double[])this.org$apache$spark$util$collection$OpenHashSet$$evidence$1.newArray(newCapacity);
        int newMask = newCapacity - 1;
        for (int oldPos = 0; oldPos < this.capacity(); ++oldPos) {
            if (!this._bitset().get(oldPos)) continue;
            double key = this._data()[oldPos];
            int newPos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcD$sp(key)) & newMask;
            int i = 1;
            boolean keepGoing = true;
            while (keepGoing) {
                if (!newBitset.get(newPos)) {
                    newData[newPos] = key;
                    newBitset.set(newPos);
                    moveFunc.apply$mcVII$sp(oldPos, newPos);
                    keepGoing = false;
                    continue;
                }
                int delta = i++;
                newPos = newPos + delta & newMask;
            }
        }
        this._bitset_$eq(newBitset);
        this._data_$eq(newData);
        this._capacity_$eq(newCapacity);
        this._mask_$eq(newMask);
        this._growThreshold_$eq((int)(this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)newCapacity));
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public OpenHashSet$mcD$sp(int initialCapacity, double loadFactor, ClassTag<Object> evidence$1) {
        super(initialCapacity, loadFactor, evidence$1);
        OpenHashSet.Hasher hasher;
        Predef$.MODULE$.require(initialCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$1);
        Predef$.MODULE$.require(initialCapacity >= 0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$2);
        Predef$.MODULE$.require(loadFactor < 1.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$3);
        Predef$.MODULE$.require(loadFactor > 0.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$4);
        ClassTag classTag = package$.MODULE$.classTag(evidence$1);
        ManifestFactory.LongManifest longManifest = ClassTag$.MODULE$.Long();
        ClassTag classTag2 = classTag;
        if (!(longManifest != null ? !longManifest.equals(classTag2) : classTag2 != null)) {
            hasher = new OpenHashSet.LongHasher();
        } else {
            ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
            ClassTag classTag3 = classTag;
            if (!(intManifest != null ? !intManifest.equals(classTag3) : classTag3 != null)) {
                hasher = new OpenHashSet.IntHasher();
            } else {
                ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                ClassTag classTag4 = classTag;
                if (!(doubleManifest != null ? !doubleManifest.equals(classTag4) : classTag4 != null)) {
                    hasher = new OpenHashSet.DoubleHasher();
                } else {
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    ClassTag classTag5 = classTag;
                    hasher = !(floatManifest != null ? !floatManifest.equals(classTag5) : classTag5 != null) ? new OpenHashSet.FloatHasher() : new OpenHashSet$Hasher$mcD$sp();
                }
            }
        }
        this.hasher$mcD$sp = hasher;
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity = this.org$apache$spark$util$collection$OpenHashSet$$nextPowerOf2(initialCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask = this._capacity() - 1;
        this.org$apache$spark$util$collection$OpenHashSet$$_size = 0;
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold = (int)(loadFactor * (double)this._capacity());
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset = new BitSet(this._capacity());
        this._data_$eq(evidence$1.newArray(this._capacity()));
    }

    public OpenHashSet$mcD$sp(int initialCapacity, ClassTag<Object> evidence$2) {
        this(initialCapacity, 0.7, evidence$2);
    }

    public OpenHashSet$mcD$sp(ClassTag<Object> evidence$3) {
        this(64, evidence$3);
    }
}

