/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;

public class BufferInputLineSimplifier {
    private static final int DELETE = 1;
    private Coordinate[] inputLine;
    private double distanceTol;
    private boolean isRing;
    private boolean[] isDeleted;
    private int angleOrientation = 1;
    private static final int NUM_PTS_TO_CHECK = 10;

    public static Coordinate[] simplify(Coordinate[] inputLine, double distanceTol) {
        BufferInputLineSimplifier simp = new BufferInputLineSimplifier(inputLine);
        return simp.simplify(distanceTol);
    }

    public BufferInputLineSimplifier(Coordinate[] inputLine) {
        this.inputLine = inputLine;
        this.isRing = CoordinateArrays.isRing(inputLine);
    }

    public Coordinate[] simplify(double distanceTol) {
        this.distanceTol = Math.abs(distanceTol);
        this.angleOrientation = 1;
        if (distanceTol < 0.0) {
            this.angleOrientation = -1;
        }
        this.isDeleted = new boolean[this.inputLine.length];
        boolean isChanged = false;
        while (isChanged = this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }

    private boolean deleteShallowConcavities() {
        int index = this.isRing ? 0 : 1;
        int midIndex = this.nextIndex(index);
        int lastIndex = this.nextIndex(midIndex);
        boolean isChanged = false;
        while (lastIndex < this.inputLine.length) {
            boolean isMiddleVertexDeleted = false;
            if (this.isDeletable(index, midIndex, lastIndex, this.distanceTol)) {
                this.isDeleted[midIndex] = true;
                isMiddleVertexDeleted = true;
                isChanged = true;
            }
            index = isMiddleVertexDeleted ? lastIndex : midIndex;
            midIndex = this.nextIndex(index);
            lastIndex = this.nextIndex(midIndex);
        }
        return isChanged;
    }

    private int nextIndex(int index) {
        int next;
        for (next = index + 1; next < this.inputLine.length && this.isDeleted[next]; ++next) {
        }
        return next;
    }

    private Coordinate[] collapseLine() {
        CoordinateList coordList = new CoordinateList();
        for (int i = 0; i < this.inputLine.length; ++i) {
            if (this.isDeleted[i]) continue;
            coordList.add(this.inputLine[i]);
        }
        return coordList.toCoordinateArray();
    }

    private boolean isDeletable(int i0, int i1, int i2, double distanceTol) {
        Coordinate p0 = this.inputLine[i0];
        Coordinate p1 = this.inputLine[i1];
        Coordinate p2 = this.inputLine[i2];
        if (!this.isConcave(p0, p1, p2)) {
            return false;
        }
        if (!BufferInputLineSimplifier.isShallow(p0, p1, p2, distanceTol)) {
            return false;
        }
        return this.isShallowSampled(p0, p1, i0, i2, distanceTol);
    }

    private boolean isShallowSampled(Coordinate p0, Coordinate p2, int i0, int i2, double distanceTol) {
        int inc = (i2 - i0) / 10;
        if (inc <= 0) {
            inc = 1;
        }
        for (int i = i0; i < i2; i += inc) {
            if (BufferInputLineSimplifier.isShallow(p0, this.inputLine[i], p2, distanceTol)) continue;
            return false;
        }
        return true;
    }

    private static boolean isShallow(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        double dist = Distance.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private boolean isConcave(Coordinate p0, Coordinate p1, Coordinate p2) {
        int orientation = Orientation.index(p0, p1, p2);
        boolean isConcave = orientation == this.angleOrientation;
        return isConcave;
    }
}

