/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.examples.ml.DataFrameExample;
import org.apache.spark.examples.ml.DataFrameExample$Params$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class DataFrameExample$ {
    public static final DataFrameExample$ MODULE$ = new DataFrameExample$();

    public void main(String[] args) {
        DataFrameExample.Params defaultParams = new DataFrameExample.Params(DataFrameExample$Params$.MODULE$.apply$default$1());
        OptionParser<DataFrameExample.Params> parser = new OptionParser<DataFrameExample.Params>(){
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DataFrameExample: an example app using DataFrame for ML."}));
                this.opt("input", Read$.MODULE$.stringRead()).text("input path to dataframe").action((Function2 & Serializable)(x, c) -> c.copy((String)x));
                this.checkConfig((Function1 & Serializable)params -> this.success());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.ml.DataFrameExample$Params ), $anonfun$new$2(org.apache.spark.examples.ml.DataFrameExample$$anon$1 org.apache.spark.examples.ml.DataFrameExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataFrameExample.Params params = (DataFrameExample.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(DataFrameExample.Params params) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("DataFrameExample with " + params).getOrCreate();
        Predef$.MODULE$.println((Object)("Loading LIBSVM file with UDT from " + params.input() + "."));
        Dataset df = spark.read().format("libsvm").load(params.input()).cache();
        Predef$.MODULE$.println((Object)"Schema from LIBSVM:");
        df.printSchema();
        Predef$.MODULE$.println((Object)("Loaded training data as a DataFrame with " + df.count() + " records."));
        Dataset labelSummary = df.describe((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        labelSummary.show();
        RDD features = df.select("features", (scala.collection.immutable.Seq)Nil$.MODULE$).rdd().map((Function1 & Serializable)x0$1 -> {
            Object v;
            Some some;
            Row row = x0$1;
            if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(1) == 0 && (v = ((SeqOps)some.get()).apply(0)) instanceof Vector) {
                Vector vector = (Vector)v;
                return vector;
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Vector.class));
        MultivariateOnlineSummarizer featureSummary = (MultivariateOnlineSummarizer)features.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2 & Serializable)(summary, feat) -> summary.add(Vectors$.MODULE$.fromML(feat)), (Function2 & Serializable)(sum1, sum2) -> sum1.merge(sum2), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        Predef$.MODULE$.println((Object)("Selected features column with average values:\n " + featureSummary.mean().toString()));
        File tmpDir = Utils$.MODULE$.createTempDir();
        String outputDir = new File(tmpDir, "dataframe").toString();
        Predef$.MODULE$.println((Object)("Saving to " + outputDir + " as Parquet file."));
        df.write().parquet(outputDir);
        Predef$.MODULE$.println((Object)("Loading Parquet file with UDT from " + outputDir + "."));
        Dataset newDF = spark.read().parquet(outputDir);
        Predef$.MODULE$.println((Object)"Schema from Parquet:");
        newDF.printSchema();
        spark.stop();
    }

    private DataFrameExample$() {
    }
}

