/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.GBTClassifier;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class GradientBoostedTreeClassifierExample$ {
    public static final GradientBoostedTreeClassifierExample$ MODULE$ = new GradientBoostedTreeClassifierExample$();

    public void main(String[] args) {
        Object object;
        SparkSession spark = SparkSession$.MODULE$.builder().appName("GradientBoostedTreeClassifierExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        StringIndexerModel labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel").fit(data);
        VectorIndexerModel featureIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(4).fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.7, 0.3});
        if (datasetArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)datasetArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)datasetArray);
        }
        Dataset trainingData = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Dataset testData = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)trainingData, (Object)testData);
        Dataset trainingData2 = (Dataset)tuple2._1();
        Dataset testData2 = (Dataset)tuple2._2();
        GBTClassifier gbt = ((GBTClassifier)new GBTClassifier().setLabelCol("indexedLabel").setFeaturesCol("indexedFeatures")).setMaxIter(10).setFeatureSubsetStrategy("auto");
        IndexToString labelConverter = new IndexToString().setInputCol("prediction").setOutputCol("predictedLabel").setLabels(labelIndexer.labelsArray()[0]);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{labelIndexer, featureIndexer, gbt, labelConverter}));
        PipelineModel model = pipeline.fit(trainingData2);
        Dataset predictions = model.transform(testData2);
        predictions.select("predictedLabel", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"})).show(5);
        MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setLabelCol("indexedLabel").setPredictionCol("prediction").setMetricName("accuracy");
        double accuracy = evaluator.evaluate(predictions);
        Predef$.MODULE$.println((Object)("Test Error = " + (1.0 - accuracy)));
        GBTClassificationModel gbtModel = (GBTClassificationModel)model.stages()[2];
        Predef$.MODULE$.println((Object)("Learned classification GBT model:\n " + gbtModel.toDebugString()));
        spark.stop();
    }

    private GradientBoostedTreeClassifierExample$() {
    }
}

