/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public class JavaLogisticRegressionWithLBFGSExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("JavaLogisticRegressionWithLBFGSExample");
        SparkContext sc = new SparkContext(conf);
        String path = "data/mllib/sample_libsvm_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)sc, (String)path).toJavaRDD();
        JavaRDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        JavaRDD training = splits[0].cache();
        JavaRDD test = splits[1];
        LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(10).run(training.rdd());
        JavaPairRDD predictionAndLabels = test.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)model.predict(p.features()), (Object)p.label()));
        MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabels.rdd());
        double accuracy = metrics.accuracy();
        System.out.println("Accuracy = " + accuracy);
        model.save(sc, "target/tmp/javaLogisticRegressionWithLBFGSModel");
        LogisticRegressionModel sameModel = LogisticRegressionModel.load((SparkContext)sc, (String)"target/tmp/javaLogisticRegressionWithLBFGSModel");
        sc.stop();
    }
}

