/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMModel$;
import org.apache.spark.mllib.classification.SVMWithSGD$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;

public final class SVMWithSGDExample$ {
    public static final SVMWithSGDExample$ MODULE$ = new SVMWithSGDExample$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("SVMWithSGDExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0].cache();
        RDD test = splits[1];
        int numIterations = 100;
        SVMModel model = SVMWithSGD$.MODULE$.train(training, numIterations);
        model.clearThreshold();
        RDD scoreAndLabels = test.map((Function1 & Serializable)point -> {
            double score = model.predict(point.features());
            return new Tuple2.mcDD.sp(score, point.label());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
        double auROC = metrics.areaUnderROC();
        Predef$.MODULE$.println((Object)("Area under ROC = " + auROC));
        model.save(sc, "target/tmp/scalaSVMWithSGDModel");
        SVMModel sameModel = SVMModel$.MODULE$.load(sc, "target/tmp/scalaSVMWithSGDModel");
        sc.stop();
    }

    private SVMWithSGDExample$() {
    }
}

