/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.Partition;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class JDBCRelation$
implements Logging,
Serializable {
    public static final JDBCRelation$ MODULE$ = new JDBCRelation$();
    private static final String schemaFetchName;
    private static final String schemaFetchKey;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        schemaFetchName = "Remote JDBC schema fetch time";
        schemaFetchKey = "remoteSchemaFetchTime";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public scala.collection.immutable.Map<String, SQLMetric> $lessinit$greater$default$4() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public String schemaFetchName() {
        return schemaFetchName;
    }

    public String schemaFetchKey() {
        return schemaFetchKey;
    }

    public Partition[] columnPartition(StructType schema, Function2<String, String, Object> resolver, String timeZoneId, JDBCOptions jdbcOptions) {
        long l;
        long upperBound;
        JDBCPartitioningInfo partitioning2;
        Option<String> partitionColumn = jdbcOptions.partitionColumn();
        Option<String> lowerBound = jdbcOptions.lowerBound();
        Option<String> upperBound2 = jdbcOptions.upperBound();
        Option<Object> numPartitions = jdbcOptions.numPartitions();
        if (partitionColumn.isEmpty()) {
            Predef$.MODULE$.assert(lowerBound.isEmpty() && upperBound2.isEmpty(), (Function0 & Serializable)() -> "When 'partitionColumn' is not specified, '" + JDBCOptions$.MODULE$.JDBC_LOWER_BOUND() + "' and '" + JDBCOptions$.MODULE$.JDBC_UPPER_BOUND() + "' are expected to be empty");
            v0 = null;
        } else {
            Predef$.MODULE$.assert(lowerBound.nonEmpty() && upperBound2.nonEmpty() && numPartitions.nonEmpty(), (Function0 & Serializable)() -> "When 'partitionColumn' is specified, '" + JDBCOptions$.MODULE$.JDBC_LOWER_BOUND() + "', '" + JDBCOptions$.MODULE$.JDBC_UPPER_BOUND() + "', and '" + JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS() + "' are also required");
            Tuple2<String, DataType> tuple2 = this.verifyAndGetNormalizedPartitionColumn(schema, (String)partitionColumn.get(), resolver, jdbcOptions);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String column = (String)tuple2._1();
            DataType columnType = (DataType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)column, (Object)columnType);
            String column2 = (String)tuple22._1();
            DataType columnType2 = (DataType)tuple22._2();
            long lowerBoundValue = this.toInternalBoundValue((String)lowerBound.get(), columnType2, timeZoneId);
            long upperBoundValue = this.toInternalBoundValue((String)upperBound2.get(), columnType2, timeZoneId);
            v0 = partitioning2 = new JDBCPartitioningInfo(column2, columnType2, lowerBoundValue, upperBoundValue, BoxesRunTime.unboxToInt((Object)numPartitions.get()));
        }
        if (partitioning2 == null || partitioning2.numPartitions() <= 1 || partitioning2.lowerBound() == partitioning2.upperBound()) {
            return (Partition[])((Object[])new Partition[]{new JDBCPartition(null, 0)});
        }
        long lowerBound2 = partitioning2.lowerBound();
        Predef$.MODULE$.require(lowerBound2 <= (upperBound = partitioning2.upperBound()), (Function0 & Serializable)() -> "Operation not allowed: the lower bound of partitioning column is larger than the upper bound. Lower bound: " + lowerBound2 + "; Upper bound: " + upperBound);
        Function1 & Serializable boundValueToString = (Function1 & Serializable)x$2 -> JDBCRelation$.MODULE$.toBoundValueInWhereClause(BoxesRunTime.unboxToLong((Object)x$2), partitioning2.columnType(), timeZoneId);
        if (upperBound - lowerBound2 >= (long)partitioning2.numPartitions() || upperBound - lowerBound2 < 0L) {
            l = partitioning2.numPartitions();
        } else {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions is reduced because the specified number of "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partitions is less than the difference between upper bound and lower bound. "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Updated number of partitions: ", "; "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.NEW_VALUE, BoxesRunTime.boxToLong((long)(upperBound - lowerBound2)))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Input number of partitions: ", "; "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.OLD_VALUE, BoxesRunTime.boxToInteger((int)partitioning2.numPartitions()))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Lower bound: ", "; "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.LOWER_BOUND, boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)lowerBound2)))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound: ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.UPPER_BOUND, boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)upperBound)))})))));
            l = upperBound - lowerBound2;
        }
        long numPartitions2 = l;
        BigDecimal upperStride = BigDecimal$.MODULE$.long2bigDecimal(upperBound).$div(package$.MODULE$.BigDecimal().apply(numPartitions2)).setScale(18, BigDecimal.RoundingMode$.MODULE$.HALF_EVEN());
        BigDecimal lowerStride = BigDecimal$.MODULE$.long2bigDecimal(lowerBound2).$div(package$.MODULE$.BigDecimal().apply(numPartitions2)).setScale(18, BigDecimal.RoundingMode$.MODULE$.HALF_EVEN());
        BigDecimal preciseStride = upperStride.$minus(lowerStride);
        long stride = preciseStride.toLong();
        BigDecimal lostNumOfStrides = preciseStride.$minus(BigDecimal$.MODULE$.long2bigDecimal(stride)).$times(BigDecimal$.MODULE$.long2bigDecimal(numPartitions2)).$div(BigDecimal$.MODULE$.long2bigDecimal(stride));
        long lowerBoundWithStrideAlignment = lowerBound2 + lostNumOfStrides.$div(BigDecimal$.MODULE$.int2bigDecimal(2)).$times(BigDecimal$.MODULE$.long2bigDecimal(stride)).setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toLong();
        int i = 0;
        String column = partitioning2.column();
        long currentValue = lowerBoundWithStrideAlignment;
        ArrayBuffer ans = new ArrayBuffer();
        while ((long)i < numPartitions2) {
            String uBound;
            String lBoundValue = (String)boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)currentValue));
            String lBound = i != 0 ? column + " >= " + lBoundValue : null;
            String uBoundValue = (String)boundValueToString.apply((Object)BoxesRunTime.boxToLong((long)(currentValue += stride)));
            String string = uBound = (long)i != numPartitions2 - 1L ? column + " < " + uBoundValue : null;
            String whereClause = uBound == null ? lBound : (lBound == null ? uBound + " or " + column + " is null" : lBound + " AND " + uBound);
            ans.$plus$eq((Object)new JDBCPartition(whereClause, i));
            ++i;
        }
        Partition[] partitions = (Partition[])ans.toArray(ClassTag$.MODULE$.apply(Partition.class));
        String clauses = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitions), (Function1 & Serializable)x$3 -> ((JDBCPartition)x$3).whereClause(), ClassTag$.MODULE$.apply(String.class))).mkString(", ");
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Number of partitions: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToLong((long)numPartitions2))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE clauses of these partitions: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CLAUSES, clauses)})))));
        return partitions;
    }

    private Tuple2<String, DataType> verifyAndGetNormalizedPartitionColumn(StructType schema, String columnName, Function2<String, String, Object> resolver, JDBCOptions jdbcOptions) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(jdbcOptions.url());
        StructField column = (StructField)schema.find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)JDBCRelation$.$anonfun$verifyAndGetNormalizedPartitionColumn$1(resolver, columnName, dialect, f))).getOrElse((Function0 & Serializable)() -> {
            int maxNumToStringFields = SQLConf$.MODULE$.get().maxToStringFields();
            throw QueryCompilationErrors$.MODULE$.userDefinedPartitionNotFoundInJDBCRelationError(columnName, schema.simpleString(maxNumToStringFields));
        });
        DataType dataType = column.dataType();
        if (!(dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType)))) {
            throw QueryCompilationErrors$.MODULE$.invalidPartitionColumnTypeError(column);
        }
        return new Tuple2((Object)dialect.quoteIdentifier(column.name()), (Object)column.dataType());
    }

    private long toInternalBoundValue(String value, DataType columnType, String timeZoneId) {
        DataType dataType = columnType;
        if (dataType instanceof NumericType) {
            return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value));
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.unboxToInt((Object)JDBCRelation$.parse$1((Function1 & Serializable)s -> DateTimeUtils$.MODULE$.stringToDate(s), value, columnType));
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.unboxToLong((Object)JDBCRelation$.parse$1((Function1 & Serializable)x$4 -> DateTimeUtils$.MODULE$.stringToTimestamp(x$4, DateTimeUtils$.MODULE$.getZoneId(timeZoneId)), value, columnType));
        }
        throw new MatchError((Object)dataType);
    }

    private String toBoundValueInWhereClause(long value, DataType columnType, String timeZoneId) {
        DataType dataType = columnType;
        if (dataType instanceof NumericType) {
            return Long.toString(value);
        }
        if (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType)) {
            return JDBCRelation$.dateTimeToString$1(columnType, value, timeZoneId);
        }
        throw new MatchError((Object)dataType);
    }

    public StructType getSchema(Function2<String, String, Object> resolver, JDBCOptions jdbcOptions) {
        StructType tableSchema = JDBCRDD$.MODULE$.resolveTable(jdbcOptions);
        Option<String> option = jdbcOptions.customSchema();
        if (option instanceof Some) {
            Some some = (Some)option;
            String customSchema = (String)some.value();
            return JdbcUtils$.MODULE$.getCustomSchema(tableSchema, customSchema, resolver);
        }
        if (None$.MODULE$.equals(option)) {
            return tableSchema;
        }
        throw new MatchError(option);
    }

    public JDBCRelation apply(Partition[] parts, JDBCOptions jdbcOptions, SparkSession sparkSession) {
        SQLMetric remoteSchemaFetchMetric = JdbcUtils$.MODULE$.createSchemaFetchMetric(sparkSession.sparkContext());
        StructType schema = (StructType)SQLMetrics$.MODULE$.withTimingNs(remoteSchemaFetchMetric, (Function0 & Serializable)() -> MODULE$.getSchema((Function2<String, String, Object>)sparkSession.sessionState().conf().resolver(), jdbcOptions));
        return new JDBCRelation(schema, parts, jdbcOptions, (scala.collection.immutable.Map<String, SQLMetric>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.schemaFetchKey()), (Object)remoteSchemaFetchMetric)}))), sparkSession);
    }

    public scala.collection.immutable.Map<String, SQLMetric> apply$default$4() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public JDBCRelation apply(StructType schema, Partition[] parts, JDBCOptions jdbcOptions, scala.collection.immutable.Map<String, SQLMetric> additionalMetrics, SparkSession sparkSession) {
        return new JDBCRelation(schema, parts, jdbcOptions, additionalMetrics, sparkSession);
    }

    public Option<Tuple4<StructType, Partition[], JDBCOptions, scala.collection.immutable.Map<String, SQLMetric>>> unapply(JDBCRelation x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.schema(), (Object)x$0.parts(), (Object)x$0.jdbcOptions(), x$0.additionalMetrics()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCRelation$.class);
    }

    public static final /* synthetic */ boolean $anonfun$verifyAndGetNormalizedPartitionColumn$1(Function2 resolver$1, String columnName$1, JdbcDialect dialect$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)columnName$1)) || BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)dialect$1.quoteIdentifier(f.name()), (Object)columnName$1));
    }

    private static final Object parse$1(Function1 f, String value$1, DataType columnType$1) {
        return ((Option)f.apply((Object)UTF8String.fromString((String)value$1))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Cannot parse the bound value " + value$1 + " as " + columnType$1.catalogString());
        });
    }

    private static final String dateTimeToString$1(DataType columnType$2, long value$2, String timeZoneId$3) {
        String string;
        DataType dataType = columnType$2;
        if (DateType$.MODULE$.equals(dataType)) {
            string = DateFormatter$.MODULE$.apply().format((int)value$2);
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(timeZoneId$3));
            string = timestampFormatter.format(value$2);
        } else {
            throw new MatchError((Object)dataType);
        }
        String dateTimeStr = string;
        return "'" + dateTimeStr + "'";
    }

    private JDBCRelation$() {
    }
}

