/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.runtime.CompactibleFileStreamLog$;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]d!B\u0017/\u0003\u0003i\u0004\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011i\u0003!\u0011!Q\u0001\nmC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tW\u0002\u0011\u0019\u0011)A\u0006Y\")!\u000f\u0001C\u0001g\"91\u0010\u0001b\u0001\n\u0017a\bbBA\u0004\u0001\u0001\u0006I! \u0005\n\u0003\u0013\u0001!\u0019!C\u0006\u0003\u0017A\u0001\"a\u0005\u0001A\u0003%\u0011Q\u0002\u0005\n\u0003+\u0001!\u0019!C\t\u0003/Aq!!\u0007\u0001A\u0003%q\u000bC\u0004\u0002\u001c\u00011\t\"!\b\t\u000f\u0005\u0015\u0002A\"\u0005\u0002(!9\u0011q\u0006\u0001\u0007\u0012\u0005]\u0001BCA\u0019\u0001!\u0015\r\u0011\"\u0006\u0002\u0018!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA \u0001\u0011\u0005\u0013\u0011\t\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0010\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003_\u0003A\u0011IAY\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!!3\u0001\t\u0003\tY\rC\u0004\u0002^\u0002!I!a8\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!1\u0003\u0001\u0005\u0002\tU\u0001b\u0002B\f\u0001\u0011%!\u0011D\u0004\b\u0005?q\u0003\u0012\u0001B\u0011\r\u0019ic\u0006#\u0001\u0003$!1!/\tC\u0001\u0005KA\u0011Ba\n\"\u0005\u0004%\tA!\u000b\t\u0011\tU\u0012\u0005)A\u0005\u0005WA\u0011Ba\u000e\"\u0005\u0004%\t!a\u0006\t\u000f\te\u0012\u0005)A\u0005/\"9!1H\u0011\u0005\u0002\tu\u0002b\u0002B\"C\u0011\u0005!Q\t\u0005\b\u0005\u0017\nC\u0011\u0001B'\u0011\u001d\u0011Y&\tC\u0001\u0005;BqAa\u0019\"\t\u0003\u0011)\u0007C\u0004\u0003l\u0005\"\tA!\u001c\u00031\r{W\u000e]1di&\u0014G.\u001a$jY\u0016\u001cFO]3b[2{wM\u0003\u00020a\u00059!/\u001e8uS6,'BA\u00193\u0003%\u0019HO]3b[&twM\u0003\u00024i\u0005IQ\r_3dkRLwN\u001c\u0006\u0003kY\n1a]9m\u0015\t9\u0004(A\u0003ta\u0006\u00148N\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<7\u0001A\u000b\u0003}5\u001b\"\u0001A \u0011\u0007\u0001\u001bU)D\u0001B\u0015\t\u0011\u0005'A\u0007dQ\u0016\u001c7\u000e]8j]RLgnZ\u0005\u0003\t\u0006\u0013q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\t\u0004\r&[U\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\u000b\u0005\u0013(/Y=\u0011\u00051kE\u0002\u0001\u0003\u0006\u001d\u0002\u0011\ra\u0014\u0002\u0002)F\u0011\u0001k\u0015\t\u0003\rFK!AU$\u0003\u000f9{G\u000f[5oOB\u0011a\tV\u0005\u0003+\u001e\u0013a!\u00118z%\u00164\u0017AE7fi\u0006$\u0017\r^1M_\u001e4VM]:j_:\u0004\"A\u0012-\n\u0005e;%aA%oi\u0006a1\u000f]1sWN+7o]5p]B\u0011A,X\u0007\u0002i%\u0011a\f\u000e\u0002\r'B\f'o[*fgNLwN\\\u0001\u0005a\u0006$\b\u000e\u0005\u0002bQ:\u0011!M\u001a\t\u0003G\u001ek\u0011\u0001\u001a\u0006\u0003Kr\na\u0001\u0010:p_Rt\u0014BA4H\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d<\u0015AC3wS\u0012,gnY3%cA\u0019Q\u000e]&\u000e\u00039T!a\\$\u0002\u000fI,g\r\\3di&\u0011\u0011O\u001c\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"B\u0001\u001e=zuR\u0011Qo\u001e\t\u0004m\u0002YU\"\u0001\u0018\t\u000b-,\u00019\u00017\t\u000bY+\u0001\u0019A,\t\u000bi+\u0001\u0019A.\t\u000b}+\u0001\u0019\u00011\u0002\u000f\u0019|'/\\1ugV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003Q\u0014A\u00026t_:$4/C\u0002\u0002\u0006}\u0014qAR8s[\u0006$8/\u0001\u0005g_Jl\u0017\r^:!\u0003!i\u0017M\\5gKN$XCAA\u0007!\u0011i\u0017qB&\n\u0007\u0005EaN\u0001\u0005NC:Lg-Z:u\u0003%i\u0017M\\5gKN$\b%\u0001\nnS:\u0014\u0015\r^2iKN$vNU3uC&tW#A,\u0002'5LgNQ1uG\",7\u000fV8SKR\f\u0017N\u001c\u0011\u0002%\u0019LG.Z\"mK\u0006tW\u000f\u001d#fY\u0006LXj]\u000b\u0003\u0003?\u00012ARA\u0011\u0013\r\t\u0019c\u0012\u0002\u0005\u0019>tw-\u0001\u000bjg\u0012+G.\u001a;j]\u001e,\u0005\u0010]5sK\u0012dunZ\u000b\u0003\u0003S\u00012ARA\u0016\u0013\r\tic\u0012\u0002\b\u0005>|G.Z1o\u0003Y!WMZ1vYR\u001cu.\u001c9bGRLe\u000e^3sm\u0006d\u0017aD2p[B\f7\r^%oi\u0016\u0014h/\u00197\u0002\u0019MDw.\u001e7e%\u0016$\u0018-\u001b8\u0015\r\u0005%\u0012qGA\u001e\u0011\u0019\tI\u0004\u0005a\u0001\u0017\u0006\u0019An\\4\t\u000f\u0005u\u0002\u00031\u0001\u0002 \u0005Y1-\u001e:sK:$H+[7f\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR!\u00111IA*!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n!AZ:\u000b\u0007\u00055\u0003(\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003#\n9E\u0001\u0003QCRD\u0007bBA+#\u0001\u0007\u0011qD\u0001\bE\u0006$8\r[%e\u00035\u0001\u0018\r\u001e5U_\n\u000bGo\u00195JIR!\u0011qDA.\u0011\u0019y&\u00031\u0001\u0002D\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\tI#!\u0019\t\r}\u001b\u0002\u0019AA\"\u00039\u0019XM]5bY&TX-\u00128uef$b!a\u001a\u0002n\u0005E\u0004c\u0001$\u0002j%\u0019\u00111N$\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003_\"\u0002\u0019A&\u0002\u000b\u0015tGO]=\t\u000f\u0005MD\u00031\u0001\u0002v\u0005\u0019q.\u001e;\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u007f\nAA[1wC&!\u00111QA=\u00051yU\u000f\u001e9viN#(/Z1n\u0003A!Wm]3sS\u0006d\u0017N_3F]R\u0014\u0018\u0010F\u0002L\u0003\u0013Ca!a#\u0016\u0001\u0004\u0001\u0017\u0001\u00027j]\u0016\f\u0011b]3sS\u0006d\u0017N_3\u0015\r\u0005\u001d\u0014\u0011SAK\u0011\u0019\t\u0019J\u0006a\u0001\u000b\u00069An\\4ECR\f\u0007bBA:-\u0001\u0007\u0011QO\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002F\u00037Cq!!(\u0018\u0001\u0004\ty*\u0001\u0002j]B!\u0011qOAQ\u0013\u0011\t\u0019+!\u001f\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0004C\u0012$GCBA\u0015\u0003S\u000bY\u000bC\u0004\u0002Va\u0001\r!a\b\t\r\u00055\u0006\u00041\u0001F\u0003\u0011awnZ:\u0002\u000bA,(oZ3\u0015\t\u0005\u001d\u00141\u0017\u0005\b\u0003kK\u0002\u0019AA\u0010\u0003A!\bN]3tQ>dGMQ1uG\"LE-\u0001\bg_J,\u0017m\u00195J]\n\u000bGo\u00195\u0015\t\u0005m\u0016q\u0019\u000b\u0005\u0003O\ni\fC\u0004\u0002@j\u0001\r!!1\u0002\u0005\u0019t\u0007C\u0002$\u0002D.\u000b9'C\u0002\u0002F\u001e\u0013\u0011BR;oGRLwN\\\u0019\t\u000f\u0005U#\u00041\u0001\u0002 \u0005ia-\u001b7uKJLeNQ1uG\"$B!!4\u0002\\R!\u0011qZAk!\u00111\u0015\u0011[#\n\u0007\u0005MwI\u0001\u0004PaRLwN\u001c\u0005\b\u0003/\\\u0002\u0019AAm\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0004G\u0003\u0007\\\u0015\u0011\u0006\u0005\b\u0003+Z\u0002\u0019AA\u0010\u00039\t\u0007\u000f\u001d7z\r:LeNQ1uG\",B!!9\u0002hR!\u00111\u001dB\u0005)\u0011\t)/a=\u0011\u00071\u000b9\u000fB\u0004\u0002jr\u0011\r!a;\u0003\u0007I+E+E\u0002Q\u0003[\u00042ARAx\u0013\r\t\tp\u0012\u0002\u0004\u0003:L\bbBA`9\u0001\u0007\u0011Q\u001f\t\b\r\u0006\r\u0017q_As!\u0015\tIPa\u0001L\u001d\u0011\tY0a@\u000f\u0007\r\fi0C\u0001I\u0013\r\u0011\taR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Aa\u0002\u0003\u0011%#XM]1u_JT1A!\u0001H\u0011\u001d\t)\u0006\ba\u0001\u0003?\tqaY8na\u0006\u001cG\u000f\u0006\u0004\u0002*\t=!\u0011\u0003\u0005\b\u0003+j\u0002\u0019AA\u0010\u0011\u0019\ti+\ba\u0001\u000b\u0006A\u0011\r\u001c7GS2,7\u000fF\u0001F\u0003A!W\r\\3uK\u0016C\b/\u001b:fI2{w\r\u0006\u0003\u0002h\tm\u0001b\u0002B\u000f?\u0001\u0007\u0011qD\u0001\u000fGV\u0014(/\u001a8u\u0005\u0006$8\r[%e\u0003a\u0019u.\u001c9bGRL'\r\\3GS2,7\u000b\u001e:fC6dun\u001a\t\u0003m\u0006\u001a\"!I*\u0015\u0005\t\u0005\u0012aE\"P\u001bB\u000b5\tV0G\u00132+ulU+G\r&CVC\u0001B\u0016!\u0011\u0011iCa\r\u000e\u0005\t=\"\u0002\u0002B\u0019\u0003{\nA\u0001\\1oO&\u0019\u0011Na\f\u0002)\r{U\nU!D)~3\u0015\nT#`'V3e)\u0013-!\u0003\u0005\u001au*\u0014)B\u0007R{F*\u0011+F\u001d\u000eKvlV!S\u001d~#\u0006JU#T\u0011>cEiX'T\u0003\t\u001au*\u0014)B\u0007R{F*\u0011+F\u001d\u000eKvlV!S\u001d~#\u0006JU#T\u0011>cEiX'TA\u00051r-\u001a;CCR\u001c\u0007.\u00133Ge>lg)\u001b7f\u001d\u0006lW\r\u0006\u0003\u0002 \t}\u0002B\u0002B!O\u0001\u0007\u0001-\u0001\u0005gS2,g*Y7f\u0003EI7oQ8na\u0006\u001cG/[8o\u0005\u0006$8\r\u001b\u000b\u0007\u0003S\u00119E!\u0013\t\u000f\u0005U\u0003\u00061\u0001\u0002 !1\u0011\u0011\u0007\u0015A\u0002]\u000bAeZ3u-\u0006d\u0017\u000e\u001a\"bi\u000eDWm\u001d\"fM>\u0014XmQ8na\u0006\u001cG/[8o\u0005\u0006$8\r\u001b\u000b\u0007\u0005\u001f\u0012)F!\u0017\u0011\r\u0005e(\u0011KA\u0010\u0013\u0011\u0011\u0019Fa\u0002\u0003\u0007M+\u0017\u000fC\u0004\u0003X%\u0002\r!a\b\u0002#\r|W\u000e]1di&|gNQ1uG\"LE\r\u0003\u0004\u00022%\u0002\raV\u0001\u0013O\u0016$\u0018\t\u001c7WC2LGMQ1uG\",7\u000f\u0006\u0004\u0003P\t}#\u0011\r\u0005\b\u0003+R\u0003\u0019AA\u0010\u0011\u001d\t\tD\u000ba\u0001\u0003?\tQC\\3yi\u000e{W\u000e]1di&|gNQ1uG\"LE\r\u0006\u0004\u0002 \t\u001d$\u0011\u000e\u0005\b\u0003+Z\u0003\u0019AA\u0010\u0011\u001d\t\td\u000ba\u0001\u0003?\tQ\u0003Z3sSZ,7i\\7qC\u000e$\u0018J\u001c;feZ\fG\u000eF\u0003X\u0005_\u0012\u0019\b\u0003\u0004\u0003r1\u0002\raV\u0001\u0010I\u00164\u0017-\u001e7u\u0013:$XM\u001d<bY\"1!Q\u000f\u0017A\u0002]\u000bA\u0003\\1uKN$8i\\7qC\u000e$()\u0019;dQ&#\u0007")
public abstract class CompactibleFileStreamLog<T>
extends HDFSMetadataLog<T[]> {
    private int compactInterval;
    private final int metadataLogVersion;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final int minBatchesToRetain;
    private volatile boolean bitmap$0;

    public static int deriveCompactInterval(int defaultInterval, int latestCompactBatchId) {
        return CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(defaultInterval, latestCompactBatchId);
    }

    public static long nextCompactionBatchId(long batchId, long compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(batchId, compactInterval);
    }

    public static Seq<Object> getAllValidBatches(long batchId, long compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.getAllValidBatches(batchId, compactInterval);
    }

    public static Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(compactionBatchId, compactInterval);
    }

    public static boolean isCompactionBatch(long batchId, int compactInterval) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, compactInterval);
    }

    public static long getBatchIdFromFileName(String fileName) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(fileName);
    }

    public static int COMPACT_LATENCY_WARN_THRESHOLD_MS() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS();
    }

    public static String COMPACT_FILE_SUFFIX() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public int minBatchesToRetain() {
        return this.minBatchesToRetain;
    }

    public abstract long fileCleanupDelayMs();

    public abstract boolean isDeletingExpiredLog();

    public abstract int defaultCompactInterval();

    private int compactInterval$lzycompute() {
        CompactibleFileStreamLog compactibleFileStreamLog = this;
        synchronized (compactibleFileStreamLog) {
            if (!this.bitmap$0) {
                long[] compactibleBatchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactibleFileStreamLog.$anonfun$compactInterval$1(f)))), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), Ordering.Long$.MODULE$.reverse());
                IntRef interval = IntRef.create((int)this.defaultCompactInterval());
                if (compactibleBatchIds.length >= 2) {
                    long latestCompactBatchId = compactibleBatchIds[0];
                    long previousCompactBatchId = compactibleBatchIds[1];
                    interval.elem = (int)(latestCompactBatchId - previousCompactBatchId);
                } else if (compactibleBatchIds.length == 1) {
                    interval.elem = CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(this.defaultCompactInterval(), (int)compactibleBatchIds[0]);
                }
                Predef$.MODULE$.assert(interval.elem > 0, (Function0 & Serializable)() -> "intervalValue = " + interval$1.elem + " not positive value.");
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Set the compact interval to ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COMPACT_INTERVAL, BoxesRunTime.boxToInteger((int)interval$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[defaultCompactInterval: "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DEFAULT_COMPACT_INTERVAL, BoxesRunTime.boxToInteger((int)this.defaultCompactInterval()))})))));
                this.compactInterval = interval.elem;
                this.bitmap$0 = true;
            }
        }
        return this.compactInterval;
    }

    public final int compactInterval() {
        if (!this.bitmap$0) {
            return this.compactInterval$lzycompute();
        }
        return this.compactInterval;
    }

    public boolean shouldRetain(T log, long currentTime) {
        return true;
    }

    @Override
    public Path batchIdToPath(long batchId) {
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval())) {
            return new Path(this.metadataPath(), batchId + CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
        }
        return new Path(this.metadataPath(), Long.toString(batchId));
    }

    @Override
    public long pathToBatchId(Path path) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
    }

    @Override
    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private void serializeEntry(T entry, OutputStream out) {
        out.write(Serialization$.MODULE$.write(entry, this.formats()).getBytes(StandardCharsets.UTF_8));
    }

    private T deserializeEntry(String line) {
        return (T)Serialization$.MODULE$.read(line, this.formats(), this.manifest());
    }

    @Override
    public void serialize(T[] logData, OutputStream out) {
        out.write(("v" + this.metadataLogVersion).getBytes(StandardCharsets.UTF_8));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])logData), (Function1 & Serializable)data -> {
            CompactibleFileStreamLog.$anonfun$serialize$1(this, out, data);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public T[] deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file");
        }
        this.validateVersion((String)lines.next(), this.metadataLogVersion);
        return (Object[])lines.map((Function1 & Serializable)line -> this.deserializeEntry((String)line)).toArray(this.manifest());
    }

    @Override
    public boolean add(long batchId, T[] logs) {
        boolean batchAdded;
        block0: {
            boolean bl = batchAdded = CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? this.compact(batchId, logs) : super.add(batchId, logs);
            if (!batchAdded || !this.isDeletingExpiredLog()) break block0;
            this.deleteExpiredLog(batchId);
        }
        return batchAdded;
    }

    @Override
    public void purge(long thresholdBatchId) {
        throw QueryExecutionErrors$.MODULE$.cannotPurgeAsBreakInternalStateError();
    }

    public void foreachInBatch(long batchId, Function1<T, BoxedUnit> fn) {
        this.applyFnInBatch(batchId, (Function1 & Serializable)x$1 -> {
            x$1.foreach(fn);
            return BoxedUnit.UNIT;
        });
    }

    public Option<T[]> filterInBatch(long batchId, Function1<T, Object> predicate) {
        Some some;
        try {
            some = new Some(this.applyFnInBatch(batchId, (Function1 & Serializable)x$2 -> (Object[])x$2.filter(predicate).toArray(this.manifest())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private <RET> RET applyFnInBatch(long batchId, Function1<Iterator<T>, RET> fn) {
        return this.applyFnToBatchByStream(batchId, this.applyFnToBatchByStream$default$2(), (Function1 & Serializable)input -> {
            Iterator lines = Source$.MODULE$.fromInputStream(input, StandardCharsets.UTF_8.name()).getLines();
            if (!lines.hasNext()) {
                throw new IllegalStateException("Incomplete log file");
            }
            this.validateVersion((String)lines.next(), $this.metadataLogVersion);
            return fn.apply((Object)lines.map((Function1 & Serializable)line -> this.deserializeEntry((String)line)));
        });
    }

    private boolean compact(long batchId, T[] logs) {
        long curTime = System.currentTimeMillis();
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            CompactibleFileStreamLog.$anonfun$compact$2(this, batchId, logs, curTime, output);
            return BoxedUnit.UNIT;
        }));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean writeSucceed = tuple2._1$mcZ$sp();
        long elapsedMs = tuple2._2$mcJ$sp();
        Tuple2.mcZJ.sp sp2 = new Tuple2.mcZJ.sp(writeSucceed, elapsedMs);
        boolean writeSucceed2 = sp2._1$mcZ$sp();
        long elapsedMs2 = sp2._2$mcJ$sp();
        if (elapsedMs2 >= (long)CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Compacting took ", " ms for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.ELAPSED_TIME, BoxesRunTime.boxToLong((long)elapsedMs2))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compact batch ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)batchId))})))));
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Compacting took " + elapsedMs2 + " ms for compact batch " + batchId);
        }
        return writeSucceed2;
    }

    public T[] allFiles() {
        long curTime = System.currentTimeMillis();
        LongRef latestId = LongRef.create((long)BoxesRunTime.unboxToLong((Object)this.getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
        while (latestId.elem >= 0L) {
            try {
                Seq logs = (Seq)CompactibleFileStreamLog$.MODULE$.getAllValidBatches(latestId.elem, this.compactInterval()).flatMap((Function1 & Serializable)id -> Predef$.MODULE$.wrapRefArray((Object[])this.filterInBatch(BoxesRunTime.unboxToLong((Object)id), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$this.shouldRetain(x$4, curTime$2))).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException($this.batchIdToPath(id) + " doesn't exist (latestId: " + latestId$1.elem + ", compactInterval: " + $this.compactInterval() + ")");
                })));
                return (Object[])logs.toArray(this.manifest());
            }
            catch (IOException e) {
                long expectedMinLatestId = CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(latestId.elem, this.compactInterval());
                latestId.elem = BoxesRunTime.unboxToLong((Object)super.getLatestBatchId().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                if (latestId.elem >= expectedMinLatestId) continue;
                throw e;
            }
        }
        return (Object[])Array$.MODULE$.empty(this.manifest());
    }

    private void deleteExpiredLog(long currentBatchId) {
        if ((long)this.compactInterval() <= currentBatchId + 1L - (long)this.minBatchesToRetain()) {
            long minBatchId = currentBatchId + 1L - (long)this.minBatchesToRetain();
            long minCompactionBatchId = minBatchId - minBatchId % (long)this.compactInterval() - 1L;
            Predef$.MODULE$.assert(CompactibleFileStreamLog$.MODULE$.isCompactionBatch(minCompactionBatchId, this.compactInterval()), (Function0 & Serializable)() -> minCompactionBatchId + " is not a compaction batch");
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current compact batch id = ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CURRENT_BATCH_ID, BoxesRunTime.boxToLong((long)currentBatchId))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"min compaction batch id to delete = "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.MIN_COMPACTION_BATCH_ID, BoxesRunTime.boxToLong((long)minCompactionBatchId))})))));
            long expiredTime = System.currentTimeMillis() - this.fileCleanupDelayMs();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), path -> {
                boolean bl;
                block3: {
                    try {
                        long batchId = CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
                        if (batchId < minCompactionBatchId) {
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
                return bl;
            })), (Function1 & Serializable)f -> {
                CompactibleFileStreamLog.$anonfun$deleteExpiredLog$4(this, expiredTime, f);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$compactInterval$1(FileStatus f) {
        return f.getPath().toString().endsWith(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$serialize$1(CompactibleFileStreamLog $this, OutputStream out$1, Object data) {
        out$1.write(10);
        $this.serializeEntry(data, out$1);
    }

    private final void writeEntry$1(Object entry, OutputStream output, long curTime$1) {
        if (this.shouldRetain(entry, curTime$1)) {
            output.write(10);
            this.serializeEntry(entry, output);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$compact$2(CompactibleFileStreamLog $this, long batchId$1, Object[] logs$1, long curTime$1, OutputStream output) {
        output.write(("v" + $this.metadataLogVersion).getBytes(StandardCharsets.UTF_8));
        Seq<Object> validBatches = CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(batchId$1, $this.compactInterval());
        validBatches.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> $this.foreachInBatch(id, (Function1 & Serializable)entry -> {
            $this.writeEntry$1(entry, output, curTime$1);
            return BoxedUnit.UNIT;
        }));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(logs$1), (Function1 & Serializable)entry -> {
            $this.writeEntry$1(entry, output, curTime$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteExpiredLog$4(CompactibleFileStreamLog $this, long expiredTime$1, FileStatus f) {
        if (f.getModificationTime() <= expiredTime$1) {
            $this.fileManager().delete(f.getPath());
            return;
        }
    }

    public CompactibleFileStreamLog(int metadataLogVersion, SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.metadataLogVersion = metadataLogVersion;
        super(sparkSession, path, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())));
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        this.minBatchesToRetain = sparkSession.sessionState().conf().minBatchesToRetain();
    }
}

