/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Cache;
import coursierapi.Dependency;
import coursierapi.FetchResult;
import coursierapi.Repository;
import coursierapi.ResolutionParams;
import coursierapi.error.CoursierError;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Fetch {
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<Dependency> bomDependencies = new ArrayList<Dependency>();
    private final List<Repository> repositories = new ArrayList<Repository>(Arrays.asList(ApiHelper.defaultRepositories()));
    private Cache cache = Cache.create();
    private Boolean mainArtifacts = null;
    private final Set<String> classifiers = new HashSet<String>();
    private Set<String> artifactTypes = null;
    private File fetchCache = null;
    private ResolutionParams resolutionParams = ResolutionParams.create();

    private Fetch() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Fetch)) {
            return false;
        }
        Fetch fetch = (Fetch)object;
        return Objects.equals(this.dependencies, fetch.dependencies) && Objects.equals(this.bomDependencies, fetch.bomDependencies) && Objects.equals(this.repositories, fetch.repositories) && Objects.equals(this.cache, fetch.cache) && Objects.equals(this.mainArtifacts, fetch.mainArtifacts) && Objects.equals(this.classifiers, fetch.classifiers) && Objects.equals(this.artifactTypes, fetch.artifactTypes) && Objects.equals(this.fetchCache, fetch.fetchCache) && Objects.equals(this.resolutionParams, fetch.resolutionParams);
    }

    public int hashCode() {
        return Objects.hash(this.dependencies, this.bomDependencies, this.repositories, this.cache, this.mainArtifacts, this.classifiers, this.artifactTypes, this.fetchCache, this.resolutionParams);
    }

    public String toString() {
        return "Fetch{dependencies=" + this.dependencies + ", bomDependencies=" + this.bomDependencies + ", repositories=" + this.repositories + ", cache=" + this.cache + ", mainArtifacts=" + this.mainArtifacts + ", classifiers=" + this.classifiers + ", artifactTypes=" + this.artifactTypes + ", fetchCache=" + this.fetchCache + ", resolutionParams=" + this.resolutionParams + '}';
    }

    public static Fetch create() {
        return new Fetch();
    }

    public Fetch addDependencies(Dependency ... dependencyArray) {
        this.dependencies.addAll(Arrays.asList(dependencyArray));
        return this;
    }

    public Fetch withDependencies(Dependency ... dependencyArray) {
        this.dependencies.clear();
        this.dependencies.addAll(Arrays.asList(dependencyArray));
        return this;
    }

    public Fetch addBomDependencies(Dependency ... dependencyArray) {
        this.bomDependencies.addAll(Arrays.asList(dependencyArray));
        return this;
    }

    public Fetch withBomDependencies(Dependency ... dependencyArray) {
        this.bomDependencies.clear();
        this.bomDependencies.addAll(Arrays.asList(dependencyArray));
        return this;
    }

    public Fetch addRepositories(Repository ... repositoryArray) {
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Fetch withRepositories(Repository ... repositoryArray) {
        this.repositories.clear();
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Fetch withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public Fetch withMainArtifacts(Boolean bl) {
        this.mainArtifacts = bl;
        return this;
    }

    public Fetch withMainArtifacts(boolean bl) {
        this.mainArtifacts = bl;
        return this;
    }

    public Fetch withMainArtifacts() {
        this.mainArtifacts = true;
        return this;
    }

    public Fetch withClassifiers(Set<String> set) {
        this.classifiers.clear();
        this.classifiers.addAll(set);
        return this;
    }

    public Fetch addClassifiers(String ... stringArray) {
        this.classifiers.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Fetch withArtifactTypes(Set<String> set) {
        this.artifactTypes = set == null ? null : new HashSet<String>(set);
        return this;
    }

    public Fetch addArtifactTypes(String ... stringArray) {
        if (this.artifactTypes == null) {
            this.artifactTypes = new HashSet<String>();
        }
        this.artifactTypes.addAll(Arrays.asList(stringArray));
        return this;
    }

    @Deprecated
    public Fetch withFetchCache(File file) {
        return this;
    }

    public Fetch withFetchCacheIKnowWhatImDoing(File file) {
        this.fetchCache = file;
        return this;
    }

    public Fetch withResolutionParams(ResolutionParams resolutionParams) {
        this.resolutionParams = ResolutionParams.of(resolutionParams);
        return this;
    }

    public List<Dependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public List<Dependency> getBomDependencies() {
        return Collections.unmodifiableList(this.bomDependencies);
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public Cache getCache() {
        return this.cache;
    }

    public Boolean getMainArtifacts() {
        return this.mainArtifacts;
    }

    public Set<String> getClassifiers() {
        return Collections.unmodifiableSet(this.classifiers);
    }

    public Set<String> getArtifactTypes() {
        if (this.artifactTypes == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.artifactTypes);
    }

    @Deprecated
    public File getFetchCache() {
        return null;
    }

    public File getFetchCacheIKnowWhatImDoing() {
        return this.fetchCache;
    }

    public ResolutionParams getResolutionParams() {
        return this.resolutionParams;
    }

    public List<File> fetch() throws CoursierError {
        FetchResult fetchResult = this.fetchResult();
        return fetchResult.getFiles();
    }

    public FetchResult fetchResult() throws CoursierError {
        return ApiHelper.doFetch(this);
    }
}

