/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.plexus.archiver.zip;

import coursierapi.shaded.commonscompress.archivers.zip.ZipArchiveEntry;
import coursierapi.shaded.commonscompress.archivers.zip.ZipFile;
import coursierapi.shaded.commonsio.input.BoundedInputStream;
import coursierapi.shaded.commonsio.input.CountingInputStream;
import coursierapi.shaded.plexus.archiver.AbstractUnArchiver;
import coursierapi.shaded.plexus.archiver.ArchiverException;
import coursierapi.shaded.plexus.components.io.resources.PlexusIoResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;

public abstract class AbstractZipUnArchiver
extends AbstractUnArchiver {
    private String encoding = "UTF8";
    private long maxOutputSize = Long.MAX_VALUE;

    @Override
    protected void execute() throws ArchiverException {
        this.execute("", this.getDestDirectory());
    }

    private String resolveSymlink(ZipFile zf, ZipArchiveEntry ze) throws IOException {
        if (ze.isUnixSymlink()) {
            return zf.getUnixSymlink(ze);
        }
        return null;
    }

    @Override
    protected void execute(String path, File outputDirectory) throws ArchiverException {
        this.getLogger().debug("Expanding: " + this.getSourceFile() + " into " + outputDirectory);
        try (ZipFile zipFile = new ZipFile(this.getSourceFile(), this.encoding, true);){
            long remainingSpace = this.maxOutputSize;
            Enumeration<ZipArchiveEntry> e = zipFile.getEntriesInPhysicalOrder();
            while (e.hasMoreElements()) {
                ZipArchiveEntry ze = e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zipFile, ze);
                if (!this.isSelected(ze.getName(), fileInfo) || !ze.getName().startsWith(path)) continue;
                InputStream in = zipFile.getInputStream(ze);
                try {
                    BoundedInputStream bis = new BoundedInputStream(in, remainingSpace + 1L);
                    CountingInputStream cis = new CountingInputStream(bis);
                    this.extractFile(this.getSourceFile(), outputDirectory, cis, ze.getName(), new Date(ze.getTime()), ze.isDirectory(), ze.getUnixMode() != 0 ? Integer.valueOf(ze.getUnixMode()) : null, this.resolveSymlink(zipFile, ze), this.getFileMappers());
                    if ((remainingSpace -= cis.getByteCount()) >= 0L) continue;
                    throw new ArchiverException("Maximum output size limit reached");
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
        }
    }

    private static class ZipEntryFileInfo
    implements PlexusIoResource {
        private final ZipFile zipFile;
        private final ZipArchiveEntry zipEntry;

        ZipEntryFileInfo(ZipFile zipFile, ZipArchiveEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        @Override
        public String getName() {
            return this.zipEntry.getName();
        }
    }
}

