/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.nearest_neighbor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.nearest_neighbor.KNNInput;
import org.sparkproject.dmg.pmml.nearest_neighbor.PMMLElements;
import org.sparkproject.jpmml.model.MissingElementException;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="KNNInputs", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "knnInputs"})
@JsonRootName(value="KNNInputs")
@JsonPropertyOrder(value={"extensions", "knnInputs"})
@Added(value=Version.PMML_4_1)
public class KNNInputs
extends PMMLObject
implements Iterable<KNNInput>,
HasExtensions<KNNInputs> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="KNNInput", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="KNNInput")
    @CollectionElementType(value=KNNInput.class)
    private List<KNNInput> knnInputs;
    private static final long serialVersionUID = 67371272L;

    public KNNInputs() {
    }

    @ValueConstructor
    public KNNInputs(@Property(value="knnInputs") List<KNNInput> knnInputs) {
        this.knnInputs = knnInputs;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public KNNInputs addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<KNNInput> iterator() {
        return this.requireKNNInputs().iterator();
    }

    public boolean hasKNNInputs() {
        return this.knnInputs != null && !this.knnInputs.isEmpty();
    }

    public List<KNNInput> requireKNNInputs() {
        if (this.knnInputs == null || this.knnInputs.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.KNNINPUTS_KNNINPUTS);
        }
        return this.knnInputs;
    }

    public List<KNNInput> getKNNInputs() {
        if (this.knnInputs == null) {
            this.knnInputs = new ArrayList<KNNInput>();
        }
        return this.knnInputs;
    }

    public KNNInputs addKNNInputs(KNNInput ... knnInputs) {
        this.getKNNInputs().addAll(Arrays.asList(knnInputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasKNNInputs()) {
                status = PMMLObject.traverse(visitor, this.getKNNInputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

