/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model;

import jakarta.xml.bind.annotation.XmlEnumValue;
import java.lang.reflect.Field;
import java.util.Objects;
import org.sparkproject.dmg.pmml.PMMLObject;

public class EnumUtil {
    private EnumUtil() {
    }

    public static Field getEnumField(PMMLObject object, Enum<?> value) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!Objects.equals(field.getType(), value.getClass())) continue;
                return field;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getEnumValue(Enum<?> value) {
        Field field;
        Class<?> clazz = value.getClass();
        try {
            field = clazz.getField(value.name());
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        XmlEnumValue enumValue = field.getAnnotation(XmlEnumValue.class);
        if (enumValue != null) {
            return enumValue.value();
        }
        throw new IllegalArgumentException();
    }
}

