/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.inprocess;

import com.google.errorprone.annotations.DoNotCall;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sparkproject.connect.grpc.ChannelCredentials;
import org.sparkproject.connect.grpc.ChannelLogger;
import org.sparkproject.connect.grpc.ExperimentalApi;
import org.sparkproject.connect.grpc.ForwardingChannelBuilder2;
import org.sparkproject.connect.grpc.Internal;
import org.sparkproject.connect.grpc.ManagedChannelBuilder;
import org.sparkproject.connect.grpc.inprocess.AnonymousInProcessSocketAddress;
import org.sparkproject.connect.grpc.inprocess.InProcessSocketAddress;
import org.sparkproject.connect.grpc.inprocess.InProcessTransport;
import org.sparkproject.connect.grpc.internal.ClientTransportFactory;
import org.sparkproject.connect.grpc.internal.ConnectionClientTransport;
import org.sparkproject.connect.grpc.internal.GrpcUtil;
import org.sparkproject.connect.grpc.internal.ManagedChannelImplBuilder;
import org.sparkproject.connect.grpc.internal.SharedResourceHolder;
import org.sparkproject.guava.base.Preconditions;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessChannelBuilder
extends ForwardingChannelBuilder2<InProcessChannelBuilder> {
    private final ManagedChannelImplBuilder managedChannelImplBuilder;
    private ScheduledExecutorService scheduledExecutorService;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;
    private boolean transportIncludeStatusCause = false;
    private long assumedMessageSize = -1L;

    public static InProcessChannelBuilder forName(String name) {
        return InProcessChannelBuilder.forAddress(new InProcessSocketAddress((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
    }

    public static InProcessChannelBuilder forTarget(String target) {
        return new InProcessChannelBuilder(null, (String)Preconditions.checkNotNull((Object)target, (Object)"target"));
    }

    public static InProcessChannelBuilder forAddress(SocketAddress address) {
        return new InProcessChannelBuilder((SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address"), null);
    }

    @DoNotCall(value="Unsupported. Use forName() instead")
    public static InProcessChannelBuilder forAddress(String name, int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    private InProcessChannelBuilder(@Nullable SocketAddress directAddress, @Nullable String target) {
        final class InProcessChannelTransportFactoryBuilder
        implements ManagedChannelImplBuilder.ClientTransportFactoryBuilder {
            InProcessChannelTransportFactoryBuilder() {
            }

            @Override
            public ClientTransportFactory buildClientTransportFactory() {
                return InProcessChannelBuilder.this.buildTransportFactory();
            }
        }
        this.managedChannelImplBuilder = directAddress != null ? new ManagedChannelImplBuilder(directAddress, "localhost", new InProcessChannelTransportFactoryBuilder(), null) : new ManagedChannelImplBuilder(target, new InProcessChannelTransportFactoryBuilder(), null);
        this.managedChannelImplBuilder.setStatsRecordStartedRpcs(false);
        this.managedChannelImplBuilder.setStatsRecordFinishedRpcs(false);
        this.managedChannelImplBuilder.setStatsRecordRetryMetrics(false);
        if (!InProcessTransport.isEnabledSupportTracingMessageSizes) {
            this.managedChannelImplBuilder.disableRetry();
        }
    }

    @Override
    @Internal
    protected ManagedChannelBuilder<?> delegate() {
        return this.managedChannelImplBuilder;
    }

    @Override
    public InProcessChannelBuilder maxInboundMessageSize(int max) {
        return (InProcessChannelBuilder)super.maxInboundMessageSize(max);
    }

    @Override
    public InProcessChannelBuilder useTransportSecurity() {
        return this;
    }

    @Override
    public InProcessChannelBuilder usePlaintext() {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        return this;
    }

    @Override
    public InProcessChannelBuilder keepAliveWithoutCalls(boolean enable) {
        return this;
    }

    public InProcessChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        return this;
    }

    @Override
    public InProcessChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    public InProcessChannelBuilder propagateCauseWithStatus(boolean enable) {
        this.transportIncludeStatusCause = enable;
        return this;
    }

    public InProcessChannelBuilder assumedMessageSize(long assumedMessageSize) {
        Preconditions.checkArgument((assumedMessageSize >= 0L ? 1 : 0) != 0, (Object)"assumedMessageSize must be >= 0");
        this.assumedMessageSize = assumedMessageSize;
        return this;
    }

    ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.scheduledExecutorService, this.maxInboundMetadataSize, this.transportIncludeStatusCause, this.assumedMessageSize);
    }

    void setStatsEnabled(boolean value) {
        this.managedChannelImplBuilder.setStatsEnabled(value);
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final ScheduledExecutorService timerService;
        private final boolean useSharedTimer;
        private final int maxInboundMetadataSize;
        private boolean closed;
        private final boolean includeCauseWithStatus;
        private long assumedMessageSize;

        private InProcessClientTransportFactory(@Nullable ScheduledExecutorService scheduledExecutorService, int maxInboundMetadataSize, boolean includeCauseWithStatus, long assumedMessageSize) {
            this.useSharedTimer = scheduledExecutorService == null;
            this.timerService = this.useSharedTimer ? SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE) : scheduledExecutorService;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.includeCauseWithStatus = includeCauseWithStatus;
            this.assumedMessageSize = assumedMessageSize;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(addr, this.maxInboundMetadataSize, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.includeCauseWithStatus, this.assumedMessageSize);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timerService;
        }

        @Override
        public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
            return null;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.useSharedTimer) {
                SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timerService);
            }
        }

        @Override
        public Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
            return Arrays.asList(InProcessSocketAddress.class, AnonymousInProcessSocketAddress.class);
        }
    }
}

