/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.BitwiseGet$;
import org.apache.spark.sql.catalyst.expressions.BitwiseGetUtil$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, pos) - Returns the value of the bit (0 or 1) at the specified position.\n      The positions are numbered from right to left, starting at zero.\n      The position argument cannot be negative.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(11, 0);\n       1\n      > SELECT _FUNC_(11, 2);\n       0\n  ", since="3.2.0", group="bitwise_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u0010!\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015!\u0007\u0001\"\u0011f\u0011!I\u0007\u0001#b\u0001\n\u0003Q\u0007\"\u00028\u0001\t\u0003z\u0007\"B<\u0001\t\u0003B\bbBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003C\u0001A\u0011KA\u0012\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00026\u0001\t\n\u0011\"\u0001\u00028!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u001f\u0002\u0011\u0011!C!\u0003#B\u0001\"!\u0019\u0001\u0003\u0003%\tA\u001b\u0005\n\u0003G\u0002\u0011\u0011!C\u0001\u0003KB\u0011\"a\u001b\u0001\u0003\u0003%\t%!\u001c\t\u0013\u0005m\u0004!!A\u0005\u0002\u0005u\u0004\"CAA\u0001\u0005\u0005I\u0011IAB\u0011%\t9\tAA\u0001\n\u0003\nIiB\u0005\u0002.\u0002\n\t\u0011#\u0001\u00020\u001aAq\u0004IA\u0001\u0012\u0003\t\t\f\u0003\u0004P3\u0011\u0005\u0011\u0011\u001a\u0005\n\u0003\u0017L\u0012\u0011!C#\u0003\u001bD\u0011\"a4\u001a\u0003\u0003%\t)!5\t\u0013\u0005]\u0017$!A\u0005\u0002\u0006e\u0007\"CAv3\u0005\u0005I\u0011BAw\u0005)\u0011\u0015\u000e^<jg\u0016<U\r\u001e\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M)\u0001A\f\u001a6wA\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aL\u001a\n\u0005Q\u0002#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011A\b\u0012\b\u0003{\ts!AP!\u000e\u0003}R!\u0001\u0011\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014BA\"8\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0012$\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\r;\u0014\u0001\u00027fMR,\u0012!\u0013\t\u0003_)K!a\u0013\u0011\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u00136\u000b\u0005\u00020\u0001!)q)\u0002a\u0001\u0013\")Q*\u0002a\u0001\u0013\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#\u0001,\u0011\u0005Y:\u0016B\u0001-8\u0005\u001d\u0011un\u001c7fC:\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005Y\u0006c\u0001\u001f]=&\u0011QL\u0012\u0002\u0004'\u0016\f\bCA0c\u001b\u0005\u0001'BA1%\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0007M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001g!\tyv-\u0003\u0002iA\nAA)\u0019;b)f\u0004X-A\u0004cSR\u001c\u0016N_3\u0016\u0003-\u0004\"A\u000e7\n\u00055<$aA%oi\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001o];\u0011\u0005Y\n\u0018B\u0001:8\u0005\r\te.\u001f\u0005\u0006i*\u0001\r\u0001]\u0001\u0007i\u0006\u0014x-\u001a;\t\u000bYT\u0001\u0019\u00019\u0002\u0007A|7/A\u0005e_\u001e+gnQ8eKR!\u0011p`A\u0005!\tQX0D\u0001|\u0015\ta\b%A\u0004d_\u0012,w-\u001a8\n\u0005y\\(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u00051\u00021\u0001\u0002\u0004\u0005\u00191\r\u001e=\u0011\u0007i\f)!C\u0002\u0002\bm\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\f-\u0001\r!_\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005ma\u0002BA\u000b\u0003/\u0001\"AP\u001c\n\u0007\u0005eq'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u000339\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\t\u0016QEA\u0015\u0011\u0019\t9#\u0004a\u0001\u0013\u00069a.Z<MK\u001a$\bBBA\u0016\u001b\u0001\u0007\u0011*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000bE\u000b\t$a\r\t\u000f\u001ds\u0001\u0013!a\u0001\u0013\"9QJ\u0004I\u0001\u0002\u0004I\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003sQ3!SA\u001eW\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA$o\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0013\u0011\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0003\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0005Y\u0006twM\u0003\u0002\u0002^\u0005!!.\u0019<b\u0013\u0011\ti\"a\u0016\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0001/a\u001a\t\u0011\u0005%4#!AA\u0002-\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA8!\u0015\t\t(a\u001eq\u001b\t\t\u0019HC\u0002\u0002v]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI(a\u001d\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004-\u0006}\u0004\u0002CA5+\u0005\u0005\t\u0019\u00019\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003'\n)\t\u0003\u0005\u0002jY\t\t\u00111\u0001l\u0003\u0019)\u0017/^1mgR\u0019a+a#\t\u0011\u0005%t#!AA\u0002AD3\u0003AAH\u0003+\u000b9*a'\u0002\u001e\u0006\u0005\u00161UAT\u0003S\u00032aLAI\u0013\r\t\u0019\n\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI*AAT\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003\u0005]8tS\u0001j\u0003EU3ukJt7\u000f\t;iK\u00022\u0018\r\\;fA=4\u0007\u0005\u001e5fA\tLG\u000f\t\u00151A=\u0014\b%M\u0015!CR\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004\u0003o\\:ji&|gN\f\u0006!A\u0001\u0002\u0003\u0005\t+iK\u0002\u0002xn]5uS>t7\u000fI1sK\u0002rW/\u001c2fe\u0016$\u0007E\u001a:p[\u0002\u0012\u0018n\u001a5uAQ|\u0007\u0005\\3gi2\u00023\u000f^1si&tw\rI1uAi,'o\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004\u0003o\\:ji&|g\u000eI1sOVlWM\u001c;!G\u0006tgn\u001c;!E\u0016\u0004c.Z4bi&4XM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002 \u0006y&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00192Y\u0001\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0014\u0007\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t)+A\u00034]Ir\u0003'A\u0003he>,\b/\t\u0002\u0002,\u0006i!-\u001b;xSN,wLZ;oGN\f!BQ5uo&\u001cXmR3u!\ty\u0013dE\u0003\u001a\u0003g\u000by\fE\u0004\u00026\u0006m\u0016*S)\u000e\u0005\u0005]&bAA]o\u00059!/\u001e8uS6,\u0017\u0002BA_\u0003o\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t\t-a2\u000e\u0005\u0005\r'\u0002BAc\u00037\n!![8\n\u0007\u0015\u000b\u0019\r\u0006\u0002\u00020\u0006AAo\\*ue&tw\r\u0006\u0002\u0002T\u0005)\u0011\r\u001d9msR)\u0011+a5\u0002V\")q\t\ba\u0001\u0013\")Q\n\ba\u0001\u0013\u00069QO\\1qa2LH\u0003BAn\u0003O\u0004RANAo\u0003CL1!a88\u0005\u0019y\u0005\u000f^5p]B)a'a9J\u0013&\u0019\u0011Q]\u001c\u0003\rQ+\b\u000f\\33\u0011!\tI/HA\u0001\u0002\u0004\t\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001e\t\u0005\u0003+\n\t0\u0003\u0003\u0002t\u0006]#AB(cU\u0016\u001cG\u000f")
public class BitwiseGet
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int bitSize;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(BitwiseGet x$0) {
        return BitwiseGet$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, BitwiseGet> tupled() {
        return BitwiseGet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, BitwiseGet>> curried() {
        return BitwiseGet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegralType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return ByteType$.MODULE$;
    }

    private int bitSize$lzycompute() {
        BitwiseGet bitwiseGet = this;
        synchronized (bitwiseGet) {
            if (!this.bitmap$0) {
                int n;
                DataType dataType = this.left().dataType();
                if (ByteType$.MODULE$.equals(dataType)) {
                    n = 8;
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    n = 16;
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    n = 32;
                } else if (LongType$.MODULE$.equals(dataType)) {
                    n = 64;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.bitSize = n;
                this.bitmap$0 = true;
            }
        }
        return this.bitSize;
    }

    public int bitSize() {
        if (!this.bitmap$0) {
            return this.bitSize$lzycompute();
        }
        return this.bitSize;
    }

    @Override
    public Object nullSafeEval(Object target, Object pos) {
        int posInt = BoxesRunTime.unboxToInt((Object)pos);
        BitwiseGetUtil$.MODULE$.checkPosition(this.prettyName(), posInt, this.bitSize());
        return BoxesRunTime.boxToByte((byte)((byte)(((Number)target).longValue() >> posInt & 1L)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(target, pos) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |org.apache.spark.sql.catalyst.expressions.BitwiseGetUtil.checkPosition(\n         |  \"" + this.prettyName() + "\", " + pos + ", " + this.bitSize() + ");\n         |" + ev.value() + " = (byte) ((((long) " + target + ") >> " + pos + ") & 1);\n       ")));
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "bit_get");
    }

    @Override
    public BitwiseGet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public BitwiseGet copy(Expression left, Expression right) {
        return new BitwiseGet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "BitwiseGet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseGet;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseGet)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseGet bitwiseGet = (BitwiseGet)x$1;
        Expression expression = this.left();
        Expression expression2 = bitwiseGet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = bitwiseGet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!bitwiseGet.canEqual(this)) return false;
        return true;
    }

    public BitwiseGet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

