/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Length$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the character length of string data or number of bytes of binary data. The length of string data includes the trailing spaces. The length of binary data includes binary zeros.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL ');\n       10\n      > SELECT _FUNC_(x'537061726b2053514c');\n       9\n      > SELECT CHAR_LENGTH('Spark SQL ');\n       10\n      > SELECT CHARACTER_LENGTH('Spark SQL ');\n       10\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\u000e\u001d\u0001&B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")Q\n\u0001C!\u001d\")!\u000b\u0001C!'\")!\f\u0001C!7\")!\r\u0001C!\u001d\")1\r\u0001C)I\")!\u000e\u0001C!W\")\u0011\u0010\u0001C)u\"9Q\u0010AA\u0001\n\u0003q\b\"CA\u0001\u0001E\u0005I\u0011AA\u0002\u0011%\tI\u0002AA\u0001\n\u0003\nY\u0002C\u0005\u0002.\u0001\t\t\u0011\"\u0001\u00020!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u007f\u0001\u0011\u0011!C!\u0003\u0003B\u0011\"a\u0014\u0001\u0003\u0003%\t!!\u0015\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA.\u0001\u0005\u0005I\u0011IA/\u000f%\t\t\tHA\u0001\u0012\u0003\t\u0019I\u0002\u0005\u001c9\u0005\u0005\t\u0012AAC\u0011\u0019IU\u0003\"\u0001\u0002\u001e\"I\u0011qT\u000b\u0002\u0002\u0013\u0015\u0013\u0011\u0015\u0005\n\u0003G+\u0012\u0011!CA\u0003KC\u0011\"!+\u0016\u0003\u0003%\t)a+\t\u0013\u0005]V#!A\u0005\n\u0005e&A\u0002'f]\u001e$\bN\u0003\u0002\u001e=\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\ty\u0002%\u0001\u0005dCR\fG._:u\u0015\t\t#%A\u0002tc2T!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0002\u0001'\u0015\u0001!FL\u00198!\tYC&D\u0001\u001d\u0013\tiCDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYs&\u0003\u000219\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0004Qe>$Wo\u0019;\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\ta\u0004&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011qhM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002@g\u0005)1\r[5mIV\tQ\t\u0005\u0002,\r&\u0011q\t\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u00172\u0003\"a\u000b\u0001\t\u000b\r\u001b\u0001\u0019A#\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\tq\n\u0005\u00023!&\u0011\u0011k\r\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,W#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0003\u0013!\u0002;za\u0016\u001c\u0018BA-W\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tA\fE\u00029;~K!A\u0018\"\u0003\u0007M+\u0017\u000f\u0005\u0002VA&\u0011\u0011M\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\fAB\\;mYN\u000bg-Z#wC2$\"!\u001a5\u0011\u0005I2\u0017BA44\u0005\r\te.\u001f\u0005\u0006S\"\u0001\r!Z\u0001\u0006m\u0006dW/Z\u0001\nI><UM\\\"pI\u0016$2\u0001\u001c:x!\ti\u0007/D\u0001o\u0015\tyG$A\u0004d_\u0012,w-\u001a8\n\u0005Et'\u0001C#yaJ\u001cu\u000eZ3\t\u000bML\u0001\u0019\u0001;\u0002\u0007\r$\b\u0010\u0005\u0002nk&\u0011aO\u001c\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015A\u0018\u00021\u0001m\u0003\t)g/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003\u0017nDQ\u0001 \u0006A\u0002\u0015\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002L\u007f\"91i\u0003I\u0001\u0002\u0004)\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bQ3!RA\u0004W\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAA\ng\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0011Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00027b]\u001eT!!a\n\u0002\t)\fg/Y\u0005\u0005\u0003W\t\tC\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00012AMA\u001a\u0013\r\t)d\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004K\u0006m\u0002\"CA\u001f\u001f\u0005\u0005\t\u0019AA\u0019\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\t\t\u0006\u0003\u000b\nY%Z\u0007\u0003\u0003\u000fR1!!\u00134\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA(\u0002T!A\u0011QH\t\u0002\u0002\u0003\u0007Q-\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u000f\u00033B\u0011\"!\u0010\u0013\u0003\u0003\u0005\r!!\r\u0002\r\u0015\fX/\u00197t)\ry\u0015q\f\u0005\t\u0003{\u0019\u0012\u0011!a\u0001K\"\u001a\u0002!a\u0019\u0002j\u0005-\u0014qNA9\u0003k\n9(a\u001f\u0002~A\u00191&!\u001a\n\u0007\u0005\u001dDDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u00055\u0014!!$`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI2iCJ\f7\r^3sA1,gn\u001a;iA=4\u0007e\u001d;sS:<\u0007\u0005Z1uC\u0002z'\u000f\t8v[\n,'\u000fI8gA\tLH/Z:!_\u001a\u0004#-\u001b8bef\u0004C-\u0019;b]\u0001\"\u0006.\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\u001aHO]5oO\u0002\"\u0017\r^1!S:\u001cG.\u001e3fg\u0002\"\b.\u001a\u0011ue\u0006LG.\u001b8hAM\u0004\u0018mY3t]\u0001\"\u0006.\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\u0012\u0017N\\1ss\u0002\"\u0017\r^1!S:\u001cG.\u001e3fg\u0002\u0012\u0017N\\1ss\u0002RXM]8t]\u0005AQ\r_1na2,7/\t\u0002\u0002t\u0005\tIM\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2\u0003s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006_\u00146g]\u0002d'M\u001c3m\t\u0014\u0004'N\u001a6cQ\u001aw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!s)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033\tS!S?2+ej\u0012+IQ\u001d\u001a\u0006/\u0019:lAM\u000bF\nI\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011D\u0011\u0006\u0013\u0016i\u0011+F%~cUIT$U\u0011\":3\u000b]1sW\u0002\u001a\u0016\u000b\u0014\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011P\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u007f\nAb\u001d;sS:<wLZ;oGN\fa\u0001T3oORD\u0007CA\u0016\u0016'\u0015)\u0012qQAJ!\u0019\tI)a$F\u00176\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u001b\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003#\u000bYIA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0005\u00033\u000b)#\u0001\u0002j_&\u0019\u0011)a&\u0015\u0005\u0005\r\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0011!B1qa2LHcA&\u0002(\")1\t\u0007a\u0001\u000b\u00069QO\\1qa2LH\u0003BAW\u0003g\u0003BAMAX\u000b&\u0019\u0011\u0011W\u001a\u0003\r=\u0003H/[8o\u0011!\t),GA\u0001\u0002\u0004Y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u0018\t\u0005\u0003?\ti,\u0003\u0003\u0002@\u0006\u0005\"AB(cU\u0016\u001cG\u000f")
public class Length
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Length x$0) {
        return Length$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Length, A> g) {
        return Length$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Length> compose(Function1<A$, Expression> g) {
        return Length$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object value) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return BoxesRunTime.boxToInteger((int)((UTF8String)value).numChars());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)((byte[])value).length);
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").numChars()");
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").length");
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Length withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Length copy(Expression child) {
        return new Length(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Length";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Length;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Length)) return false;
        boolean bl = true;
        if (!bl) return false;
        Length length = (Length)x$1;
        Expression expression = this.child();
        Expression expression2 = length.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!length.canEqual(this)) return false;
        return true;
    }

    public Length(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

