/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToDate;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function2;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to a date.\n      The function always returns null on an invalid input with/without ANSI SQL mode enabled. By\n      default, it follows casting rules to a date if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31');\n       2016-12-31\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n      > SELECT _FUNC_('foo', 'yyyy-MM-dd');\n       NULL\n  ", group="datetime_funcs", since="4.0.0")
public final class TryToDateExpressionBuilder$
implements ExpressionBuilder {
    public static final TryToDateExpressionBuilder$ MODULE$ = new TryToDateExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        int numArgs = expressions.length();
        if (numArgs == 1 || numArgs == 2) {
            Expression x$1 = (Expression)expressions.head();
            Option x$2 = ((IterableOps)expressions.drop(1)).lastOption();
            boolean x$3 = false;
            Option<String> x$4 = ParseToDate$.MODULE$.apply$default$3();
            return new ParseToDate(x$1, (Option<Expression>)x$2, x$4, false);
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), numArgs, QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private TryToDateExpressionBuilder$() {
    }
}

