/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.IdentityColumnSpec;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class IdentityColumn$ {
    public static final IdentityColumn$ MODULE$ = new IdentityColumn$();
    private static final String IDENTITY_INFO_START = "identity.start";
    private static final String IDENTITY_INFO_STEP = "identity.step";
    private static final String IDENTITY_INFO_ALLOW_EXPLICIT_INSERT = "identity.allowExplicitInsert";

    public String IDENTITY_INFO_START() {
        return IDENTITY_INFO_START;
    }

    public String IDENTITY_INFO_STEP() {
        return IDENTITY_INFO_STEP;
    }

    public String IDENTITY_INFO_ALLOW_EXPLICIT_INSERT() {
        return IDENTITY_INFO_ALLOW_EXPLICIT_INSERT;
    }

    public void validateIdentityColumn(StructType schema, TableCatalog catalog, Identifier ident) {
        if (this.hasIdentityColumns(schema)) {
            if (!catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORTS_CREATE_TABLE_WITH_IDENTITY_COLUMNS)) {
                throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "identity column");
            }
            return;
        }
    }

    public boolean isIdentityColumn(StructField field) {
        return field.metadata().contains(this.IDENTITY_INFO_START());
    }

    public Option<IdentityColumnSpec> getIdentityInfo(StructField field) {
        if (this.isIdentityColumn(field)) {
            return new Some((Object)new IdentityColumnSpec(field.metadata().getLong(this.IDENTITY_INFO_START()), field.metadata().getLong(this.IDENTITY_INFO_STEP()), field.metadata().getBoolean(this.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT())));
        }
        return None$.MODULE$;
    }

    public boolean hasIdentityColumns(StructType schema) {
        return schema.exists((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)IdentityColumn$.MODULE$.isIdentityColumn(field)));
    }

    private IdentityColumn$() {
    }
}

