/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchViewException;
import org.apache.spark.sql.catalyst.analysis.ViewAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.View;
import org.apache.spark.sql.connector.catalog.ViewChange;
import org.apache.spark.sql.connector.catalog.ViewInfo;

@DeveloperApi
public interface ViewCatalog
extends CatalogPlugin {
    public static final String PROP_COMMENT = "comment";
    public static final String PROP_OWNER = "owner";
    public static final String PROP_CREATE_ENGINE_VERSION = "create_engine_version";
    public static final String PROP_ENGINE_VERSION = "engine_version";
    public static final List<String> RESERVED_PROPERTIES = Arrays.asList("comment", "owner", "create_engine_version", "engine_version");

    public Identifier[] listViews(String ... var1) throws NoSuchNamespaceException;

    public View loadView(Identifier var1) throws NoSuchViewException;

    default public void invalidateView(Identifier ident) {
    }

    default public boolean viewExists(Identifier ident) {
        try {
            return this.loadView(ident) != null;
        }
        catch (NoSuchViewException e) {
            return false;
        }
    }

    public View createView(ViewInfo var1) throws ViewAlreadyExistsException, NoSuchNamespaceException;

    default public View replaceView(ViewInfo viewInfo, boolean orCreate) throws NoSuchViewException, NoSuchNamespaceException {
        if (this.viewExists(viewInfo.ident())) {
            this.dropView(viewInfo.ident());
        } else if (!orCreate) {
            throw new NoSuchViewException(viewInfo.ident());
        }
        try {
            return this.createView(viewInfo);
        }
        catch (ViewAlreadyExistsException e) {
            throw new RuntimeException("Race condition when creating/replacing view", e);
        }
    }

    public View alterView(Identifier var1, ViewChange ... var2) throws NoSuchViewException, IllegalArgumentException;

    public boolean dropView(Identifier var1);

    public void renameView(Identifier var1, Identifier var2) throws NoSuchViewException, ViewAlreadyExistsException;
}

