/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.checksum;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.shuffle.checksum.RowBasedChecksum$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]a!\u0002\f\u0018\u0003\u0003\u0011\u0003\"B\u001e\u0001\t\u0003a\u0004bB \u0001\u0005\u0004%I\u0001\u0011\u0005\u0007\t\u0002\u0001\u000b\u0011B!\t\u000f\u0015\u0003\u0001\u0019!C\u0005\r\"9!\n\u0001a\u0001\n\u0013Y\u0005BB)\u0001A\u0003&q\tC\u0004S\u0001\u0001\u0007I\u0011B*\t\u000f]\u0003\u0001\u0019!C\u00051\"1!\f\u0001Q!\nQCqa\u0017\u0001A\u0002\u0013%1\u000bC\u0004]\u0001\u0001\u0007I\u0011B/\t\r}\u0003\u0001\u0015)\u0003U\u0011\u0015\u0001\u0007\u0001\"\u0001T\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015Q\u0007A\"\u0005l\u0011\u0015q\u0007\u0001\"\u0003p\u000f\u0015\tx\u0003#\u0001s\r\u00151r\u0003#\u0001t\u0011\u0015Y$\u0003\"\u0001|\u0011\u0015a(\u0003\"\u0001~\u0011%\t9AEA\u0001\n\u0013\tIA\u0001\tS_^\u0014\u0015m]3e\u0007\",7m[:v[*\u0011\u0001$G\u0001\tG\",7m[:v[*\u0011!dG\u0001\bg\",hM\u001a7f\u0015\taR$A\u0003ta\u0006\u00148N\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0005\u0001\rJS\u0007\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003UIr!a\u000b\u0019\u000f\u00051zS\"A\u0017\u000b\u00059\n\u0013A\u0002\u001fs_>$h(C\u0001'\u0013\t\tT%A\u0004qC\u000e\\\u0017mZ3\n\u0005M\"$\u0001D*fe&\fG.\u001b>bE2,'BA\u0019&!\t1\u0014(D\u00018\u0015\tA4$\u0001\u0005j]R,'O\\1m\u0013\tQtGA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005i\u0004C\u0001 \u0001\u001b\u00059\u0012\u0001\u0005*P)\u0006#Vi\u0018)P'&#\u0016j\u0014(T+\u0005\t\u0005C\u0001\u0013C\u0013\t\u0019UEA\u0002J]R\f\u0011CU(U\u0003R+u\fU(T\u0013RKuJT*!\u0003!A\u0017m]#se>\u0014X#A$\u0011\u0005\u0011B\u0015BA%&\u0005\u001d\u0011un\u001c7fC:\fA\u0002[1t\u000bJ\u0014xN]0%KF$\"\u0001T(\u0011\u0005\u0011j\u0015B\u0001(&\u0005\u0011)f.\u001b;\t\u000fA+\u0011\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\u0002\u0013!\f7/\u0012:s_J\u0004\u0013aC2iK\u000e\\7/^7Y_J,\u0012\u0001\u0016\t\u0003IUK!AV\u0013\u0003\t1{gnZ\u0001\u0010G\",7m[:v[b{'o\u0018\u0013fcR\u0011A*\u0017\u0005\b!\"\t\t\u00111\u0001U\u00031\u0019\u0007.Z2lgVl\u0007l\u001c:!\u0003-\u0019\u0007.Z2lgVl7+^7\u0002\u001f\rDWmY6tk6\u001cV/\\0%KF$\"\u0001\u00140\t\u000fA[\u0011\u0011!a\u0001)\u0006a1\r[3dWN,XnU;nA\u0005Aq-\u001a;WC2,X-\u0001\u0004va\u0012\fG/\u001a\u000b\u0004\u0019\u000eD\u0007\"\u00023\u000f\u0001\u0004)\u0017aA6fsB\u0011AEZ\u0005\u0003O\u0016\u00121!\u00118z\u0011\u0015Ig\u00021\u0001f\u0003\u00151\u0018\r\\;f\u0003Q\u0019\u0017\r\\2vY\u0006$XMU8x\u0007\",7m[:v[R\u0019A\u000b\\7\t\u000b\u0011|\u0001\u0019A3\t\u000b%|\u0001\u0019A3\u0002\u0015I|G/\u0019;f\u0019\u00164G\u000f\u0006\u0002Ua\")\u0011\u000e\u0005a\u0001)\u0006\u0001\"k\\<CCN,Gm\u00115fG.\u001cX/\u001c\t\u0003}I\u00192AE\u0012u!\t)(0D\u0001w\u0015\t9\b0\u0001\u0002j_*\t\u00110\u0001\u0003kCZ\f\u0017BA\u001aw)\u0005\u0011\u0018AG4fi\u0006;wM]3hCR,Gm\u00115fG.\u001cX/\u001c,bYV,GC\u0001+\u007f\u0011\u0019yH\u00031\u0001\u0002\u0002\u0005\t\"o\\<CCN,Gm\u00115fG.\u001cX/\\:\u0011\t\u0011\n\u0019!P\u0005\u0004\u0003\u000b)#!B!se\u0006L\u0018\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tq\u0006!A.\u00198h\u0013\u0011\t)\"a\u0004\u0003\r=\u0013'.Z2u\u0001")
public abstract class RowBasedChecksum
implements Serializable,
Logging {
    private final int ROTATE_POSITIONS;
    private boolean hasError;
    private long checksumXor;
    private long checksumSum;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long getAggregatedChecksumValue(RowBasedChecksum[] rowBasedChecksums) {
        return RowBasedChecksum$.MODULE$.getAggregatedChecksumValue(rowBasedChecksums);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int ROTATE_POSITIONS() {
        return this.ROTATE_POSITIONS;
    }

    private boolean hasError() {
        return this.hasError;
    }

    private void hasError_$eq(boolean x$1) {
        this.hasError = x$1;
    }

    private long checksumXor() {
        return this.checksumXor;
    }

    private void checksumXor_$eq(long x$1) {
        this.checksumXor = x$1;
    }

    private long checksumSum() {
        return this.checksumSum;
    }

    private void checksumSum_$eq(long x$1) {
        this.checksumSum = x$1;
    }

    public long getValue() {
        if (!this.hasError()) {
            return this.checksumXor() ^ this.rotateLeft(this.checksumSum());
        }
        return 0L;
    }

    public void update(Object key, Object value) {
        if (!this.hasError()) {
            try {
                long rowChecksumValue = this.calculateRowChecksum(key, value);
                this.checksumXor_$eq(this.checksumXor() ^ rowChecksumValue);
                this.checksumSum_$eq(this.checksumSum() + rowChecksumValue);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Checksum computation encountered error: ", throwable2);
                    this.hasError_$eq(true);
                }
                throw throwable;
            }
            return;
        }
    }

    public abstract long calculateRowChecksum(Object var1, Object var2);

    private long rotateLeft(long value) {
        return value << this.ROTATE_POSITIONS() | value >>> 64 - this.ROTATE_POSITIONS();
    }

    public RowBasedChecksum() {
        Logging.$init$((Logging)this);
        this.ROTATE_POSITIONS = 27;
        this.hasError = false;
        this.checksumXor = 0L;
        this.checksumSum = 0L;
    }
}

