/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.TaskLocality$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.AppStatusUtils$;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.ui.jobs.StageDataUtil$;
import org.apache.spark.ui.jobs.StagesTab;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005%b!B\u0007\u000f\u0001AA\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011BQA\u000b\u0001\u0005\u0002-Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u00048\u0001\u0001\u0006I!\r\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019\u0001\u0005\u0001)A\u0005u!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005B\u0002$\u0001A\u0003%1\tC\u0003H\u0001\u0011%\u0001\nC\u0003]\u0001\u0011\u0005Q\fC\u0003w\u0001\u0011%qOA\u0005Ti\u0006<W\rU1hK*\u0011q\u0002E\u0001\u0005U>\u00147O\u0003\u0002\u0012%\u0005\u0011Q/\u001b\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sON\u0011\u0001!\u0007\t\u00035mi\u0011\u0001E\u0005\u00039A\u0011\u0011bV3c+&\u0003\u0016mZ3\u0002\rA\f'/\u001a8u\u0007\u0001\u0001\"\u0001I\u0011\u000e\u00039I!A\t\b\u0003\u0013M#\u0018mZ3t)\u0006\u0014\u0017!B:u_J,\u0007CA\u0013)\u001b\u00051#BA\u0014\u0013\u0003\u0019\u0019H/\u0019;vg&\u0011\u0011F\n\u0002\u000f\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0003\u0019a\u0014N\\5u}Q\u0019A&\f\u0018\u0011\u0005\u0001\u0002\u0001\"B\u000f\u0004\u0001\u0004y\u0002\"B\u0012\u0004\u0001\u0004!\u0013\u0001\u0005+J\u001b\u0016c\u0015JT#`\u000b:\u000b%\tT#E+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$a\u0002\"p_2,\u0017M\\\u0001\u0012)&kU\tT%O\u000b~+e*\u0011\"M\u000b\u0012\u0003\u0013a\u0004+J\u001b\u0016c\u0015JT#`\u0019\u0016;UI\u0014#\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!P\u001a\u0002\u0007alG.\u0003\u0002@y\t!Q\t\\3n\u0003A!\u0016*T#M\u0013:+u\fT#H\u000b:#\u0005%\u0001\nN\u0003b{F+S'F\u0019&sUi\u0018+B'.\u001bV#A\"\u0011\u0005I\"\u0015BA#4\u0005\rIe\u000e^\u0001\u0014\u001b\u0006Cv\fV%N\u000b2Ke*R0U\u0003N[5\u000bI\u0001\u0019O\u0016$Hj\\2bY&$\u0018pU;n[\u0006\u0014\u0018p\u0015;sS:<GCA%U!\tQ\u0015K\u0004\u0002L\u001fB\u0011AjM\u0007\u0002\u001b*\u0011aJH\u0001\u0007yI|w\u000e\u001e \n\u0005A\u001b\u0014A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001U\u001a\t\u000bUS\u0001\u0019\u0001,\u0002\u001f1|7-\u00197jif\u001cV/\\7bef\u0004BAS,J3&\u0011\u0001l\u0015\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001a[\u0013\tY6G\u0001\u0003M_:<\u0017A\u0002:f]\u0012,'\u000f\u0006\u0002_UB\u0019q\fZ4\u000f\u0005\u0001\u0014gB\u0001'b\u0013\u0005!\u0014BA24\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001a4\u0003\u0007M+\u0017O\u0003\u0002dgA\u00111\b[\u0005\u0003Sr\u0012AAT8eK\")1n\u0003a\u0001Y\u00069!/Z9vKN$\bCA7u\u001b\u0005q'BA8q\u0003\u0011AG\u000f\u001e9\u000b\u0005E\u0014\u0018aB:feZdW\r\u001e\u0006\u0002g\u00069!.Y6beR\f\u0017BA;o\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\u0002\u00195\f7.\u001a+j[\u0016d\u0017N\\3\u0015!yC\u0018QBA\t\u0003+\tI\"!\b\u0002\"\u0005\u0015\u0002\"B=\r\u0001\u0004Q\u0018!\u0003;bg.\u001ch)\u001e8d!\r\u001140`\u0005\u0003yN\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0007}#g\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0003mFR1!a\u0002'\u0003\r\t\u0007/[\u0005\u0005\u0003\u0017\t\tA\u0001\u0005UCN\\G)\u0019;b\u0011\u0019\ty\u0001\u0004a\u00013\u0006Y1-\u001e:sK:$H+[7f\u0011\u0019\t\u0019\u0002\u0004a\u0001\u0007\u0006!\u0001/Y4f\u0011\u0019\t9\u0002\u0004a\u0001\u0007\u0006A\u0001/Y4f'&TX\r\u0003\u0004\u0002\u001c1\u0001\raQ\u0001\u000bi>$\u0018\r\u001c)bO\u0016\u001c\bBBA\u0010\u0019\u0001\u00071)A\u0004ti\u0006<W-\u00133\t\r\u0005\rB\u00021\u0001D\u00039\u0019H/Y4f\u0003R$X-\u001c9u\u0013\u0012Da!a\n\r\u0001\u0004\u0019\u0015A\u0003;pi\u0006dG+Y:lg\u0002")
public class StagePage
extends WebUIPage {
    private final StagesTab parent;
    private final AppStatusStore store;
    private final boolean TIMELINE_ENABLED;
    private final Elem TIMELINE_LEGEND;
    private final int MAX_TIMELINE_TASKS;

    private boolean TIMELINE_ENABLED() {
        return this.TIMELINE_ENABLED;
    }

    private Elem TIMELINE_LEGEND() {
        return this.TIMELINE_LEGEND;
    }

    private int MAX_TIMELINE_TASKS() {
        return this.MAX_TIMELINE_TASKS;
    }

    private String getLocalitySummaryString(Map<String, Object> localitySummary) {
        Map names = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.PROCESS_LOCAL().toString()), (Object)"Process local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.NODE_LOCAL().toString()), (Object)"Node local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.RACK_LOCAL().toString()), (Object)"Rack local"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TaskLocality$.MODULE$.ANY().toString()), (Object)"Any")}));
        scala.collection.immutable.Seq localityNamesAndCounts = ((IterableOnceOps)names.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String name = (String)tuple2._2();
                return localitySummary.get((Object)key).map((Function1 & Serializable)count -> StagePage.$anonfun$getLocalitySummaryString$2(name, BoxesRunTime.unboxToLong((Object)count)));
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
        return ((IterableOnceOps)localityNamesAndCounts.sorted((Ordering)Ordering.String$.MODULE$)).mkString("; ");
    }

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq<Node> seq;
        Object object = new Object();
        try {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            String parameterId = request.getParameter("id");
            Predef$.MODULE$.require(parameterId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parameterId)), (Function0 & Serializable)() -> "Missing id parameter");
            String parameterAttempt = request.getParameter("attempt");
            Predef$.MODULE$.require(parameterAttempt != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(parameterAttempt)), (Function0 & Serializable)() -> "Missing attempt parameter");
            String parameterTaskSortColumn = request.getParameter("task.sort");
            String parameterTaskSortDesc = request.getParameter("task.desc");
            String parameterTaskPageSize = request.getParameter("task.pageSize");
            String eventTimelineParameterTaskPage = request.getParameter("task.eventTimelinePageNumber");
            String eventTimelineParameterTaskPageSize = request.getParameter("task.eventTimelinePageSize");
            IntRef eventTimelineTaskPage = IntRef.create((int)BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)eventTimelineParameterTaskPage).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)));
            IntRef eventTimelineTaskPageSize = IntRef.create((int)BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)eventTimelineParameterTaskPageSize).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 100)));
            String taskSortColumn = (String)Option$.MODULE$.apply((Object)parameterTaskSortColumn).map((Function1 & Serializable)sortColumn -> UIUtils$.MODULE$.decodeURLParameter((String)sortColumn)).getOrElse((Function0 & Serializable)() -> "Index");
            boolean taskSortDesc = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)parameterTaskSortDesc).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$3)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            int taskPageSize = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)parameterTaskPageSize).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 100));
            int stageId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parameterId));
            int stageAttemptId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parameterAttempt));
            String stageHeader = "Details for Stage " + stageId + " (Attempt " + stageAttemptId + ")";
            Tuple2 tuple2 = (Tuple2)this.parent.store().asOption((Function0 & Serializable)() -> $this.parent.store().stageAttempt(stageId, stageAttemptId, false, $this.parent.store().stageAttempt$default$4(), $this.parent.store().stageAttempt$default$5(), $this.parent.store().stageAttempt$default$6())).getOrElse((Function0 & Serializable)() -> {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("No information to display for Stage "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stageId));
                $buf2.$amp$plus((Object)new Text(" (Attempt "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stageAttemptId));
                $buf2.$amp$plus((Object)new Text(")"));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem content = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
                throw new NonLocalReturnControl(object, UIUtils$.MODULE$.headerSparkPage(request, stageHeader, (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> content, $this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7()));
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StageData stageData = (StageData)tuple2._1();
            scala.collection.immutable.Seq stageJobIds = (scala.collection.immutable.Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stageData, (Object)stageJobIds);
            StageData stageData2 = (StageData)tuple22._1();
            scala.collection.immutable.Seq stageJobIds2 = (scala.collection.immutable.Seq)tuple22._2();
            Map<String, Object> localitySummary = this.store.localitySummary(stageData2.stageId(), stageData2.attemptId());
            int totalTasks = stageData2.numActiveTasks() + stageData2.numCompleteTasks() + stageData2.numFailedTasks() + stageData2.numKilledTasks();
            if (totalTasks == 0) {
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("Summary Metrics"));
                $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
                $buf.$amp$plus((Object)new Text(" No tasks have started yet\n          "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("Tasks"));
                $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
                $buf.$amp$plus((Object)new Text(" No tasks have started yet\n        "));
                Elem content = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
                return UIUtils$.MODULE$.headerSparkPage(request, stageHeader, (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> content, this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
            }
            if (eventTimelineTaskPageSize.elem < 1 || eventTimelineTaskPageSize.elem > totalTasks) {
                eventTimelineTaskPageSize.elem = totalTasks;
            }
            int eventTimelineTotalPages = (totalTasks + eventTimelineTaskPageSize.elem - 1) / eventTimelineTaskPageSize.elem;
            if (eventTimelineTaskPage.elem < 1 || eventTimelineTaskPage.elem > eventTimelineTotalPages) {
                eventTimelineTaskPage.elem = 1;
            }
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("Submitted:"));
            $buf5.$amp$plus((Object)new Elem(null, "Strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)StageDataUtil$.MODULE$.getFormattedSubmissionTime(stageData2));
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("Duration"));
            $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)StageDataUtil$.MODULE$.getFormattedDuration(stageData2));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("Resource Profile Id: "));
            $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
            $buf9.$amp$plus((Object)new Text("\n            "));
            $buf9.$amp$plus((Object)BoxesRunTime.boxToInteger((int)stageData2.resourceProfileId()));
            $buf9.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("Total Time Across All Tasks: "));
            $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
            $buf11.$amp$plus((Object)new Text("\n            "));
            $buf11.$amp$plus((Object)UIUtils$.MODULE$.formatDuration(stageData2.executorRunTime()));
            $buf11.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
            $buf4.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("Locality Level Summary: "));
            $buf13.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector()));
            $buf13.$amp$plus((Object)new Text("\n            "));
            $buf13.$amp$plus((Object)this.getLocalitySummaryString(localitySummary));
            $buf13.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector()));
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasInput(stageData2)) {
                NodeBuffer $buf15 = new NodeBuffer();
                $buf15.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf16 = new NodeBuffer();
                $buf16.$amp$plus((Object)new Text("Input Size / Records: "));
                $buf15.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf16.toVector()));
                $buf15.$amp$plus((Object)new Text("\n              "));
                $buf15.$amp$plus((Object)(Utils$.MODULE$.bytesToString(stageData2.inputBytes()) + " / " + stageData2.inputRecords()));
                $buf15.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf15.toVector());
                boxedUnit6 = elem;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit6);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasOutput(stageData2)) {
                NodeBuffer $buf17 = new NodeBuffer();
                $buf17.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf18 = new NodeBuffer();
                $buf18.$amp$plus((Object)new Text("Output Size / Records: "));
                $buf17.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf18.toVector()));
                $buf17.$amp$plus((Object)new Text("\n              "));
                $buf17.$amp$plus((Object)(Utils$.MODULE$.bytesToString(stageData2.outputBytes()) + " / " + stageData2.outputRecords()));
                $buf17.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf17.toVector());
                boxedUnit5 = elem;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit5);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasShuffleRead(stageData2)) {
                NodeBuffer $buf19 = new NodeBuffer();
                $buf19.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf20 = new NodeBuffer();
                $buf20.$amp$plus((Object)new Text("Shuffle Read Size / Records: "));
                $buf19.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf20.toVector()));
                $buf19.$amp$plus((Object)new Text("\n              "));
                $buf19.$amp$plus((Object)(Utils$.MODULE$.bytesToString(stageData2.shuffleReadBytes()) + " / " + stageData2.shuffleReadRecords()));
                $buf19.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf19.toVector());
                boxedUnit4 = elem;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit4);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasShuffleWrite(stageData2)) {
                NodeBuffer $buf21 = new NodeBuffer();
                $buf21.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf22 = new NodeBuffer();
                $buf22.$amp$plus((Object)new Text("Shuffle Write Size / Records: "));
                $buf21.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf22.toVector()));
                $buf21.$amp$plus((Object)new Text("\n               "));
                $buf21.$amp$plus((Object)(Utils$.MODULE$.bytesToString(stageData2.shuffleWriteBytes()) + " / " + stageData2.shuffleWriteRecords()));
                $buf21.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf21.toVector());
                boxedUnit3 = elem;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit3);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (ApiHelper$.MODULE$.hasBytesSpilled(stageData2)) {
                NodeBuffer $buf23 = new NodeBuffer();
                NodeBuffer $buf24 = new NodeBuffer();
                $buf24.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf25 = new NodeBuffer();
                $buf25.$amp$plus((Object)new Text("Spill (Memory): "));
                $buf24.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf25.toVector()));
                $buf24.$amp$plus((Object)new Text("\n              "));
                $buf24.$amp$plus((Object)Utils$.MODULE$.bytesToString(stageData2.memoryBytesSpilled()));
                $buf24.$amp$plus((Object)new Text("\n            "));
                $buf23.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf24.toVector()));
                NodeBuffer $buf26 = new NodeBuffer();
                $buf26.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf27 = new NodeBuffer();
                $buf27.$amp$plus((Object)new Text("Spill (Disk): "));
                $buf26.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf27.toVector()));
                $buf26.$amp$plus((Object)new Text("\n              "));
                $buf26.$amp$plus((Object)Utils$.MODULE$.bytesToString(stageData2.diskBytesSpilled()));
                $buf26.$amp$plus((Object)new Text("\n            "));
                $buf23.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf26.toVector()));
                boxedUnit2 = $buf23;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit2);
            $buf4.$amp$plus((Object)new Text("\n          "));
            if (!stageJobIds2.isEmpty()) {
                NodeBuffer $buf28 = new NodeBuffer();
                $buf28.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf29 = new NodeBuffer();
                $buf29.$amp$plus((Object)new Text("Associated Job Ids: "));
                $buf28.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf29.toVector()));
                $buf28.$amp$plus((Object)new Text("\n              "));
                $buf28.$amp$plus(((IterableOps)stageJobIds2.sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)jobId -> StagePage.$anonfun$render$17(this, request, BoxesRunTime.unboxToInt((Object)jobId))));
                $buf28.$amp$plus((Object)new Text("\n            "));
                Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf28.toVector());
                boxedUnit = elem;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf4.$amp$plus((Object)boxedUnit);
            $buf4.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
            Option stageGraph = this.parent.store().asOption((Function0 & Serializable)() -> $this.parent.store().operationGraphForStage(stageId));
            scala.collection.immutable.Seq<Node> dagViz = UIUtils$.MODULE$.showDagVizForStage(stageId, stageGraph);
            long currentTime = System.currentTimeMillis();
            String js = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + UIUtils$.MODULE$.formatImportJavaScript(request, "/static/stagepage.js", (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"setTaskThreadDumpEnabled"})) + "\n         |\n         |setTaskThreadDumpEnabled(" + this.parent.threadDumpEnabled() + ");\n         |"));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("id", (Seq)new Text("showAdditionalMetrics"), (MetaData)$md2);
            NodeSeq nodeSeq = summary.$plus$plus(dagViz).$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus(this.makeTimeline((Function0<scala.collection.immutable.Seq<TaskData>>)(Function0 & Serializable)() -> {
                int from = (eventTimelineTaskPage$1.elem - 1) * eventTimelineTaskPageSize$1.elem;
                int dataSize = (int)$this.store.taskCount(stageData2.stageId(), stageData2.attemptId());
                int to = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(dataSize), eventTimelineTaskPage$1.elem * eventTimelineTaskPageSize$1.elem);
                scala.collection.immutable.Seq<TaskData> sliceData = $this.store.taskList(stageData2.stageId(), stageData2.attemptId(), from, to - from, ApiHelper$.MODULE$.indexName(taskSortColumn), !taskSortDesc, $this.store.taskList$default$7());
                return sliceData;
            }, currentTime, eventTimelineTaskPage.elem, eventTimelineTaskPageSize.elem, eventTimelineTotalPages, stageId, stageAttemptId, totalTasks));
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("id", (Seq)new Text("parent-container"), (MetaData)$md3);
            NodeBuffer $buf30 = new NodeBuffer();
            $buf30.$amp$plus((Object)new Text("\n          "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/utils.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md4);
            $md4 = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md4);
            $buf30.$amp$plus((Object)new Elem(null, "script", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf30.$amp$plus((Object)new Text("\n          "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("src", UIUtils$.MODULE$.prependBaseUri(request, "/static/stagepage.js", UIUtils$.MODULE$.prependBaseUri$default$3()), (MetaData)$md5);
            $md5 = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md5);
            $buf30.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf30.$amp$plus((Object)new Text("\n          "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("type", (Seq)new Text("module"), (MetaData)$md6);
            NodeBuffer $buf31 = new NodeBuffer();
            $buf31.$amp$plus((Object)Unparsed$.MODULE$.apply(js));
            $buf30.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf31.toVector()));
            $buf30.$amp$plus((Object)new Text("\n        "));
            NodeSeq content = nodeSeq.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf30.toVector()));
            HttpServletRequest x$12 = request;
            String x$22 = stageHeader;
            Function0 & Serializable x$32 = (Function0 & Serializable)() -> content;
            StagesTab x$42 = this.parent;
            boolean x$5 = true;
            boolean x$6 = true;
            Option<String> x$7 = UIUtils$.MODULE$.headerSparkPage$default$5();
            seq = UIUtils$.MODULE$.headerSparkPage(x$12, x$22, (Function0<scala.collection.immutable.Seq<Node>>)x$32, x$42, x$7, true, true);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (scala.collection.immutable.Seq<Node>)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    private scala.collection.immutable.Seq<Node> makeTimeline(Function0<scala.collection.immutable.Seq<TaskData>> tasksFunc, long currentTime, int page, int pageSize, int totalPages, int stageId, int stageAttemptId, int totalTasks) {
        Elem elem;
        if (!this.TIMELINE_ENABLED()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tasksFunc.apply();
        HashSet executorsSet = new HashSet();
        LongRef minLaunchTime = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxFinishTime = LongRef.create((long)Long.MIN_VALUE);
        String executorsArrayStr = ((IterableOnceOps)((IterableOps)((IterableOps)tasks.sortBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$1(x$6)), (Ordering)Ordering.Long$.MODULE$)).take(this.MAX_TIMELINE_TASKS())).map((Function1 & Serializable)taskInfo -> {
            String executorId = taskInfo.executorId();
            String host = taskInfo.host();
            executorsSet.$plus$eq((Object)new Tuple2((Object)executorId, (Object)host));
            long launchTime = taskInfo.launchTime().getTime();
            long finishTime = BoxesRunTime.unboxToLong((Object)taskInfo.duration().map((Function1)(JFunction1.mcJJ.sp & Serializable)x$7 -> taskInfo.launchTime().getTime() + x$7).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> currentTime));
            long totalExecutionTime = finishTime - launchTime;
            minLaunchTime$1.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(launchTime), minLaunchTime$1.elem);
            maxFinishTime$1.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(finishTime), maxFinishTime$1.elem);
            Option<TaskMetrics> metricsOpt = taskInfo.taskMetrics();
            long shuffleReadTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$5(x$8))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            double shuffleReadTimeProportion = StagePage.toProportion$1(shuffleReadTime, totalExecutionTime);
            long shuffleWriteTime = (long)((double)BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StagePage.$anonfun$makeTimeline$7(x$9))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) / 1000000.0);
            double shuffleWriteTimeProportion = StagePage.toProportion$1(shuffleWriteTime, totalExecutionTime);
            long serializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.resultSerializationTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            double serializationTimeProportion = StagePage.toProportion$1(serializationTime, totalExecutionTime);
            long deserializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.executorDeserializeTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            double deserializationTimeProportion = StagePage.toProportion$1(deserializationTime, totalExecutionTime);
            long gettingResultTime = AppStatusUtils$.MODULE$.gettingResultTime((TaskData)taskInfo);
            double gettingResultTimeProportion = StagePage.toProportion$1(gettingResultTime, totalExecutionTime);
            long schedulerDelay = AppStatusUtils$.MODULE$.schedulerDelay((TaskData)taskInfo);
            double schedulerDelayProportion = StagePage.toProportion$1(schedulerDelay, totalExecutionTime);
            long executorOverhead = serializationTime + deserializationTime;
            long executorRunTime = taskInfo.duration().isDefined() ? scala.math.package$.MODULE$.max(totalExecutionTime - executorOverhead - gettingResultTime - schedulerDelay, 0L) : BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.executorRunTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> scala.math.package$.MODULE$.max(totalExecutionTime - executorOverhead - gettingResultTime - schedulerDelay, 0L)));
            long executorComputingTime = executorRunTime - shuffleReadTime - shuffleWriteTime;
            double executorComputingTimeProportion = scala.math.package$.MODULE$.max((double)100 - schedulerDelayProportion - shuffleReadTimeProportion - shuffleWriteTimeProportion - serializationTimeProportion - deserializationTimeProportion - gettingResultTimeProportion, 0.0);
            int schedulerDelayProportionPos = 0;
            double deserializationTimeProportionPos = (double)schedulerDelayProportionPos + schedulerDelayProportion;
            double shuffleReadTimeProportionPos = deserializationTimeProportionPos + deserializationTimeProportion;
            double executorRuntimeProportionPos = shuffleReadTimeProportionPos + shuffleReadTimeProportion;
            double shuffleWriteTimeProportionPos = executorRuntimeProportionPos + executorComputingTimeProportion;
            double serializationTimeProportionPos = shuffleWriteTimeProportionPos + shuffleWriteTimeProportion;
            double gettingResultTimeProportionPos = serializationTimeProportionPos + serializationTimeProportion;
            int index = taskInfo.index();
            int attempt = taskInfo.attempt();
            String svgTag = totalExecutionTime == 0L ? "<svg class=\"task-assignment-timeline-duration-bar\"></svg>" : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<svg class=\"task-assignment-timeline-duration-bar\">\n                 |<rect class=\"scheduler-delay-proportion\"\n                   |x=\"" + schedulerDelayProportionPos + "%\" y=\"0px\" height=\"26px\"\n                   |width=\"" + schedulerDelayProportion + "%\"></rect>\n                 |<rect class=\"deserialization-time-proportion\"\n                   |x=\"" + deserializationTimeProportionPos + "%\" y=\"0px\" height=\"26px\"\n                   |width=\"" + deserializationTimeProportion + "%\"></rect>\n                 |<rect class=\"shuffle-read-time-proportion\"\n                   |x=\"" + shuffleReadTimeProportionPos + "%\" y=\"0px\" height=\"26px\"\n                   |width=\"" + shuffleReadTimeProportion + "%\"></rect>\n                 |<rect class=\"executor-runtime-proportion\"\n                   |x=\"" + executorRuntimeProportionPos + "%\" y=\"0px\" height=\"26px\"\n                   |width=\"" + executorComputingTimeProportion + "%\"></rect>\n                 |<rect class=\"shuffle-write-time-proportion\"\n                   |x=\"" + shuffleWriteTimeProportionPos + "%\" y=\"0px\" height=\"26px\"\n                   |width=\"" + shuffleWriteTimeProportion + "%\"></rect>\n                 |<rect class=\"serialization-time-proportion\"\n                   |x=\"" + serializationTimeProportionPos + "%\" y=\"0px\" height=\"26px\"\n                   |width=\"" + serializationTimeProportion + "%\"></rect>\n                 |<rect class=\"getting-result-time-proportion\"\n                   |x=\"" + gettingResultTimeProportionPos + "%\" y=\"0px\" height=\"26px\"\n                   |width=\"" + gettingResultTimeProportion + "%\"></rect></svg>"));
            String timelineObject = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |{\n               |'className': 'task task-assignment-timeline-object',\n               |'group': '" + executorId + "',\n               |'content': '<div class=\"task-assignment-timeline-content\"\n                 |data-toggle=\"tooltip\" data-placement=\"top\"\n                 |data-html=\"true\" data-container=\"body\"\n                 |data-title=\"Task " + index + " (attempt " + attempt + ")<br>\n                 |Status: " + taskInfo.status() + "<br>\n                 |Launch Time: " + UIUtils$.MODULE$.formatDate(new Date(launchTime)) + "\n                 |" + (taskInfo.duration().isEmpty() ? "<br>Finish Time: " + UIUtils$.MODULE$.formatDate(new Date(finishTime)) : "") + "\n                 |<br>Scheduler Delay: " + schedulerDelay + " ms\n                 |<br>Task Deserialization Time: " + UIUtils$.MODULE$.formatDuration(deserializationTime) + "\n                 |<br>Shuffle Read Time: " + UIUtils$.MODULE$.formatDuration(shuffleReadTime) + "\n                 |<br>Executor Computing Time: " + UIUtils$.MODULE$.formatDuration(executorComputingTime) + "\n                 |<br>Shuffle Write Time: " + UIUtils$.MODULE$.formatDuration(shuffleWriteTime) + "\n                 |<br>Result Serialization Time: " + UIUtils$.MODULE$.formatDuration(serializationTime) + "\n                 |<br>Getting Result Time: " + UIUtils$.MODULE$.formatDuration(gettingResultTime) + "\">\n                 |" + svgTag + "',\n               |'start': new Date(" + launchTime + "),\n               |'end': new Date(" + finishTime + ")\n             |}\n           |")).replaceAll("[\\r\\n]+", " ");
            return timelineObject;
        })).mkString("[", ",", "]");
        String groupArrayStr = ((IterableOnceOps)executorsSet.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String executorId = (String)tuple2._1();
                String host = (String)tuple2._2();
                return "\n            {\n              'id': '" + executorId + "',\n              'content': '" + executorId + " / " + host + "',\n            }\n          ";
            }
            throw new MatchError((Object)tuple2);
        })).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-task-assignment-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-task-assignment-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Event Timeline"));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem2 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("id", (Seq)new Text("task-assignment-timeline"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_TASKS() < tasks.size()) {
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            Only the most recent "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_TASKS()));
            $buf4.$amp$plus((Object)new Text(" tasks\n            (of "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)tasks.size()));
            $buf4.$amp$plus((Object)new Text(" total) are shown.\n          "));
            Elem elem3 = new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector());
            elem = elem3;
        } else {
            elem = package$.MODULE$.Seq().empty();
        }
        $buf3.$amp$plus((Object)elem);
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("task-assignment-timeline-zoom-lock"), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md6);
        $buf6.$amp$plus((Object)new Elem(null, "input", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Enable zooming"));
        $buf6.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf5.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", (Seq)new Text("margin-bottom: 0px;"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("form-inline float-right justify-content-end"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("action", (Seq)Nil$.MODULE$, (MetaData)$md7);
        $md7 = new UnprefixedAttribute("method", (Seq)new Text("get"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("id", "form-event-timeline-page", (MetaData)$md7);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Tasks: "));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)totalTasks));
        $buf10.$amp$plus((Object)new Text(". "));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)totalPages));
        $buf10.$amp$plus((Object)new Text(" Pages. Jump to"));
        $buf9.$amp$plus((Object)new Elem(null, "label", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("value", Integer.toString(stageId), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("name", (Seq)new Text("id"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md8);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("value", Integer.toString(stageAttemptId), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("name", (Seq)new Text("attempt"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("type", (Seq)new Text("hidden"), (MetaData)$md9);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("col-1 form-control"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("value", Integer.toString(page), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("id", "form-event-timeline-page-no", (MetaData)$md10);
        $md10 = new UnprefixedAttribute("name", (Seq)new Text("task.eventTimelinePageNumber"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md10);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n\n            "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text(". Show "));
        $buf9.$amp$plus((Object)new Elem(null, "label", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("col-1 form-control"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("value", Integer.toString(pageSize), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("name", (Seq)new Text("task.eventTimelinePageSize"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("id", "form-event-timeline-page-size", (MetaData)$md11);
        $md11 = new UnprefixedAttribute("type", (Seq)new Text("text"), (MetaData)$md11);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("items in a page."));
        $buf9.$amp$plus((Object)new Elem(null, "label", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
        $buf9.$amp$plus((Object)new Text("\n\n            "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("class", (Seq)new Text("btn btn-spark"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("type", (Seq)new Text("submit"), (MetaData)$md12);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("Go"));
        $buf9.$amp$plus((Object)new Elem(null, "button", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector()));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "form", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)this.TIMELINE_LEGEND());
        $buf3.$amp$plus((Object)new Text("\n    "));
        NodeSeq nodeSeq = elem2.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md13);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n      "));
        $buf14.$amp$plus((Object)Unparsed$.MODULE$.apply("drawTaskAssignmentTimeline(" + groupArrayStr + ", " + executorsArrayStr + ", " + minLaunchTime.elem + ", " + maxFinishTime.elem + ", " + UIUtils$.MODULE$.getTimeZoneOffset() + ")"));
        $buf14.$amp$plus((Object)new Text("\n    "));
        return nodeSeq.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "script", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector()));
    }

    public static final /* synthetic */ String $anonfun$getLocalitySummaryString$2(String name$1, long count) {
        return name$1 + ": " + count;
    }

    public static final /* synthetic */ NodeBuffer $anonfun$render$17(StagePage $this, HttpServletRequest request$1, int jobId) {
        String jobURL = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s/jobs/job/?id=%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request$1, $this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), BoxesRunTime.boxToInteger((int)jobId)}));
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", jobURL, (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)Integer.toString(jobId));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new EntityRef("nbsp"));
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        return $buf;
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$1(TaskData x$6) {
        return -x$6.launchTime().getTime();
    }

    private static final double toProportion$1(long time, long totalExecutionTime$1) {
        return (double)time / (double)totalExecutionTime$1 * (double)100;
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$5(TaskMetrics x$8) {
        return x$8.shuffleReadMetrics().fetchWaitTime();
    }

    public static final /* synthetic */ long $anonfun$makeTimeline$7(TaskMetrics x$9) {
        return x$9.shuffleWriteMetrics().writeTime();
    }

    public StagePage(StagesTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("stage");
        this.TIMELINE_ENABLED = BoxesRunTime.unboxToBoolean((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_ENABLED()));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        .colon.colon legendPairs = new .colon.colon((Object)new Tuple2((Object)"scheduler-delay-proportion", (Object)"Scheduler Delay"), (List)new .colon.colon((Object)new Tuple2((Object)"deserialization-time-proportion", (Object)"Task Deserialization Time"), (List)new .colon.colon((Object)new Tuple2((Object)"shuffle-read-time-proportion", (Object)"Shuffle Read Time"), (List)new .colon.colon((Object)new Tuple2((Object)"executor-runtime-proportion", (Object)"Executor Computing Time"), (List)new .colon.colon((Object)new Tuple2((Object)"shuffle-write-time-proportion", (Object)"Shuffle Write Time"), (List)new .colon.colon((Object)new Tuple2((Object)"serialization-time-proportion", (Object)"Result Serialization Time"), (List)new .colon.colon((Object)new Tuple2((Object)"getting-result-time-proportion", (Object)"Getting Result Time"), (List)Nil$.MODULE$)))))));
        $buf2.$amp$plus((Object)((List)legendPairs.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    String classAttr = (String)tuple22._1();
                    String name = (String)tuple22._2();
                    NodeBuffer $buf = new NodeBuffer();
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", classAttr, (MetaData)$md);
                    $md = new UnprefixedAttribute("height", (Seq)new Text("10px"), (MetaData)$md);
                    $md = new UnprefixedAttribute("width", (Seq)new Text("10px"), (MetaData)$md);
                    $md = new UnprefixedAttribute("y", 10 + index % 3 * 15 + "px", (MetaData)$md);
                    $md = new UnprefixedAttribute("x", 5 + index / 3 * 210 + "px", (MetaData)$md);
                    $buf.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
                    Null$ $md2 = Null$.MODULE$;
                    $md2 = new UnprefixedAttribute("y", 20 + index % 3 * 15 + "px", (MetaData)$md2);
                    $md2 = new UnprefixedAttribute("x", 25 + index / 3 * 210 + "px", (MetaData)$md2);
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)name);
                    $buf.$amp$plus((Object)new Elem(null, "text", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
                    return $buf;
                }
            }
            throw new MatchError((Object)tuple2);
        }));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        this.TIMELINE_LEGEND = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        this.MAX_TIMELINE_TASKS = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_TASKS_MAXIMUM()));
    }
}

