/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.DataflowGraphTransformer$;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.GraphElement;
import org.apache.spark.sql.pipelines.graph.ResolutionCompletedFlow;
import org.apache.spark.sql.pipelines.graph.ResolutionFailedFlow;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NoStackTrace;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\r-g\u0001\u00024h\u0001QD\u0011\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111\u0003\u0005\n\u0003o\u0001\u0001\u0019!C\u0005\u0003sA\u0001\"a\u0012\u0001A\u0003&\u0011Q\u0003\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017B\u0011\"!\u001b\u0001\u0001\u0004%I!a\u001b\t\u0011\u0005=\u0004\u0001)Q\u0005\u0003\u001bB\u0011\"!\u001d\u0001\u0001\u0004%I!a\u001d\t\u0013\u0005u\u0004\u00011A\u0005\n\u0005}\u0004\u0002CAB\u0001\u0001\u0006K!!\u001e\t\u0013\u0005\u0015\u0005\u00011A\u0005\n\u0005\u001d\u0005\"CAF\u0001\u0001\u0007I\u0011BAG\u0011!\t\t\n\u0001Q!\n\u0005%\u0005\"CAJ\u0001\u0001\u0007I\u0011BAK\u0011%\ty\n\u0001a\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002&\u0002\u0001\u000b\u0015BAL\u0011%\t9\u000b\u0001a\u0001\n\u0013\tI\u000bC\u0005\u0002.\u0002\u0001\r\u0011\"\u0003\u00020\"A\u00111\u0017\u0001!B\u0013\tY\u000bC\u0005\u00026\u0002\u0001\r\u0011\"\u0003\u00028\"I\u0011\u0011\u0019\u0001A\u0002\u0013%\u00111\u0019\u0005\t\u0003\u000f\u0004\u0001\u0015)\u0003\u0002:\"I\u0011\u0011\u001a\u0001A\u0002\u0013%\u00111\u001a\u0005\n\u0003\u001f\u0004\u0001\u0019!C\u0005\u0003#D\u0001\"!6\u0001A\u0003&\u0011Q\u001a\u0005\n\u0003/\u0004\u0001\u0019!C\u0005\u00033D\u0011\"a9\u0001\u0001\u0004%I!!:\t\u0011\u0005%\b\u0001)Q\u0005\u00037D\u0011\"a;\u0001\u0001\u0004%I!a\u0005\t\u0013\u00055\b\u00011A\u0005\n\u0005=\b\u0002CAz\u0001\u0001\u0006K!!\u0006\t\u0013\u0005U\b\u00011A\u0005\n\u0005]\u0006\"CA|\u0001\u0001\u0007I\u0011BA}\u0011!\ti\u0010\u0001Q!\n\u0005e\u0006\"CA\u0000\u0001\t\u0007I\u0011\u0002B\u0001\u0011!\u0011I\u0001\u0001Q\u0001\n\t\r\u0001\"\u0003B\u0006\u0001\u0001\u0007I\u0011\u0002B\u0007\u0011%\u0011)\u0002\u0001a\u0001\n\u0013\u00119\u0002\u0003\u0005\u0003\u001c\u0001\u0001\u000b\u0015\u0002B\b\u0011)\u0011i\u0002\u0001EC\u0002\u0013%!q\u0004\u0005\n\u0005c\u0001!\u0019!C\u0005\u0005gA\u0001Ba\u000f\u0001A\u0003%!Q\u0007\u0005\b\u0005{\u0001A\u0011\u0002B \u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0012\u0001\t\u0013\u00119\u0005C\u0004\u0003J\u0001!IAa\u0013\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!1\f\u0001\u0005\u0002\tu\u0003\"\u0003B:\u0001E\u0005I\u0011\u0001B;\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001bCqAa$\u0001\t\u0003\u0012\tjB\u0004\u0003\u0014\u001eD\tA!&\u0007\r\u0019<\u0007\u0012\u0001BL\u0011\u001d\tIA\u000eC\u0001\u0005?3aA!)7\u0001\n\r\u0006B\u0003Bcq\tU\r\u0011\"\u0001\u0003H\"Q!\u0011\u001a\u001d\u0003\u0012\u0003\u0006I!!\u0018\t\u0015\t-\u0007H!f\u0001\n\u0003\u0011i\r\u0003\u0006\u0003Vb\u0012\t\u0012)A\u0005\u0005\u001fDq!!\u00039\t\u0003\u00119\u000eC\u0005\u0003bb\n\t\u0011\"\u0001\u0003d\"I!\u0011\u001e\u001d\u0012\u0002\u0013\u0005!1\u001e\u0005\n\u0005_D\u0014\u0013!C\u0001\u0005cD\u0011B!>9\u0003\u0003%\tEa>\t\u0013\t}\b(!A\u0005\u0002\t\u0005\u0001\"CB\u0001q\u0005\u0005I\u0011AB\u0002\u0011%\u0019i\u0001OA\u0001\n\u0003\u001ay\u0001C\u0005\u0004\u001ea\n\t\u0011\"\u0001\u0004 !I11\u0005\u001d\u0002\u0002\u0013\u00053Q\u0005\u0005\n\u0007SA\u0014\u0011!C!\u0007WA\u0011b!\f9\u0003\u0003%\tea\f\b\u0013\rMb'!A\t\u0002\rUb!\u0003BQm\u0005\u0005\t\u0012AB\u001c\u0011\u001d\tIA\u0013C\u0001\u0007\u001fB\u0011b!\u0015K\u0003\u0003%)ea\u0015\t\u0013\rU#*!A\u0005\u0002\u000e]\u0003\"CB/\u0015\u0006\u0005I\u0011QB0\u0011%\u0019\tHSA\u0001\n\u0013\u0019\u0019H\u0002\u0004\u0004vY\u00025q\u000f\u0005\u000b\u0005\u0017\u0004&Q3A\u0005\u0002\t5\u0007B\u0003Bk!\nE\t\u0015!\u0003\u0003P\"9\u0011\u0011\u0002)\u0005\u0002\re\u0004\"\u0003Bq!\u0006\u0005I\u0011AB@\u0011%\u0011I\u000fUI\u0001\n\u0003\u0011\t\u0010C\u0005\u0003vB\u000b\t\u0011\"\u0011\u0003x\"I!q )\u0002\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0007\u0003\u0001\u0016\u0011!C\u0001\u0007\u0007C\u0011b!\u0004Q\u0003\u0003%\tea\u0004\t\u0013\ru\u0001+!A\u0005\u0002\r\u001d\u0005\"CB\u0012!\u0006\u0005I\u0011IBF\u0011%\u0019I\u0003UA\u0001\n\u0003\u001aY\u0003C\u0005\u0004.A\u000b\t\u0011\"\u0011\u0004\u0010\u001eI11\u0013\u001c\u0002\u0002#\u00051Q\u0013\u0004\n\u0007k2\u0014\u0011!E\u0001\u0007/Cq!!\u0003`\t\u0003\u0019y\nC\u0005\u0004R}\u000b\t\u0011\"\u0012\u0004T!I1QK0\u0002\u0002\u0013\u00055\u0011\u0015\u0005\n\u0007;z\u0016\u0011!CA\u0007KC\u0011b!\u001d`\u0003\u0003%Iaa\u001d\t\u000f\r-f\u0007\"\u0001\u0004.\nAB)\u0019;bM2|wo\u0012:ba\"$&/\u00198tM>\u0014X.\u001a:\u000b\u0005!L\u0017!B4sCBD'B\u00016l\u0003%\u0001\u0018\u000e]3mS:,7O\u0003\u0002m[\u0006\u00191/\u001d7\u000b\u00059|\u0017!B:qCJ\\'B\u00019r\u0003\u0019\t\u0007/Y2iK*\t!/A\u0002pe\u001e\u001c\u0001aE\u0002\u0001kv\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\t1\fgn\u001a\u0006\u0002u\u0006!!.\u0019<b\u0013\taxO\u0001\u0004PE*,7\r\u001e\t\u0003mzL!a`<\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f!\u0011\t\u0019!!\u0002\u000e\u0003\u001dL1!a\u0002h\u00055!\u0015\r^1gY><xI]1qQ\u00061A(\u001b8jiz\"B!!\u0004\u0002\u0010A\u0019\u00111\u0001\u0001\t\r!\u0014\u0001\u0019AA\u0001\u0003\u0019!\u0018M\u00197fgV\u0011\u0011Q\u0003\t\u0007\u0003/\tY#!\r\u000f\t\u0005e\u0011Q\u0005\b\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD:\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0019#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002(\u0005%\u0012a\u00029bG.\fw-\u001a\u0006\u0003\u0003GIA!!\f\u00020\t\u00191+Z9\u000b\t\u0005\u001d\u0012\u0011\u0006\t\u0005\u0003\u0007\t\u0019$C\u0002\u00026\u001d\u0014Q\u0001V1cY\u0016\f!\u0002^1cY\u0016\u001cx\fJ3r)\u0011\tY$a\u0011\u0011\t\u0005u\u0012qH\u0007\u0003\u0003SIA!!\u0011\u0002*\t!QK\\5u\u0011%\t)\u0005BA\u0001\u0002\u0004\t)\"A\u0002yIE\nq\u0001^1cY\u0016\u001c\b%\u0001\u0005uC\ndW-T1q+\t\ti\u0005\u0005\u0005\u0002P\u0005]\u0013QLA\u0019\u001d\u0011\t\t&a\u0015\u0011\t\u0005m\u0011\u0011F\u0005\u0005\u0003+\nI#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\nYFA\u0002NCBTA!!\u0016\u0002*A!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d-\f\u0001bY1uC2L8\u000f^\u0005\u0005\u0003O\n\tGA\bUC\ndW-\u00133f]RLg-[3s\u00031!\u0018M\u00197f\u001b\u0006\u0004x\fJ3r)\u0011\tY$!\u001c\t\u0013\u0005\u0015s!!AA\u0002\u00055\u0013!\u0003;bE2,W*\u00199!\u0003\u00151Gn\\<t+\t\t)\b\u0005\u0004\u0002\u0018\u0005-\u0012q\u000f\t\u0005\u0003\u0007\tI(C\u0002\u0002|\u001d\u0014AA\u00127po\u0006Ia\r\\8xg~#S-\u001d\u000b\u0005\u0003w\t\t\tC\u0005\u0002F)\t\t\u00111\u0001\u0002v\u00051a\r\\8xg\u0002\nqA\u001a7poN$v.\u0006\u0002\u0002\nBA\u0011qJA,\u0003;\n)(A\u0006gY><8\u000fV8`I\u0015\fH\u0003BA\u001e\u0003\u001fC\u0011\"!\u0012\u000e\u0003\u0003\u0005\r!!#\u0002\u0011\u0019dwn^:U_\u0002\nQA^5foN,\"!a&\u0011\r\u0005]\u00111FAM!\u0011\t\u0019!a'\n\u0007\u0005uuM\u0001\u0003WS\u0016<\u0018!\u0003<jK^\u001cx\fJ3r)\u0011\tY$a)\t\u0013\u0005\u0015\u0003#!AA\u0002\u0005]\u0015A\u0002<jK^\u001c\b%A\u0004wS\u0016<X*\u00199\u0016\u0005\u0005-\u0006\u0003CA(\u0003/\ni&!'\u0002\u0017YLWm^'ba~#S-\u001d\u000b\u0005\u0003w\t\t\fC\u0005\u0002FM\t\t\u00111\u0001\u0002,\u0006Aa/[3x\u001b\u0006\u0004\b%A\u0003tS:\\7/\u0006\u0002\u0002:B1\u0011qCA\u0016\u0003w\u0003B!a\u0001\u0002>&\u0019\u0011qX4\u0003\tMKgn[\u0001\ng&t7n]0%KF$B!a\u000f\u0002F\"I\u0011Q\t\f\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u0007g&t7n\u001d\u0011\u0002\u000fMLgn['baV\u0011\u0011Q\u001a\t\t\u0003\u001f\n9&!\u0018\u0002<\u0006Y1/\u001b8l\u001b\u0006\u0004x\fJ3r)\u0011\tY$a5\t\u0013\u0005\u0015\u0013$!AA\u0002\u00055\u0017\u0001C:j].l\u0015\r\u001d\u0011\u0002\u0017\u0019\f\u0017\u000e\\3e\r2|wo]\u000b\u0003\u00037\u0004b!a\u0006\u0002,\u0005u\u0007\u0003BA\u0002\u0003?L1!!9h\u0005]\u0011Vm]8mkRLwN\\\"p[BdW\r^3e\r2|w/A\bgC&dW\r\u001a$m_^\u001cx\fJ3r)\u0011\tY$a:\t\u0013\u0005\u0015C$!AA\u0002\u0005m\u0017\u0001\u00044bS2,GM\u00127poN\u0004\u0013\u0001\u00044bS2,G\rV1cY\u0016\u001c\u0018\u0001\u00054bS2,G\rV1cY\u0016\u001cx\fJ3r)\u0011\tY$!=\t\u0013\u0005\u0015s$!AA\u0002\u0005U\u0011!\u00044bS2,G\rV1cY\u0016\u001c\b%A\u0006gC&dW\rZ*j].\u001c\u0018a\u00044bS2,GmU5oWN|F%Z9\u0015\t\u0005m\u00121 \u0005\n\u0003\u000b\u0012\u0013\u0011!a\u0001\u0003s\u000bABZ1jY\u0016$7+\u001b8lg\u0002\n1\u0002]1sC2dW\r\\5t[V\u0011!1\u0001\t\u0005\u0003{\u0011)!\u0003\u0003\u0003\b\u0005%\"aA%oi\u0006a\u0001/\u0019:bY2,G.[:nA\u0005ab-\u001b=fIB{w\u000e\\#yK\u000e,Ho\u001c:J]&$\u0018.\u00197ju\u0016$WC\u0001B\b!\u0011\tiD!\u0005\n\t\tM\u0011\u0011\u0006\u0002\b\u0005>|G.Z1o\u0003\u00012\u0017\u000e_3e!>|G.\u0012=fGV$xN]%oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\t\u0005m\"\u0011\u0004\u0005\n\u0003\u000b:\u0013\u0011!a\u0001\u0005\u001f\tQDZ5yK\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0013:LG/[1mSj,G\rI\u0001\u0012M&DX\r\u001a)p_2,\u00050Z2vi>\u0014XC\u0001B\u0011!\u0011\u0011\u0019C!\f\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\t!bY8oGV\u0014(/\u001a8u\u0015\r\u0011Y#_\u0001\u0005kRLG.\u0003\u0003\u00030\t\u0015\"A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\fAb]3mM\u0016CXmY;u_J,\"A!\u000e\u0011\t\t\r\"qG\u0005\u0005\u0005s\u0011)CA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00035\u0019X\r\u001c4Fq\u0016\u001cW\u000f^8sA\u0005y1m\\7qkR,G+\u00192mK6\u000b\u0007\u000f\u0006\u0002\u0002N\u0005q1m\\7qkR,g+[3x\u001b\u0006\u0004HCAAV\u00039\u0019w.\u001c9vi\u0016\u001c\u0016N\\6NCB$\"!!4\u0002\u001d\r|W\u000e];uK\u001acwn^:U_R\u0011\u0011\u0011R\u0001\u0010iJ\fgn\u001d4pe6$\u0016M\u00197fgR!\u0011Q\u0002B)\u0011\u001d\u0011\u0019\u0006\ra\u0001\u0005+\n1\u0002\u001e:b]N4wN]7feBA\u0011Q\bB,\u0003c\t\t$\u0003\u0003\u0003Z\u0005%\"!\u0003$v]\u000e$\u0018n\u001c82\u0003I!(/\u00198tM>\u0014X\u000eR8x]:{G-Z:\u0015\r\u00055!q\fB8\u0011\u001d\u0011\u0019&\ra\u0001\u0005C\u0002\"\"!\u0010\u0003d\t\u001d$Q\u000eB7\u0013\u0011\u0011)'!\u000b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA\u0002\u0005SJ1Aa\u001bh\u000519%/\u00199i\u000b2,W.\u001a8u!\u0019\t9\"a\u000b\u0003h!I!\u0011O\u0019\u0011\u0002\u0003\u0007!qB\u0001\u0013I&\u001c\u0018M\u00197f!\u0006\u0014\u0018\r\u001c7fY&\u001cX.\u0001\u000fue\u0006t7OZ8s[\u0012{wO\u001c(pI\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]$\u0006\u0002B\b\u0005sZ#Aa\u001f\u0011\t\tu$qQ\u0007\u0003\u0005\u007fRAA!!\u0003\u0004\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005\u000b\u000bI#\u0001\u0006b]:|G/\u0019;j_:LAA!#\u0003\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!\u001d,G\u000fR1uC\u001adwn^$sCBDWCAA\u0001\u0003\u0015\u0019Gn\\:f)\t\tY$\u0001\rECR\fg\r\\8x\u000fJ\f\u0007\u000f\u001b+sC:\u001chm\u001c:nKJ\u00042!a\u00017'\r1$\u0011\u0014\t\u0005\u0003{\u0011Y*\u0003\u0003\u0003\u001e\u0006%\"AB!osJ+g\r\u0006\u0002\u0003\u0016\nyBK]1og\u001a|'/\u001c(pI\u0016\u0014V\r\u001e:zC\ndW-\u0012=dKB$\u0018n\u001c8\u0014\u0013a\u0012)Ka+\u0003:\n}\u0006\u0003BA\f\u0005OKAA!+\u00020\tIQ\t_2faRLwN\u001c\t\u0005\u0005[\u0013),\u0004\u0002\u00030*!!\u0011\u0017BZ\u0003\u001d\u0019wN\u001c;s_2TAAa\u000b\u0002*%!!q\u0017BX\u00051qun\u0015;bG.$&/Y2f!\u0011\tiDa/\n\t\tu\u0016\u0011\u0006\u0002\b!J|G-^2u!\u0011\t9B!1\n\t\t\r\u0017q\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0012I\u0006$\u0018m]3u\u0013\u0012,g\u000e^5gS\u0016\u0014XCAA/\u0003I!\u0017\r^1tKRLE-\u001a8uS\u001aLWM\u001d\u0011\u0002\u0015\u0019\f\u0017\u000e\\3e\u001d>$W-\u0006\u0002\u0003PB!\u00111\u0001Bi\u0013\r\u0011\u0019n\u001a\u0002\u0015%\u0016\u001cx\u000e\\;uS>tg)Y5mK\u00124En\\<\u0002\u0017\u0019\f\u0017\u000e\\3e\u001d>$W\r\t\u000b\u0007\u00053\u0014iNa8\u0011\u0007\tm\u0007(D\u00017\u0011\u001d\u0011)-\u0010a\u0001\u0003;BqAa3>\u0001\u0004\u0011y-\u0001\u0003d_BLHC\u0002Bm\u0005K\u00149\u000fC\u0005\u0003Fz\u0002\n\u00111\u0001\u0002^!I!1\u001a \u0011\u0002\u0003\u0007!qZ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iO\u000b\u0003\u0002^\te\u0014AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005gTCAa4\u0003z\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!?\u0011\u0007Y\u0014Y0C\u0002\u0003~^\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007\u000b\u0019Y\u0001\u0005\u0003\u0002>\r\u001d\u0011\u0002BB\u0005\u0003S\u00111!\u00118z\u0011%\t)eQA\u0001\u0002\u0004\u0011\u0019!A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019\t\u0002\u0005\u0004\u0004\u0014\re1QA\u0007\u0003\u0007+QAaa\u0006\u0002*\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rm1Q\u0003\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0010\r\u0005\u0002\"CA#\u000b\u0006\u0005\t\u0019AB\u0003\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\te8q\u0005\u0005\n\u0003\u000b2\u0015\u0011!a\u0001\u0005\u0007\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u0007\ta!Z9vC2\u001cH\u0003\u0002B\b\u0007cA\u0011\"!\u0012I\u0003\u0003\u0005\ra!\u0002\u0002?Q\u0013\u0018M\\:g_Jlgj\u001c3f%\u0016$(/_1cY\u0016,\u0005pY3qi&|g\u000eE\u0002\u0003\\*\u001bRASB\u001d\u0007\u000b\u0002\"ba\u000f\u0004B\u0005u#q\u001aBm\u001b\t\u0019iD\u0003\u0003\u0004@\u0005%\u0012a\u0002:v]RLW.Z\u0005\u0005\u0007\u0007\u001aiDA\tBEN$(/Y2u\rVt7\r^5p]J\u0002Baa\u0012\u0004N5\u00111\u0011\n\u0006\u0004\u0007\u0017J\u0018AA5p\u0013\u0011\u0011\u0019m!\u0013\u0015\u0005\rU\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\te\u0018!B1qa2LHC\u0002Bm\u00073\u001aY\u0006C\u0004\u0003F6\u0003\r!!\u0018\t\u000f\t-W\n1\u0001\u0003P\u00069QO\\1qa2LH\u0003BB1\u0007[\u0002b!!\u0010\u0004d\r\u001d\u0014\u0002BB3\u0003S\u0011aa\u00149uS>t\u0007\u0003CA\u001f\u0007S\niFa4\n\t\r-\u0014\u0011\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\r=d*!AA\u0002\te\u0017a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\tQO\u0001\u000fUe\u0006t7OZ8s[:{G-\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0014\u0013A\u0013)Ka+\u0003:\n}F\u0003BB>\u0007{\u00022Aa7Q\u0011\u001d\u0011Ym\u0015a\u0001\u0005\u001f$Baa\u001f\u0004\u0002\"I!1\u001a+\u0011\u0002\u0003\u0007!q\u001a\u000b\u0005\u0007\u000b\u0019)\tC\u0005\u0002Fa\u000b\t\u00111\u0001\u0003\u0004Q!!qBBE\u0011%\t)EWA\u0001\u0002\u0004\u0019)\u0001\u0006\u0003\u0003z\u000e5\u0005\"CA#7\u0006\u0005\t\u0019\u0001B\u0002)\u0011\u0011ya!%\t\u0013\u0005\u0015S,!AA\u0002\r\u0015\u0011\u0001\b+sC:\u001chm\u001c:n\u001d>$WMR1jY\u0016$W\t_2faRLwN\u001c\t\u0004\u00057|6#B0\u0004\u001a\u000e\u0015\u0003\u0003CB\u001e\u00077\u0013yma\u001f\n\t\ru5Q\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCABK)\u0011\u0019Yha)\t\u000f\t-'\r1\u0001\u0003PR!1qUBU!\u0019\tida\u0019\u0003P\"I1qN2\u0002\u0002\u0003\u000711P\u0001\u001do&$\b\u000eR1uC\u001adwn^$sCBDGK]1og\u001a|'/\\3s+\u0011\u0019yka.\u0015\t\rE6\u0011\u001a\u000b\u0005\u0007g\u001b\u0019\r\u0005\u0003\u00046\u000e]F\u0002\u0001\u0003\b\u0007s+'\u0019AB^\u0005\u0005!\u0016\u0003BB_\u0007\u000b\u0001B!!\u0010\u0004@&!1\u0011YA\u0015\u0005\u001dqu\u000e\u001e5j]\u001eDqa!2f\u0001\u0004\u00199-A\u0001g!!\tiDa\u0016\u0002\u000e\rM\u0006B\u00025f\u0001\u0004\t\t\u0001")
public class DataflowGraphTransformer
implements AutoCloseable {
    private ThreadPoolExecutor fixedPoolExecutor;
    private final DataflowGraph graph;
    private scala.collection.immutable.Seq<Table> tables;
    private Map<TableIdentifier, Table> tableMap;
    private scala.collection.immutable.Seq<Flow> flows;
    private Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> flowsTo;
    private scala.collection.immutable.Seq<View> views;
    private Map<TableIdentifier, View> viewMap;
    private scala.collection.immutable.Seq<Sink> sinks;
    private Map<TableIdentifier, Sink> sinkMap;
    private scala.collection.immutable.Seq<ResolutionCompletedFlow> failedFlows;
    private scala.collection.immutable.Seq<Table> failedTables;
    private scala.collection.immutable.Seq<Sink> failedSinks;
    private final int parallelism;
    private boolean fixedPoolExecutorInitialized;
    private final ExecutorService selfExecutor;
    private volatile boolean bitmap$0;

    public static <T> T withDataflowGraphTransformer(DataflowGraph graph, Function1<DataflowGraphTransformer, T> f) {
        return DataflowGraphTransformer$.MODULE$.withDataflowGraphTransformer(graph, f);
    }

    private scala.collection.immutable.Seq<Table> tables() {
        return this.tables;
    }

    private void tables_$eq(scala.collection.immutable.Seq<Table> x$1) {
        this.tables = x$1;
    }

    private Map<TableIdentifier, Table> tableMap() {
        return this.tableMap;
    }

    private void tableMap_$eq(Map<TableIdentifier, Table> x$1) {
        this.tableMap = x$1;
    }

    private scala.collection.immutable.Seq<Flow> flows() {
        return this.flows;
    }

    private void flows_$eq(scala.collection.immutable.Seq<Flow> x$1) {
        this.flows = x$1;
    }

    private Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> flowsTo() {
        return this.flowsTo;
    }

    private void flowsTo_$eq(Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> x$1) {
        this.flowsTo = x$1;
    }

    private scala.collection.immutable.Seq<View> views() {
        return this.views;
    }

    private void views_$eq(scala.collection.immutable.Seq<View> x$1) {
        this.views = x$1;
    }

    private Map<TableIdentifier, View> viewMap() {
        return this.viewMap;
    }

    private void viewMap_$eq(Map<TableIdentifier, View> x$1) {
        this.viewMap = x$1;
    }

    private scala.collection.immutable.Seq<Sink> sinks() {
        return this.sinks;
    }

    private void sinks_$eq(scala.collection.immutable.Seq<Sink> x$1) {
        this.sinks = x$1;
    }

    private Map<TableIdentifier, Sink> sinkMap() {
        return this.sinkMap;
    }

    private void sinkMap_$eq(Map<TableIdentifier, Sink> x$1) {
        this.sinkMap = x$1;
    }

    private scala.collection.immutable.Seq<ResolutionCompletedFlow> failedFlows() {
        return this.failedFlows;
    }

    private void failedFlows_$eq(scala.collection.immutable.Seq<ResolutionCompletedFlow> x$1) {
        this.failedFlows = x$1;
    }

    private scala.collection.immutable.Seq<Table> failedTables() {
        return this.failedTables;
    }

    private void failedTables_$eq(scala.collection.immutable.Seq<Table> x$1) {
        this.failedTables = x$1;
    }

    private scala.collection.immutable.Seq<Sink> failedSinks() {
        return this.failedSinks;
    }

    private void failedSinks_$eq(scala.collection.immutable.Seq<Sink> x$1) {
        this.failedSinks = x$1;
    }

    private int parallelism() {
        return this.parallelism;
    }

    private boolean fixedPoolExecutorInitialized() {
        return this.fixedPoolExecutorInitialized;
    }

    private void fixedPoolExecutorInitialized_$eq(boolean x$1) {
        this.fixedPoolExecutorInitialized = x$1;
    }

    private ThreadPoolExecutor fixedPoolExecutor$lzycompute() {
        DataflowGraphTransformer dataflowGraphTransformer = this;
        synchronized (dataflowGraphTransformer) {
            if (!this.bitmap$0) {
                this.fixedPoolExecutorInitialized_$eq(true);
                this.fixedPoolExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.parallelism(), "data-flow-graph-transformer-");
                this.bitmap$0 = true;
            }
        }
        return this.fixedPoolExecutor;
    }

    private ThreadPoolExecutor fixedPoolExecutor() {
        if (!this.bitmap$0) {
            return this.fixedPoolExecutor$lzycompute();
        }
        return this.fixedPoolExecutor;
    }

    private ExecutorService selfExecutor() {
        return this.selfExecutor;
    }

    private synchronized Map<TableIdentifier, Table> computeTableMap() {
        return ((IterableOnceOps)this.tables().map((Function1 & Serializable)table -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)table.identifier()), table))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, View> computeViewMap() {
        return ((IterableOnceOps)this.views().map((Function1 & Serializable)view -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)view.identifier()), view))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, Sink> computeSinkMap() {
        return ((IterableOnceOps)this.sinks().map((Function1 & Serializable)sink -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sink.identifier()), sink))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private synchronized Map<TableIdentifier, scala.collection.immutable.Seq<Flow>> computeFlowsTo() {
        return this.flows().groupBy((Function1 & Serializable)x$1 -> x$1.destinationIdentifier());
    }

    public synchronized DataflowGraphTransformer transformTables(Function1<Table, Table> transformer) {
        this.tables_$eq((scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().map(transformer)));
        this.tableMap_$eq(this.computeTableMap());
        return this;
    }

    public DataflowGraphTransformer transformDownNodes(Function2<GraphElement, scala.collection.immutable.Seq<GraphElement>, scala.collection.immutable.Seq<GraphElement>> transformer, boolean disableParallelism) {
        ExecutorService executor = disableParallelism ? this.selfExecutor() : this.fixedPoolExecutor();
        int batchSize = disableParallelism ? 1 : this.parallelism();
        ConcurrentLinkedQueue resolvedFlows2 = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedTables = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedViews = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue resolvedSinks = new ConcurrentLinkedQueue();
        ConcurrentHashMap resolvedFlowsMap = new ConcurrentHashMap();
        ConcurrentHashMap resolvedFlowDestinationsMap = new ConcurrentHashMap();
        ConcurrentLinkedQueue failedFlowsQueue = new ConcurrentLinkedQueue();
        ConcurrentHashMap failedDependentFlows = new ConcurrentHashMap();
        ObjectRef futures = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        ConcurrentLinkedDeque toBeResolvedFlows = new ConcurrentLinkedDeque();
        toBeResolvedFlows.addAll(CollectionConverters$.MODULE$.SeqHasAsJava(this.flows()).asJava());
        while (((ArrayBuffer)futures.elem).nonEmpty() || toBeResolvedFlows.peekFirst() != null) {
            Tuple2 tuple2 = ((ArrayBuffer)futures.elem).partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer done = (ArrayBuffer)tuple2._1();
            ArrayBuffer notDone = (ArrayBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)done, (Object)notDone);
            ArrayBuffer done2 = (ArrayBuffer)tuple22._1();
            ArrayBuffer notDone2 = (ArrayBuffer)tuple22._2();
            try {
                done2.foreach((Function1 & Serializable)x$4 -> {
                    x$4.get();
                    return BoxedUnit.UNIT;
                });
            }
            catch (ExecutionException exn) {
                throw exn.getCause();
            }
            futures.elem = notDone2;
            None$ flowOpt = ((ArrayBuffer)futures.elem).size() < batchSize ? Option$.MODULE$.apply(toBeResolvedFlows.pollFirst()) : None$.MODULE$;
            flowOpt.foreach((Function1 & Serializable)flow -> (ArrayBuffer)((ArrayBuffer)futures$1.elem).append(executor.submit(() -> {
                DataflowGraphTransformer.$anonfun$transformDownNodes$4(this, transformer, flow, resolvedFlowsMap, resolvedFlows2, failedDependentFlows, resolvedFlowDestinationsMap, toBeResolvedFlows, resolvedTables, resolvedViews, resolvedSinks, failedFlowsQueue);
                return BoxedUnit.UNIT;
            })));
        }
        this.failedTables_$eq((scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().filterNot((Function1 & Serializable)table -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$21(resolvedFlowDestinationsMap, table)))));
        this.failedSinks_$eq((scala.collection.immutable.Seq<Sink>)((scala.collection.immutable.Seq)this.sinks().filterNot((Function1 & Serializable)sink -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$22(resolvedFlowDestinationsMap, sink)))));
        Tuple2 tuple2 = CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedFlows2).asScala().toSeq().partition((Function1 & Serializable)flow -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$23(resolvedFlowDestinationsMap, flow)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq resolvedFlowsWithResolvedDest = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq resolvedFlowsWithFailedDest = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)resolvedFlowsWithResolvedDest, (Object)resolvedFlowsWithFailedDest);
        scala.collection.immutable.Seq resolvedFlowsWithResolvedDest2 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq resolvedFlowsWithFailedDest2 = (scala.collection.immutable.Seq)tuple23._2();
        this.failedFlows_$eq((scala.collection.immutable.Seq<ResolutionCompletedFlow>)((scala.collection.immutable.Seq)((IterableOps)resolvedFlowsWithFailedDest2.$plus$plus((IterableOnce)CollectionConverters$.MODULE$.CollectionHasAsScala(failedFlowsQueue).asScala().toSeq())).$plus$plus((IterableOnce)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(failedDependentFlows.values()).asScala().flatten(Predef$.MODULE$.$conforms())).toSeq())));
        this.flows_$eq((scala.collection.immutable.Seq<Flow>)resolvedFlowsWithResolvedDest2);
        this.flowsTo_$eq(this.computeFlowsTo());
        this.tables_$eq((scala.collection.immutable.Seq<Table>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedTables).asScala().toSeq());
        this.views_$eq((scala.collection.immutable.Seq<View>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedViews).asScala().toSeq());
        this.sinks_$eq((scala.collection.immutable.Seq<Sink>)CollectionConverters$.MODULE$.CollectionHasAsScala(resolvedSinks).asScala().toSeq());
        this.tableMap_$eq(this.computeTableMap());
        this.viewMap_$eq(this.computeViewMap());
        this.sinkMap_$eq(this.computeSinkMap());
        return this;
    }

    public boolean transformDownNodes$default$2() {
        return false;
    }

    public DataflowGraph getDataflowGraph() {
        return this.graph.copy((scala.collection.immutable.Seq<Flow>)((scala.collection.immutable.Seq)this.flows().$plus$plus(this.failedFlows())), (scala.collection.immutable.Seq<Table>)((scala.collection.immutable.Seq)this.tables().$plus$plus(this.failedTables())), (scala.collection.immutable.Seq<Sink>)((scala.collection.immutable.Seq)this.sinks().$plus$plus(this.failedSinks())), this.graph.copy$default$4());
    }

    @Override
    public void close() {
        if (this.fixedPoolExecutorInitialized()) {
            this.fixedPoolExecutor().shutdown();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$5(GraphElement x$5) {
        return x$5 instanceof ResolvedFlow;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$9(ConcurrentHashMap failedDependentFlows$1, TableIdentifier datasetIdentifier$1, ConcurrentLinkedDeque toBeResolvedFlows$1, TableIdentifier x$8, boolean resolved) {
        Object object = resolved ? failedDependentFlows$1.computeIfPresent(datasetIdentifier$1, (x$9, toRetryFlows) -> {
            toRetryFlows.foreach((Function1 & Serializable)x$10 -> {
                toBeResolvedFlows$1.addFirst(x$10);
                return BoxedUnit.UNIT;
            });
            return null;
        }) : BoxedUnit.UNIT;
        return resolved;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$13(BooleanRef isCurrentThreadLeader$1, TableIdentifier x$11) {
        isCurrentThreadLeader$1.elem = true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$15(GraphElement x$13) {
        return x$13 instanceof Sink;
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$18(ConcurrentHashMap failedDependentFlows$1, Flow flow$1, ConcurrentLinkedDeque toBeResolvedFlows$1, TableIdentifier x$15, boolean x$16) {
        failedDependentFlows$1.computeIfPresent(flow$1.destinationIdentifier(), (x$17, toRetryFlows) -> {
            toRetryFlows.foreach((Function1 & Serializable)x$18 -> {
                toBeResolvedFlows$1.addFirst(x$18);
                return BoxedUnit.UNIT;
            });
            return null;
        });
        return true;
    }

    public static final /* synthetic */ void $anonfun$transformDownNodes$4(DataflowGraphTransformer $this, Function2 transformer$1, Flow flow$1, ConcurrentHashMap resolvedFlowsMap$1, ConcurrentLinkedQueue resolvedFlows$1, ConcurrentHashMap failedDependentFlows$1, ConcurrentHashMap resolvedFlowDestinationsMap$1, ConcurrentLinkedDeque toBeResolvedFlows$1, ConcurrentLinkedQueue resolvedTables$1, ConcurrentLinkedQueue resolvedViews$1, ConcurrentLinkedQueue resolvedSinks$1, ConcurrentLinkedQueue failedFlowsQueue$1) {
        block12: {
            try {
                Object object;
                try {
                    scala.collection.immutable.Seq result = (scala.collection.immutable.Seq)transformer$1.apply((Object)flow$1, (Object)package$.MODULE$.Seq().empty());
                    Predef$.MODULE$.require(result.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$5(x$5))), (Function0 & Serializable)() -> "transformer must return a Seq[Flow]");
                    scala.collection.immutable.Seq transformedFlows = (scala.collection.immutable.Seq)result.map((Function1 & Serializable)x$6 -> (ResolvedFlow)x$6);
                    resolvedFlowsMap$1.put(flow$1.identifier(), transformedFlows);
                    object = BoxesRunTime.boxToBoolean((boolean)resolvedFlows$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformedFlows).asJava()));
                }
                catch (TransformNodeRetryableException e) {
                    TableIdentifier datasetIdentifier = e.datasetIdentifier();
                    failedDependentFlows$1.compute(datasetIdentifier, (x$7, flows) -> {
                        ResolutionFailedFlow failedFlow = e.failedNode();
                        if (flows == null) {
                            return new .colon.colon((Object)failedFlow, (List)Nil$.MODULE$);
                        }
                        return (scala.collection.immutable.Seq)flows.$colon$plus((Object)failedFlow);
                    });
                    object = resolvedFlowDestinationsMap$1.computeIfPresent(datasetIdentifier, (x$8, resolved) -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$9(failedDependentFlows$1, datasetIdentifier, toBeResolvedFlows$1, x$8, BoxesRunTime.unboxToBoolean((Object)resolved))));
                }
                catch (Throwable other) {
                    throw other;
                }
                if (!((IterableOnceOps)$this.flowsTo().apply((Object)flow$1.destinationIdentifier())).forall((Function1 & Serializable)flowToDestination -> BoxesRunTime.boxToBoolean((boolean)resolvedFlowsMap$1.containsKey(flowToDestination.identifier())))) break block12;
                BooleanRef isCurrentThreadLeader = BooleanRef.create((boolean)false);
                resolvedFlowDestinationsMap$1.computeIfAbsent(flow$1.destinationIdentifier(), x$11 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$13(isCurrentThreadLeader, x$11)));
                if (isCurrentThreadLeader.elem) {
                    if ($this.tableMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.tableMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        resolvedTables$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends GraphElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof Table) {
                                    Table table = (Table)A1;
                                    return (B1)table;
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(GraphElement x1) {
                                GraphElement graphElement = x1;
                                return graphElement instanceof Table;
                            }
                        })).asJava());
                        v1 = resolvedFlows$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends GraphElement, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                A1 A1 = x2;
                                if (A1 instanceof ResolvedFlow) {
                                    ResolvedFlow resolvedFlow = (ResolvedFlow)A1;
                                    return (B1)resolvedFlow;
                                }
                                return (B1)function1.apply(x2);
                            }

                            public final boolean isDefinedAt(GraphElement x2) {
                                GraphElement graphElement = x2;
                                return graphElement instanceof ResolvedFlow;
                            }
                        })).asJava());
                    } else if ($this.viewMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.viewMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        v1 = resolvedViews$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.map((Function1 & Serializable)x$12 -> (View)x$12)).asJava());
                    } else if ($this.sinkMap().contains((Object)flow$1.destinationIdentifier())) {
                        scala.collection.immutable.Seq transformed = (scala.collection.immutable.Seq)transformer$1.apply($this.sinkMap().apply((Object)flow$1.destinationIdentifier()), $this.flowsTo().apply((Object)flow$1.destinationIdentifier()));
                        Predef$.MODULE$.require(transformed.forall((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$15(x$13))), (Function0 & Serializable)() -> "transformer must return a Seq[Sink]");
                        v1 = resolvedSinks$1.addAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)transformed.map((Function1 & Serializable)x$14 -> (Sink)x$14)).asJava());
                    } else {
                        throw new IllegalArgumentException("Unsupported destination " + flow$1.destinationIdentifier().unquotedString() + " in flow: " + flow$1.displayName() + " at transformDownNodes");
                    }
                    resolvedFlowDestinationsMap$1.computeIfPresent(flow$1.destinationIdentifier(), (x$15, x$16) -> BoxesRunTime.boxToBoolean((boolean)DataflowGraphTransformer.$anonfun$transformDownNodes$18(failedDependentFlows$1, flow$1, toBeResolvedFlows$1, x$15, BoxesRunTime.unboxToBoolean((Object)x$16))));
                }
            }
            catch (TransformNodeFailedException ex) {
                failedFlowsQueue$1.add(ex.failedNode());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$21(ConcurrentHashMap resolvedFlowDestinationsMap$1, Table table) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(table.identifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$22(ConcurrentHashMap resolvedFlowDestinationsMap$1, Sink sink) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(sink.identifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public static final /* synthetic */ boolean $anonfun$transformDownNodes$23(ConcurrentHashMap resolvedFlowDestinationsMap$1, ResolutionCompletedFlow flow) {
        return BoxesRunTime.unboxToBoolean((Object)resolvedFlowDestinationsMap$1.getOrDefault(flow.destinationIdentifier(), BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public DataflowGraphTransformer(DataflowGraph graph) {
        this.graph = graph;
        this.tables = graph.tables();
        this.tableMap = this.computeTableMap();
        this.flows = graph.flows();
        this.flowsTo = this.computeFlowsTo();
        this.views = graph.views();
        this.viewMap = this.computeViewMap();
        this.sinks = graph.sinks();
        this.sinkMap = this.computeSinkMap();
        this.failedFlows = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.failedTables = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.failedSinks = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        this.parallelism = 10;
        this.fixedPoolExecutorInitialized = false;
        this.selfExecutor = ThreadUtils$.MODULE$.sameThreadExecutorService();
    }

    public static class TransformNodeFailedException
    extends Exception
    implements NoStackTrace,
    Product {
        private final ResolutionFailedFlow failedNode;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public ResolutionFailedFlow failedNode() {
            return this.failedNode;
        }

        public TransformNodeFailedException copy(ResolutionFailedFlow failedNode) {
            return new TransformNodeFailedException(failedNode);
        }

        public ResolutionFailedFlow copy$default$1() {
            return this.failedNode();
        }

        public String productPrefix() {
            return "TransformNodeFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.failedNode();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TransformNodeFailedException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "failedNode";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1007710952, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TransformNodeFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            TransformNodeFailedException transformNodeFailedException = (TransformNodeFailedException)x$1;
            ResolutionFailedFlow resolutionFailedFlow = this.failedNode();
            ResolutionFailedFlow resolutionFailedFlow2 = transformNodeFailedException.failedNode();
            if (resolutionFailedFlow == null) {
                if (resolutionFailedFlow2 != null) {
                    return false;
                }
            } else if (!resolutionFailedFlow.equals(resolutionFailedFlow2)) return false;
            if (!transformNodeFailedException.canEqual(this)) return false;
            return true;
        }

        public TransformNodeFailedException(ResolutionFailedFlow failedNode) {
            this.failedNode = failedNode;
            NoStackTrace.$init$((NoStackTrace)this);
            Product.$init$((Product)this);
        }
    }

    public static class TransformNodeRetryableException
    extends Exception
    implements NoStackTrace,
    Product {
        private final TableIdentifier datasetIdentifier;
        private final ResolutionFailedFlow failedNode;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public TableIdentifier datasetIdentifier() {
            return this.datasetIdentifier;
        }

        public ResolutionFailedFlow failedNode() {
            return this.failedNode;
        }

        public TransformNodeRetryableException copy(TableIdentifier datasetIdentifier, ResolutionFailedFlow failedNode) {
            return new TransformNodeRetryableException(datasetIdentifier, failedNode);
        }

        public TableIdentifier copy$default$1() {
            return this.datasetIdentifier();
        }

        public ResolutionFailedFlow copy$default$2() {
            return this.failedNode();
        }

        public String productPrefix() {
            return "TransformNodeRetryableException";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.datasetIdentifier();
                }
                case 1: {
                    return this.failedNode();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TransformNodeRetryableException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "datasetIdentifier";
                }
                case 1: {
                    return "failedNode";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 460780554, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TransformNodeRetryableException)) return false;
            boolean bl = true;
            if (!bl) return false;
            TransformNodeRetryableException transformNodeRetryableException = (TransformNodeRetryableException)x$1;
            TableIdentifier tableIdentifier = this.datasetIdentifier();
            TableIdentifier tableIdentifier2 = transformNodeRetryableException.datasetIdentifier();
            if (tableIdentifier == null) {
                if (tableIdentifier2 != null) {
                    return false;
                }
            } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
            ResolutionFailedFlow resolutionFailedFlow = this.failedNode();
            ResolutionFailedFlow resolutionFailedFlow2 = transformNodeRetryableException.failedNode();
            if (resolutionFailedFlow == null) {
                if (resolutionFailedFlow2 != null) {
                    return false;
                }
            } else if (!resolutionFailedFlow.equals(resolutionFailedFlow2)) return false;
            if (!transformNodeRetryableException.canEqual(this)) return false;
            return true;
        }

        public TransformNodeRetryableException(TableIdentifier datasetIdentifier, ResolutionFailedFlow failedNode) {
            this.datasetIdentifier = datasetIdentifier;
            this.failedNode = failedNode;
            NoStackTrace.$init$((NoStackTrace)this);
            Product.$init$((Product)this);
        }
    }
}

